"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.samplePanelName = exports.createDemoPanel = exports.CUSTOM_PANEL_SLICE = exports.CUSTOM_PANELS_SAVED_OBJECT_TYPE = exports.CUSTOM_PANELS_DOCUMENTATION_URL = exports.CUSTOM_PANELS_API_PREFIX = exports.CREATE_PANEL_MESSAGE = void 0;

var _uuid = require("uuid");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const CUSTOM_PANELS_API_PREFIX = '/api/observability/operational_panels';
exports.CUSTOM_PANELS_API_PREFIX = CUSTOM_PANELS_API_PREFIX;
const CUSTOM_PANELS_DOCUMENTATION_URL = 'https://opensearch.org/docs/latest/observability-plugin/operational-panels/';
exports.CUSTOM_PANELS_DOCUMENTATION_URL = CUSTOM_PANELS_DOCUMENTATION_URL;
const CREATE_PANEL_MESSAGE = 'Enter a name to describe the purpose of this Observability Dashboard.';
exports.CREATE_PANEL_MESSAGE = CREATE_PANEL_MESSAGE;
const CUSTOM_PANELS_SAVED_OBJECT_TYPE = 'observability-panel';
exports.CUSTOM_PANELS_SAVED_OBJECT_TYPE = CUSTOM_PANELS_SAVED_OBJECT_TYPE;
const CUSTOM_PANEL_SLICE = 'customPanel';
exports.CUSTOM_PANEL_SLICE = CUSTOM_PANEL_SLICE;
const samplePanelName = '[Logs] Web traffic Panel';
exports.samplePanelName = samplePanelName;

const createDemoPanel = savedVisualizationIds => {
  return {
    name: samplePanelName,
    visualizations: [{
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[0],
      x: 4,
      y: 6,
      w: 8,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[1],
      x: 0,
      y: 2,
      w: 12,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[2],
      x: 0,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[3],
      x: 4,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[4],
      x: 8,
      y: 0,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[5],
      x: 0,
      y: 4,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[6],
      x: 0,
      y: 6,
      w: 4,
      h: 2
    }, {
      id: 'panel_viz_' + (0, _uuid.v4)(),
      savedVisualizationId: savedVisualizationIds[7],
      x: 4,
      y: 4,
      w: 8,
      h: 2
    }],
    timeRange: {
      to: 'now/y',
      from: 'now/y'
    },
    queryFilter: {
      query: '',
      language: 'ppl'
    }
  };
};

exports.createDemoPanel = createDemoPanel;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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