
#ifndef PURPOSEWIDGETS_EXPORT_H
#define PURPOSEWIDGETS_EXPORT_H

#ifdef PURPOSEWIDGETS_STATIC_DEFINE
#  define PURPOSEWIDGETS_EXPORT
#  define PURPOSEWIDGETS_NO_EXPORT
#else
#  ifndef PURPOSEWIDGETS_EXPORT
#    ifdef KF5PurposeWidgets_EXPORTS
        /* We are building this library */
#      define PURPOSEWIDGETS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define PURPOSEWIDGETS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef PURPOSEWIDGETS_NO_EXPORT
#    define PURPOSEWIDGETS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef PURPOSEWIDGETS_DECL_DEPRECATED
#  define PURPOSEWIDGETS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef PURPOSEWIDGETS_DECL_DEPRECATED_EXPORT
#  define PURPOSEWIDGETS_DECL_DEPRECATED_EXPORT PURPOSEWIDGETS_EXPORT PURPOSEWIDGETS_DECL_DEPRECATED
#endif

#ifndef PURPOSEWIDGETS_DECL_DEPRECATED_NO_EXPORT
#  define PURPOSEWIDGETS_DECL_DEPRECATED_NO_EXPORT PURPOSEWIDGETS_NO_EXPORT PURPOSEWIDGETS_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef PURPOSEWIDGETS_NO_DEPRECATED
#    define PURPOSEWIDGETS_NO_DEPRECATED
#  endif
#endif

#define PURPOSEWIDGETS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(PURPOSEWIDGETS_NO_DEPRECATED) && !defined(PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define PURPOSEWIDGETS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(PURPOSEWIDGETS_NO_DEPRECATED_WARNINGS) && !defined(PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define PURPOSEWIDGETS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(PURPOSEWIDGETS_NO_DEPRECATED)
#  undef PURPOSEWIDGETS_DEPRECATED
#  define PURPOSEWIDGETS_DEPRECATED_EXPORT PURPOSEWIDGETS_EXPORT
#  define PURPOSEWIDGETS_DEPRECATED_NO_EXPORT PURPOSEWIDGETS_NO_EXPORT
#elif defined(PURPOSEWIDGETS_NO_DEPRECATED_WARNINGS)
#  define PURPOSEWIDGETS_DEPRECATED
#  define PURPOSEWIDGETS_DEPRECATED_EXPORT PURPOSEWIDGETS_EXPORT
#  define PURPOSEWIDGETS_DEPRECATED_NO_EXPORT PURPOSEWIDGETS_NO_EXPORT
#else
#  define PURPOSEWIDGETS_DEPRECATED PURPOSEWIDGETS_DECL_DEPRECATED
#  define PURPOSEWIDGETS_DEPRECATED_EXPORT PURPOSEWIDGETS_DECL_DEPRECATED_EXPORT
#  define PURPOSEWIDGETS_DEPRECATED_NO_EXPORT PURPOSEWIDGETS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define PURPOSEWIDGETS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define PURPOSEWIDGETS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef PURPOSEWIDGETS_NO_DEPRECATED
#  define PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x56e00
#endif
#ifdef PURPOSEWIDGETS_NO_DEPRECATED_WARNINGS
#  define PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE
#  ifdef PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE 0x56e00
#  endif
#endif

#ifndef PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef PURPOSEWIDGETS_DEPRECATED
#  define PURPOSEWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > PURPOSEWIDGETS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define PURPOSEWIDGETS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if PURPOSEWIDGETS_DEPRECATED_WARNINGS_SINCE >= 0x56800
#  define PURPOSEWIDGETS_DEPRECATED_VERSION_5_104(text) PURPOSEWIDGETS_DECL_DEPRECATED_TEXT(text)
#else
#  define PURPOSEWIDGETS_DEPRECATED_VERSION_5_104(text)
#endif
#define PURPOSEWIDGETS_DEPRECATED_VERSION_5(minor, text)      PURPOSEWIDGETS_DEPRECATED_VERSION_5_##minor(text)
#define PURPOSEWIDGETS_DEPRECATED_VERSION(major, minor, text) PURPOSEWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define PURPOSEWIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) PURPOSEWIDGETS_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define PURPOSEWIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) PURPOSEWIDGETS_DEPRECATED_VERSION(major, minor, text)
#  define PURPOSEWIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) PURPOSEWIDGETS_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define PURPOSEWIDGETS_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define PURPOSEWIDGETS_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* PURPOSEWIDGETS_EXPORT_H */
