/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.security;

import com.google.inject.Injector;
import jakarta.annotation.security.PermitAll;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.api.security.LoginService;
import org.traccar.api.security.PermissionsService;
import org.traccar.api.security.UserPrincipal;
import org.traccar.api.security.UserSecurityContext;
import org.traccar.database.StatisticsManager;
import org.traccar.helper.DataConverter;
import org.traccar.model.User;
import org.traccar.storage.StorageException;

public class SecurityRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityRequestFilter.class);
    @Context
    private HttpServletRequest request;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private LoginService loginService;
    @Inject
    private StatisticsManager statisticsManager;
    @Inject
    private Injector injector;

    public static String[] decodeBasicAuth(String auth) {
        byte[] decodedBytes = DataConverter.parseBase64(auth = auth.replaceFirst("[B|b]asic ", ""));
        if (decodedBytes != null && decodedBytes.length > 0) {
            return new String(decodedBytes, StandardCharsets.US_ASCII).split(":", 2);
        }
        return null;
    }

    public void filter(ContainerRequestContext requestContext) {
        UserSecurityContext securityContext;
        block14: {
            if (requestContext.getMethod().equals("OPTIONS")) {
                return;
            }
            securityContext = null;
            try {
                User user;
                Long userId;
                String authHeader = requestContext.getHeaderString("Authorization");
                if (authHeader != null) {
                    try {
                        User user2;
                        if (authHeader.startsWith("Bearer ")) {
                            user2 = this.loginService.login(authHeader.substring(7));
                        } else {
                            String[] auth = SecurityRequestFilter.decodeBasicAuth(authHeader);
                            user2 = this.loginService.login(auth[0], auth[1]);
                        }
                        if (user2 != null) {
                            this.statisticsManager.registerRequest(user2.getId());
                            securityContext = new UserSecurityContext(new UserPrincipal(user2.getId()));
                        }
                        break block14;
                    }
                    catch (IOException | GeneralSecurityException | StorageException e) {
                        throw new WebApplicationException((Throwable)e);
                    }
                }
                if (this.request.getSession() != null && (userId = (Long)this.request.getSession().getAttribute("userId")) != null && (user = ((PermissionsService)this.injector.getInstance(PermissionsService.class)).getUser(userId)) != null) {
                    user.checkDisabled();
                    this.statisticsManager.registerRequest(userId);
                    securityContext = new UserSecurityContext(new UserPrincipal(userId));
                }
            }
            catch (SecurityException | StorageException e) {
                LOGGER.warn("Authentication error", (Throwable)e);
            }
        }
        if (securityContext != null) {
            requestContext.setSecurityContext(securityContext);
        } else {
            Method method = this.resourceInfo.getResourceMethod();
            if (!method.isAnnotationPresent(PermitAll.class)) {
                Response.ResponseBuilder responseBuilder = Response.status((Response.Status)Response.Status.UNAUTHORIZED);
                String accept = this.request.getHeader("Accept");
                if (accept != null && accept.contains("text/html")) {
                    responseBuilder.header("WWW-Authenticate", (Object)"Basic realm=\"api\"");
                }
                throw new WebApplicationException(responseBuilder.build());
            }
        }
    }
}

