/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation.data;

import com.shapesecurity.salvation.interfaces.Show;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Base64Value
implements Show {
    @Nonnull
    public final String value;
    @Nonnull
    private final byte[] decoded;

    public Base64Value(@Nonnull String value) {
        Base64Value.validate(value);
        this.value = value;
        this.decoded = Base64.getDecoder().decode(value);
    }

    public static void validate(String value) throws IllegalArgumentException {
        int i;
        byte[] chars = value.getBytes(StandardCharsets.US_ASCII);
        if (chars.length % 4 != 0) {
            throw new IllegalArgumentException("Invalid base64-value (should be multiple of 4 bytes: " + chars.length + ").");
        }
        for (i = 0; i < chars.length && chars[i] != 61; ++i) {
            if (Base64Value.isBase64Char(chars[i])) continue;
            throw new IllegalArgumentException("Invalid base64-value (characters are not in the base64-value grammar).");
        }
        if (i < chars.length - 2) {
            throw new IllegalArgumentException("Invalid base64-value (bad padding).");
        }
        while (i < chars.length) {
            if (chars[i] != 61) {
                throw new IllegalArgumentException("Invalid base64-value padding (illegal characters).");
            }
            ++i;
        }
        if (chars.length < 4) {
            throw new IllegalArgumentException("Invalid base64-value (too short: " + chars.length + ").");
        }
    }

    public static boolean isBase64Char(byte ch) {
        return 48 <= ch && ch <= 57 || 65 <= ch && ch <= 90 || 97 <= ch && ch <= 122 || ch == 43 || ch == 47 || ch == 45 || ch == 95;
    }

    public int size() {
        return this.decoded.length;
    }

    public ByteBuffer decodedBytes() {
        return ByteBuffer.wrap(this.decoded).asReadOnlyBuffer();
    }

    public boolean equals(@Nullable Object other) {
        return other != null && other instanceof Base64Value && this.value.equals(((Base64Value)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    @Nonnull
    public String show() {
        return this.value;
    }
}

