/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialization;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.gradle.internal.Try;

public abstract class Cached<T> {
    public static <T> Cached<T> of(Callable<T> computation) {
        return new Deferred<T>(computation);
    }

    public abstract T get();

    private static class Fixed<T>
    extends Cached<T> {
        private final Try<T> result;

        public Fixed(Try<T> result) {
            this.result = result;
        }

        @Override
        public T get() {
            return this.result.get();
        }
    }

    private static class Deferred<T>
    extends Cached<T>
    implements Serializable {
        private Callable<T> computation;
        private Try<T> result;

        public Deferred(Callable<T> computation) {
            this.computation = computation;
        }

        @Override
        public T get() {
            return this.result().get();
        }

        private Try<T> result() {
            if (this.result == null) {
                this.result = Try.ofFailable(this.computation);
                this.computation = null;
            }
            return this.result;
        }

        private Object writeReplace() {
            return new Fixed<T>(this.result());
        }
    }
}

