/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.initialization.BuildLayoutParametersBuildOptions;
import org.gradle.initialization.ParallelismBuildOptions;
import org.gradle.initialization.StartParameterBuildOptions;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.buildoption.BuildOption;
import org.gradle.internal.logging.LoggingConfigurationBuildOptions;
import org.gradle.launcher.cli.converter.WelcomeMessageBuildOptions;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.util.internal.CollectionUtils;

public class LayoutToPropertiesConverter {
    private final List<BuildOption<?>> allBuildOptions = new ArrayList();
    private final BuildLayoutFactory buildLayoutFactory;

    public LayoutToPropertiesConverter(BuildLayoutFactory buildLayoutFactory) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.allBuildOptions.addAll(new BuildLayoutParametersBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new StartParameterBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new LoggingConfigurationBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new WelcomeMessageBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new DaemonBuildOptions().getAllOptions());
        this.allBuildOptions.addAll(new ParallelismBuildOptions().getAllOptions());
    }

    public AllProperties convert(InitialProperties initialProperties, BuildLayoutResult layout) {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.configureFromHomeDir(layout.getGradleInstallationHomeDir(), properties);
        this.configureFromBuildDir(layout, properties);
        this.configureFromHomeDir(layout.getGradleUserHomeDir(), properties);
        this.configureFromSystemPropertiesOfThisJvm((Map)Cast.uncheckedNonnullCast(properties));
        properties.putAll(initialProperties.getRequestedSystemProperties());
        return new Result(properties, initialProperties);
    }

    private void configureFromSystemPropertiesOfThisJvm(Map<Object, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (!(key instanceof Serializable) || !(value instanceof Serializable) && value != null) continue;
            properties.put(key, value);
        }
    }

    private void configureFromHomeDir(File gradleUserHomeDir, Map<String, String> result) {
        this.maybeConfigureFrom(new File(gradleUserHomeDir, "gradle.properties"), result);
    }

    private void configureFromBuildDir(BuildLayoutResult layoutResult, Map<String, String> result) {
        BuildLayout layout = this.buildLayoutFactory.getLayoutFor(layoutResult.toLayoutConfiguration());
        this.maybeConfigureFrom(new File(layout.getRootDirectory(), "gradle.properties"), result);
    }

    private void maybeConfigureFrom(File propertiesFile, Map<String, String> result) {
        if (!propertiesFile.isFile()) {
            return;
        }
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (Object key : properties.keySet()) {
            final String keyAsString = key.toString();
            BuildOption<?> validOption = CollectionUtils.findFirst(this.allBuildOptions, new Spec<BuildOption<?>>(){

                @Override
                public boolean isSatisfiedBy(BuildOption<?> option) {
                    return keyAsString.equals(option.getGradleProperty()) || keyAsString.equals(option.getDeprecatedGradleProperty());
                }
            });
            if (validOption == null) continue;
            result.put(key.toString(), properties.get(key).toString());
        }
    }

    private static class Result
    implements AllProperties {
        private final Map<String, String> properties;
        private final InitialProperties initialProperties;

        public Result(Map<String, String> properties, InitialProperties initialProperties) {
            this.properties = properties;
            this.initialProperties = initialProperties;
        }

        @Override
        public Map<String, String> getRequestedSystemProperties() {
            return this.initialProperties.getRequestedSystemProperties();
        }

        @Override
        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        @Override
        public Result merge(Map<String, String> systemProperties) {
            HashMap<String, String> properties = new HashMap<String, String>(this.properties);
            properties.putAll(systemProperties);
            properties.putAll(this.initialProperties.getRequestedSystemProperties());
            return new Result(properties, this.initialProperties);
        }
    }
}

