/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicDomainHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value2) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value2)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        if (value2.endsWith(".")) {
            return;
        }
        String domain2 = value2;
        if (domain2.startsWith(".")) {
            domain2 = domain2.substring(1);
        }
        domain2 = domain2.toLowerCase(Locale.ROOT);
        cookie.setDomain(domain2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            throw new CookieRestrictionViolationException("Cookie 'domain' may not be null");
        }
        if (!host.equals(domain2) && !BasicDomainHandler.domainMatch(domain2, host)) {
            throw new CookieRestrictionViolationException("Illegal 'domain' attribute \"" + domain2 + "\". Domain of origin: \"" + host + "\"");
        }
    }

    static boolean domainMatch(String domain2, String host) {
        String normalizedDomain;
        if (InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host)) {
            return false;
        }
        String string = normalizedDomain = domain2.startsWith(".") ? domain2.substring(1) : domain2;
        if (host.endsWith(normalizedDomain)) {
            int prefix = host.length() - normalizedDomain.length();
            if (prefix == 0) {
                return true;
            }
            if (prefix > 1 && host.charAt(prefix - 1) == '.') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            return false;
        }
        if (domain2.startsWith(".")) {
            domain2 = domain2.substring(1);
        }
        if (host.equals(domain2 = domain2.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            return BasicDomainHandler.domainMatch(domain2, host);
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

