/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.digests.NullDigest;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsECDSA13Signer
extends BcTlsSigner {
    private final int signatureScheme;

    public BcTlsECDSA13Signer(BcTlsCrypto bcTlsCrypto, ECPrivateKeyParameters eCPrivateKeyParameters, int n) {
        super(bcTlsCrypto, eCPrivateKeyParameters);
        if (!SignatureScheme.isECDSA(n)) {
            throw new IllegalArgumentException("signatureScheme");
        }
        this.signatureScheme = n;
    }

    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray) throws IOException {
        if (signatureAndHashAlgorithm == null || SignatureScheme.from(signatureAndHashAlgorithm) != this.signatureScheme) {
            throw new IllegalStateException("Invalid algorithm: " + signatureAndHashAlgorithm);
        }
        int n = SignatureScheme.getCryptoHashAlgorithm(this.signatureScheme);
        ECDSASigner eCDSASigner = new ECDSASigner(new HMacDSAKCalculator(this.crypto.createDigest(n)));
        DSADigestSigner dSADigestSigner = new DSADigestSigner(eCDSASigner, new NullDigest());
        dSADigestSigner.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        dSADigestSigner.update(byArray, 0, byArray.length);
        try {
            return dSADigestSigner.generateSignature();
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80, (Throwable)cryptoException);
        }
    }
}

