/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\b\u0007\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B+\u0012\u001a\b\u0002\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u0006\u0010\u0013\u001a\u00020\u0000J\u001b\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0006\u0010\u0017\u001a\u00020\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jitsi/nlj/EventTimeline;", "", "Lkotlin/Pair;", "", "Ljava/time/Duration;", "timeline", "", "clock", "Ljava/time/Clock;", "(Ljava/util/List;Ljava/time/Clock;)V", "referenceTime", "Ljava/time/Instant;", "getReferenceTime", "()Ljava/time/Instant;", "setReferenceTime", "(Ljava/time/Instant;)V", "addEvent", "", "desc", "clone", "iterator", "", "toString", "totalDelay", "jitsi-media-transform"})
@SuppressFBWarnings(value={"CN_IMPLEMENTS_CLONE_BUT_NOT_CLONEABLE"})
public final class EventTimeline
implements Iterable<Pair<? extends String, ? extends Duration>>,
KMappedMarker {
    @NotNull
    private final List<Pair<String, Duration>> timeline;
    @NotNull
    private final Clock clock;
    @Nullable
    private Instant referenceTime;

    public EventTimeline(@NotNull List<Pair<String, Duration>> timeline, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(timeline, "timeline");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.timeline = timeline;
        this.clock = clock;
    }

    public /* synthetic */ EventTimeline(List list, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue(clock2, "systemUTC()");
            clock = clock2;
        }
        this(list, clock);
    }

    @Nullable
    public final Instant getReferenceTime() {
        return this.referenceTime;
    }

    public final void setReferenceTime(@Nullable Instant instant) {
        this.referenceTime = instant;
    }

    public final void addEvent(@NotNull String desc) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        Instant now = this.clock.instant();
        if (this.referenceTime == null) {
            this.referenceTime = now;
        }
        this.timeline.add(TuplesKt.to(desc, Duration.between(this.referenceTime, now)));
    }

    @NotNull
    public final EventTimeline clone() {
        EventTimeline clone = new EventTimeline(CollectionsKt.toMutableList((Collection)this.timeline), null, 2, null);
        clone.referenceTime = this.referenceTime;
        return clone;
    }

    @Override
    @NotNull
    public Iterator<Pair<String, Duration>> iterator() {
        return this.timeline.iterator();
    }

    @NotNull
    public final Duration totalDelay() {
        Instant instant = this.referenceTime;
        if (instant != null) {
            Instant it = instant;
            boolean bl = false;
            return CollectionsKt.last(this.timeline).getSecond();
        }
        Duration duration = Duration.ofMillis(-1L);
        Intrinsics.checkNotNullExpressionValue(duration, "ofMillis(-1)");
        return duration;
    }

    @NotNull
    public String toString() {
        StringBuffer $this$toString_u24lambda_u2d3;
        block3: {
            Comparable<Instant> comparable;
            block2: {
                $this$toString_u24lambda_u2d3 = new StringBuffer();
                boolean bl = false;
                comparable = this.referenceTime;
                if (comparable == null) break block2;
                Instant it = comparable;
                boolean bl2 = false;
                $this$toString_u24lambda_u2d3.append("Reference time: " + this.referenceTime + "; ");
                StringBuffer stringBuffer = $this$toString_u24lambda_u2d3.append(CollectionsKt.joinToString$default(this.timeline, "; ", null, null, 0, null, null, 62, null));
                comparable = stringBuffer;
                if (stringBuffer != null) break block3;
            }
            StringBuffer $this$toString_u24lambda_u2d3_u24lambda_u2d2 = $this$toString_u24lambda_u2d3;
            boolean bl = false;
            comparable = $this$toString_u24lambda_u2d3_u24lambda_u2d2.append("[No timeline]");
        }
        String string = $this$toString_u24lambda_u2d3.toString();
        Intrinsics.checkNotNullExpressionValue(string, "with(StringBuffer()) {\n \u2026     toString()\n        }");
        return string;
    }

    public EventTimeline() {
        this(null, null, 3, null);
    }
}

