/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtp.RtpPacket;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/SdesHeaderExtension;", "", "()V", "Companion", "rtp"})
public final class SdesHeaderExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/SdesHeaderExtension$Companion;", "", "()V", "getTextValue", "", "buf", "", "offset", "", "dataLength", "ext", "Lorg/jitsi/rtp/rtp/RtpPacket$HeaderExtension;", "setTextValue", "", "sdesValue", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTextValue(@NotNull RtpPacket.HeaderExtension ext) {
            Intrinsics.checkNotNullParameter(ext, "ext");
            return this.getTextValue(ext.getBuffer(), ext.getDataOffset(), ext.getDataLengthBytes());
        }

        public final void setTextValue(@NotNull RtpPacket.HeaderExtension ext, @NotNull String sdesValue) {
            boolean bl;
            Intrinsics.checkNotNullParameter(ext, "ext");
            Intrinsics.checkNotNullParameter(sdesValue, "sdesValue");
            boolean bl2 = bl = ext.getDataLengthBytes() == sdesValue.length();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "buffer size doesn't match SDES value length";
                throw new AssertionError((Object)string);
            }
            this.setTextValue(ext.getBuffer(), ext.getDataOffset(), sdesValue);
        }

        private final String getTextValue(byte[] buf, int offset, int dataLength) {
            Charset charset = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
            Charset charset2 = charset;
            return new String(buf, offset, dataLength, charset2);
        }

        private final void setTextValue(byte[] buf, int offset, String sdesValue) {
            String string = sdesValue;
            Charset charset = StandardCharsets.US_ASCII;
            Intrinsics.checkNotNullExpressionValue(charset, "US_ASCII");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
            System.arraycopy(byArray, 0, buf, offset, sdesValue.length());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

