/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob;

import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class BoBData {
    private final Integer maxAge;
    private final String type;
    private byte[] contentBinary;
    private String contentString;

    private BoBData(String type2, Integer maxAge) {
        this.type = type2;
        this.maxAge = maxAge;
    }

    public BoBData(String type2, byte[] content) {
        this(type2, content, null);
    }

    public BoBData(String type2, byte[] content, Integer maxAge) {
        this(type2, maxAge);
        this.contentBinary = content;
    }

    public BoBData(String type2, String content) {
        this(type2, content, null);
    }

    public BoBData(String type2, String content, Integer maxAge) {
        this(type2, maxAge);
        this.contentString = content;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public String getType() {
        return this.type;
    }

    private void setContentBinaryIfRequired() {
        if (this.contentBinary == null) {
            assert (StringUtils.isNotEmpty((CharSequence)this.contentString));
            this.contentBinary = Base64.decode(this.contentString);
        }
    }

    public byte[] getContent() {
        this.setContentBinaryIfRequired();
        return (byte[])this.contentBinary.clone();
    }

    public String getContentBase64Encoded() {
        if (this.contentString == null) {
            this.contentString = Base64.encodeToString(this.getContent());
        }
        return this.contentString;
    }

    public boolean isOfReasonableSize() {
        this.setContentBinaryIfRequired();
        return this.contentBinary.length <= 8192;
    }
}

