/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.service;

import io.quarkus.hibernate.orm.runtime.service.QuarkusSimplifiedIdentifierGeneratorFactory;
import jakarta.persistence.GenerationType;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.Generator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.IdentifierGeneratorFactory;
import org.hibernate.id.factory.spi.GeneratorDefinitionResolver;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.JavaType;

public final class QuarkusMutableIdentifierGeneratorFactory
implements IdentifierGeneratorFactory,
Serializable {
    private final QuarkusSimplifiedIdentifierGeneratorFactory original;
    private final ConcurrentHashMap<String, Class<? extends Generator>> typeCache = new ConcurrentHashMap();

    public QuarkusMutableIdentifierGeneratorFactory(ServiceRegistry serviceRegistry) {
        this.original = new QuarkusSimplifiedIdentifierGeneratorFactory(serviceRegistry);
    }

    public Dialect getDialect() {
        return this.original.getDialect();
    }

    public Generator createIdentifierGenerator(String strategy, Type type, Properties config) {
        Generator identifierGenerator = this.original.createIdentifierGenerator(strategy, type, config);
        this.storeCache(strategy, identifierGenerator.getClass());
        return identifierGenerator;
    }

    private void storeCache(String strategy, Class<? extends Generator> generatorClass) {
        if (strategy == null || generatorClass == null) {
            return;
        }
        String className = generatorClass.getName();
        this.typeCache.put(strategy, generatorClass);
        if (!className.equals(strategy)) {
            this.typeCache.put(className, generatorClass);
        }
    }

    public void register(String strategy, Class generatorClass) {
        this.storeCache(strategy, generatorClass);
        this.original.register(strategy, generatorClass);
    }

    public Class getIdentifierGeneratorClass(String strategy) {
        Class aClass = this.typeCache.get(strategy);
        if (aClass != null) {
            return aClass;
        }
        aClass = this.original.getIdentifierGeneratorClass(strategy);
        this.storeCache(strategy, aClass);
        return aClass;
    }

    public IdentifierGenerator createIdentifierGenerator(GenerationType generationType, String generatedValueGeneratorName, String generatorName, JavaType<?> javaType, Properties config, GeneratorDefinitionResolver definitionResolver) {
        return this.original.createIdentifierGenerator(generationType, generatedValueGeneratorName, generatorName, javaType, config, definitionResolver);
    }
}

