/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.MapKey;
import jakarta.persistence.MapKeyColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.models.jpa.entities.AuthenticationFlowEntity;
import org.keycloak.models.jpa.entities.AuthenticatorConfigEntity;
import org.keycloak.models.jpa.entities.ComponentEntity;
import org.keycloak.models.jpa.entities.IdentityProviderEntity;
import org.keycloak.models.jpa.entities.IdentityProviderMapperEntity;
import org.keycloak.models.jpa.entities.RealmAttributeEntity;
import org.keycloak.models.jpa.entities.RealmLocalizationTextsEntity;
import org.keycloak.models.jpa.entities.RequiredActionProviderEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.UserFederationMapperEntity;
import org.keycloak.models.jpa.entities.UserFederationProviderEntity;

@Table(name="REALM")
@Entity
@NamedQueries(value={@NamedQuery(name="getAllRealmIds", query="select realm.id from RealmEntity realm"), @NamedQuery(name="getRealmIdByName", query="select realm.id from RealmEntity realm where realm.name = :name"), @NamedQuery(name="getRealmIdsWithProviderType", query="select distinct c.realm.id from ComponentEntity c where c.providerType = :providerType")})
@EnhancementInfo(version="6.2.7.Final")
public class RealmEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    protected String id;
    @Column(name="NAME", unique=true)
    protected String name;
    @Column(name="ENABLED")
    protected boolean enabled;
    @Column(name="SSL_REQUIRED")
    protected String sslRequired;
    @Column(name="REGISTRATION_ALLOWED")
    protected boolean registrationAllowed;
    @Column(name="REG_EMAIL_AS_USERNAME")
    protected boolean registrationEmailAsUsername;
    @Column(name="VERIFY_EMAIL")
    protected boolean verifyEmail;
    @Column(name="RESET_PASSWORD_ALLOWED")
    protected boolean resetPasswordAllowed;
    @Column(name="LOGIN_WITH_EMAIL_ALLOWED")
    protected boolean loginWithEmailAllowed;
    @Column(name="DUPLICATE_EMAILS_ALLOWED")
    protected boolean duplicateEmailsAllowed;
    @Column(name="REMEMBER_ME")
    protected boolean rememberMe;
    @Column(name="PASSWORD_POLICY")
    protected String passwordPolicy;
    @Column(name="OTP_POLICY_TYPE")
    protected String otpPolicyType;
    @Column(name="OTP_POLICY_ALG")
    protected String otpPolicyAlgorithm;
    @Column(name="OTP_POLICY_COUNTER")
    protected int otpPolicyInitialCounter;
    @Column(name="OTP_POLICY_DIGITS")
    protected int otpPolicyDigits;
    @Column(name="OTP_POLICY_WINDOW")
    protected int otpPolicyLookAheadWindow;
    @Column(name="OTP_POLICY_PERIOD")
    protected int otpPolicyPeriod;
    @Column(name="EDIT_USERNAME_ALLOWED")
    protected boolean editUsernameAllowed;
    @Column(name="REVOKE_REFRESH_TOKEN")
    boolean revokeRefreshToken;
    @Column(name="REFRESH_TOKEN_MAX_REUSE")
    int refreshTokenMaxReuse;
    @Column(name="SSO_IDLE_TIMEOUT")
    int ssoSessionIdleTimeout;
    @Column(name="SSO_MAX_LIFESPAN")
    int ssoSessionMaxLifespan;
    @Column(name="SSO_IDLE_TIMEOUT_REMEMBER_ME")
    int ssoSessionIdleTimeoutRememberMe;
    @Column(name="SSO_MAX_LIFESPAN_REMEMBER_ME")
    int ssoSessionMaxLifespanRememberMe;
    @Column(name="OFFLINE_SESSION_IDLE_TIMEOUT")
    int offlineSessionIdleTimeout;
    @Column(name="ACCESS_TOKEN_LIFESPAN")
    protected int accessTokenLifespan;
    @Column(name="ACCESS_TOKEN_LIFE_IMPLICIT")
    protected int accessTokenLifespanForImplicitFlow;
    @Column(name="ACCESS_CODE_LIFESPAN")
    protected int accessCodeLifespan;
    @Column(name="USER_ACTION_LIFESPAN")
    protected int accessCodeLifespanUserAction;
    @Column(name="LOGIN_LIFESPAN")
    protected int accessCodeLifespanLogin;
    @Column(name="NOT_BEFORE")
    protected int notBefore;
    @Column(name="LOGIN_THEME")
    protected String loginTheme;
    @Column(name="ACCOUNT_THEME")
    protected String accountTheme;
    @Column(name="ADMIN_THEME")
    protected String adminTheme;
    @Column(name="EMAIL_THEME")
    protected String emailTheme;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm", fetch=FetchType.EAGER)
    Collection<RealmAttributeEntity> attributes;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    Collection<RequiredCredentialEntity> requiredCredentials;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    List<UserFederationProviderEntity> userFederationProviders;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    Collection<UserFederationMapperEntity> userFederationMappers;
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE")
    @CollectionTable(name="REALM_SMTP_CONFIG", joinColumns={@JoinColumn(name="REALM_ID")})
    protected Map<String, String> smtpConfig;
    @ElementCollection
    @Column(name="GROUP_ID")
    @CollectionTable(name="REALM_DEFAULT_GROUPS", joinColumns={@JoinColumn(name="REALM_ID")})
    protected Set<String> defaultGroupIds;
    @Column(name="EVENTS_ENABLED")
    protected boolean eventsEnabled;
    @Column(name="EVENTS_EXPIRATION")
    protected long eventsExpiration;
    @ElementCollection
    @Column(name="VALUE")
    @CollectionTable(name="REALM_EVENTS_LISTENERS", joinColumns={@JoinColumn(name="REALM_ID")})
    protected Set<String> eventsListeners;
    @ElementCollection
    @Column(name="VALUE")
    @CollectionTable(name="REALM_ENABLED_EVENT_TYPES", joinColumns={@JoinColumn(name="REALM_ID")})
    protected Set<String> enabledEventTypes;
    @Column(name="ADMIN_EVENTS_ENABLED")
    protected boolean adminEventsEnabled;
    @Column(name="ADMIN_EVENTS_DETAILS_ENABLED")
    protected boolean adminEventsDetailsEnabled;
    @Column(name="MASTER_ADMIN_CLIENT")
    protected String masterAdminClient;
    @Column(name="DEFAULT_ROLE")
    protected String defaultRoleId;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    protected List<IdentityProviderEntity> identityProviders;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    Collection<IdentityProviderMapperEntity> identityProviderMappers;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    Collection<AuthenticatorConfigEntity> authenticators;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    Collection<RequiredActionProviderEntity> requiredActionProviders;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    Collection<AuthenticationFlowEntity> authenticationFlows;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="realm")
    Set<ComponentEntity> components;
    @Column(name="BROWSER_FLOW")
    protected String browserFlow;
    @Column(name="REGISTRATION_FLOW")
    protected String registrationFlow;
    @Column(name="DIRECT_GRANT_FLOW")
    protected String directGrantFlow;
    @Column(name="RESET_CREDENTIALS_FLOW")
    protected String resetCredentialsFlow;
    @Column(name="CLIENT_AUTH_FLOW")
    protected String clientAuthenticationFlow;
    @Column(name="DOCKER_AUTH_FLOW")
    protected String dockerAuthenticationFlow;
    @Column(name="INTERNATIONALIZATION_ENABLED")
    protected boolean internationalizationEnabled;
    @ElementCollection
    @Column(name="VALUE")
    @CollectionTable(name="REALM_SUPPORTED_LOCALES", joinColumns={@JoinColumn(name="REALM_ID")})
    protected Set<String> supportedLocales;
    @Column(name="DEFAULT_LOCALE")
    protected String defaultLocale;
    @Column(name="ALLOW_USER_MANAGED_ACCESS")
    boolean allowUserManagedAccess;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="realm")
    @MapKey(name="locale")
    Map<String, RealmLocalizationTextsEntity> realmLocalizationTexts;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public RealmEntity() {
        this.$$_hibernate_write_attributes(new LinkedList());
        this.$$_hibernate_write_requiredCredentials(new LinkedList());
        this.$$_hibernate_write_userFederationProviders(new LinkedList());
        this.$$_hibernate_write_userFederationMappers(new LinkedList());
        this.$$_hibernate_write_identityProviders(new LinkedList());
        this.$$_hibernate_write_identityProviderMappers(new LinkedList());
        this.$$_hibernate_write_authenticators(new LinkedList());
        this.$$_hibernate_write_requiredActionProviders(new LinkedList());
        this.$$_hibernate_write_authenticationFlows(new LinkedList());
        this.$$_hibernate_write_components(new HashSet());
        this.$$_hibernate_write_realmLocalizationTexts(new HashMap());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public boolean isEnabled() {
        return this.$$_hibernate_read_enabled();
    }

    public void setEnabled(boolean enabled) {
        this.$$_hibernate_write_enabled(enabled);
    }

    public String getSslRequired() {
        return this.$$_hibernate_read_sslRequired();
    }

    public void setSslRequired(String sslRequired) {
        this.$$_hibernate_write_sslRequired(sslRequired);
    }

    public boolean isRegistrationAllowed() {
        return this.$$_hibernate_read_registrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.$$_hibernate_write_registrationAllowed(registrationAllowed);
    }

    public boolean isRegistrationEmailAsUsername() {
        return this.$$_hibernate_read_registrationEmailAsUsername();
    }

    public void setRegistrationEmailAsUsername(boolean registrationEmailAsUsername) {
        this.$$_hibernate_write_registrationEmailAsUsername(registrationEmailAsUsername);
    }

    public boolean isRememberMe() {
        return this.$$_hibernate_read_rememberMe();
    }

    public void setRememberMe(boolean rememberMe) {
        this.$$_hibernate_write_rememberMe(rememberMe);
    }

    public boolean isVerifyEmail() {
        return this.$$_hibernate_read_verifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.$$_hibernate_write_verifyEmail(verifyEmail);
    }

    public boolean isLoginWithEmailAllowed() {
        return this.$$_hibernate_read_loginWithEmailAllowed();
    }

    public void setLoginWithEmailAllowed(boolean loginWithEmailAllowed) {
        this.$$_hibernate_write_loginWithEmailAllowed(loginWithEmailAllowed);
    }

    public boolean isDuplicateEmailsAllowed() {
        return this.$$_hibernate_read_duplicateEmailsAllowed();
    }

    public void setDuplicateEmailsAllowed(boolean duplicateEmailsAllowed) {
        this.$$_hibernate_write_duplicateEmailsAllowed(duplicateEmailsAllowed);
    }

    public boolean isResetPasswordAllowed() {
        return this.$$_hibernate_read_resetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.$$_hibernate_write_resetPasswordAllowed(resetPasswordAllowed);
    }

    public boolean isEditUsernameAllowed() {
        return this.$$_hibernate_read_editUsernameAllowed();
    }

    public void setEditUsernameAllowed(boolean editUsernameAllowed) {
        this.$$_hibernate_write_editUsernameAllowed(editUsernameAllowed);
    }

    public boolean isRevokeRefreshToken() {
        return this.$$_hibernate_read_revokeRefreshToken();
    }

    public void setRevokeRefreshToken(boolean revokeRefreshToken) {
        this.$$_hibernate_write_revokeRefreshToken(revokeRefreshToken);
    }

    public int getRefreshTokenMaxReuse() {
        return this.$$_hibernate_read_refreshTokenMaxReuse();
    }

    public void setRefreshTokenMaxReuse(int revokeRefreshTokenCount) {
        this.$$_hibernate_write_refreshTokenMaxReuse(revokeRefreshTokenCount);
    }

    public int getSsoSessionIdleTimeout() {
        return this.$$_hibernate_read_ssoSessionIdleTimeout();
    }

    public void setSsoSessionIdleTimeout(int ssoSessionIdleTimeout) {
        this.$$_hibernate_write_ssoSessionIdleTimeout(ssoSessionIdleTimeout);
    }

    public int getSsoSessionMaxLifespan() {
        return this.$$_hibernate_read_ssoSessionMaxLifespan();
    }

    public void setSsoSessionMaxLifespan(int ssoSessionMaxLifespan) {
        this.$$_hibernate_write_ssoSessionMaxLifespan(ssoSessionMaxLifespan);
    }

    public int getSsoSessionIdleTimeoutRememberMe() {
        return this.$$_hibernate_read_ssoSessionIdleTimeoutRememberMe();
    }

    public void setSsoSessionIdleTimeoutRememberMe(int ssoSessionIdleTimeoutRememberMe) {
        this.$$_hibernate_write_ssoSessionIdleTimeoutRememberMe(ssoSessionIdleTimeoutRememberMe);
    }

    public int getSsoSessionMaxLifespanRememberMe() {
        return this.$$_hibernate_read_ssoSessionMaxLifespanRememberMe();
    }

    public void setSsoSessionMaxLifespanRememberMe(int ssoSessionMaxLifespanRememberMe) {
        this.$$_hibernate_write_ssoSessionMaxLifespanRememberMe(ssoSessionMaxLifespanRememberMe);
    }

    public int getOfflineSessionIdleTimeout() {
        return this.$$_hibernate_read_offlineSessionIdleTimeout();
    }

    public void setOfflineSessionIdleTimeout(int offlineSessionIdleTimeout) {
        this.$$_hibernate_write_offlineSessionIdleTimeout(offlineSessionIdleTimeout);
    }

    public int getAccessTokenLifespan() {
        return this.$$_hibernate_read_accessTokenLifespan();
    }

    public void setAccessTokenLifespan(int accessTokenLifespan) {
        this.$$_hibernate_write_accessTokenLifespan(accessTokenLifespan);
    }

    public int getAccessTokenLifespanForImplicitFlow() {
        return this.$$_hibernate_read_accessTokenLifespanForImplicitFlow();
    }

    public void setAccessTokenLifespanForImplicitFlow(int accessTokenLifespanForImplicitFlow) {
        this.$$_hibernate_write_accessTokenLifespanForImplicitFlow(accessTokenLifespanForImplicitFlow);
    }

    public int getAccessCodeLifespan() {
        return this.$$_hibernate_read_accessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.$$_hibernate_write_accessCodeLifespan(accessCodeLifespan);
    }

    public int getAccessCodeLifespanUserAction() {
        return this.$$_hibernate_read_accessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.$$_hibernate_write_accessCodeLifespanUserAction(accessCodeLifespanUserAction);
    }

    public int getAccessCodeLifespanLogin() {
        return this.$$_hibernate_read_accessCodeLifespanLogin();
    }

    public void setAccessCodeLifespanLogin(int accessCodeLifespanLogin) {
        this.$$_hibernate_write_accessCodeLifespanLogin(accessCodeLifespanLogin);
    }

    public Collection<RequiredCredentialEntity> getRequiredCredentials() {
        if (this.$$_hibernate_read_requiredCredentials() == null) {
            this.$$_hibernate_write_requiredCredentials(new LinkedList());
        }
        return this.$$_hibernate_read_requiredCredentials();
    }

    public void setRequiredCredentials(Collection<RequiredCredentialEntity> requiredCredentials) {
        this.$$_hibernate_write_requiredCredentials(requiredCredentials);
    }

    public Map<String, String> getSmtpConfig() {
        if (this.$$_hibernate_read_smtpConfig() == null) {
            this.$$_hibernate_write_smtpConfig(new HashMap());
        }
        return this.$$_hibernate_read_smtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.$$_hibernate_write_smtpConfig(smtpConfig);
    }

    public Set<String> getDefaultGroupIds() {
        if (this.$$_hibernate_read_defaultGroupIds() == null) {
            this.$$_hibernate_write_defaultGroupIds(new HashSet());
        }
        return this.$$_hibernate_read_defaultGroupIds();
    }

    public void setDefaultGroupIds(Set<String> defaultGroups) {
        this.$$_hibernate_write_defaultGroupIds(defaultGroups);
    }

    public String getPasswordPolicy() {
        return this.$$_hibernate_read_passwordPolicy();
    }

    public void setPasswordPolicy(String passwordPolicy) {
        this.$$_hibernate_write_passwordPolicy(passwordPolicy);
    }

    public String getLoginTheme() {
        return this.$$_hibernate_read_loginTheme();
    }

    public void setLoginTheme(String theme) {
        this.$$_hibernate_write_loginTheme(theme);
    }

    public String getAccountTheme() {
        return this.$$_hibernate_read_accountTheme();
    }

    public void setAccountTheme(String theme) {
        this.$$_hibernate_write_accountTheme(theme);
    }

    public String getAdminTheme() {
        return this.$$_hibernate_read_adminTheme();
    }

    public void setAdminTheme(String adminTheme) {
        this.$$_hibernate_write_adminTheme(adminTheme);
    }

    public String getEmailTheme() {
        return this.$$_hibernate_read_emailTheme();
    }

    public void setEmailTheme(String emailTheme) {
        this.$$_hibernate_write_emailTheme(emailTheme);
    }

    public int getNotBefore() {
        return this.$$_hibernate_read_notBefore();
    }

    public void setNotBefore(int notBefore) {
        this.$$_hibernate_write_notBefore(notBefore);
    }

    public boolean isEventsEnabled() {
        return this.$$_hibernate_read_eventsEnabled();
    }

    public void setEventsEnabled(boolean eventsEnabled) {
        this.$$_hibernate_write_eventsEnabled(eventsEnabled);
    }

    public long getEventsExpiration() {
        return this.$$_hibernate_read_eventsExpiration();
    }

    public void setEventsExpiration(long eventsExpiration) {
        this.$$_hibernate_write_eventsExpiration(eventsExpiration);
    }

    public Set<String> getEventsListeners() {
        if (this.$$_hibernate_read_eventsListeners() == null) {
            this.$$_hibernate_write_eventsListeners(new HashSet());
        }
        return this.$$_hibernate_read_eventsListeners();
    }

    public void setEventsListeners(Set<String> eventsListeners) {
        this.$$_hibernate_write_eventsListeners(eventsListeners);
    }

    public Set<String> getEnabledEventTypes() {
        if (this.$$_hibernate_read_enabledEventTypes() == null) {
            this.$$_hibernate_write_enabledEventTypes(new HashSet());
        }
        return this.$$_hibernate_read_enabledEventTypes();
    }

    public void setEnabledEventTypes(Set<String> enabledEventTypes) {
        this.$$_hibernate_write_enabledEventTypes(enabledEventTypes);
    }

    public boolean isAdminEventsEnabled() {
        return this.$$_hibernate_read_adminEventsEnabled();
    }

    public void setAdminEventsEnabled(boolean adminEventsEnabled) {
        this.$$_hibernate_write_adminEventsEnabled(adminEventsEnabled);
    }

    public boolean isAdminEventsDetailsEnabled() {
        return this.$$_hibernate_read_adminEventsDetailsEnabled();
    }

    public void setAdminEventsDetailsEnabled(boolean adminEventsDetailsEnabled) {
        this.$$_hibernate_write_adminEventsDetailsEnabled(adminEventsDetailsEnabled);
    }

    public String getMasterAdminClient() {
        return this.$$_hibernate_read_masterAdminClient();
    }

    public void setMasterAdminClient(String masterAdminClient) {
        this.$$_hibernate_write_masterAdminClient(masterAdminClient);
    }

    public String getDefaultRoleId() {
        return this.$$_hibernate_read_defaultRoleId();
    }

    public void setDefaultRoleId(String defaultRoleId) {
        this.$$_hibernate_write_defaultRoleId(defaultRoleId);
    }

    public List<UserFederationProviderEntity> getUserFederationProviders() {
        if (this.$$_hibernate_read_userFederationProviders() == null) {
            this.$$_hibernate_write_userFederationProviders(new LinkedList());
        }
        return this.$$_hibernate_read_userFederationProviders();
    }

    public void setUserFederationProviders(List<UserFederationProviderEntity> userFederationProviders) {
        this.$$_hibernate_write_userFederationProviders(userFederationProviders);
    }

    public Collection<UserFederationMapperEntity> getUserFederationMappers() {
        if (this.$$_hibernate_read_userFederationMappers() == null) {
            this.$$_hibernate_write_userFederationMappers(new LinkedList());
        }
        return this.$$_hibernate_read_userFederationMappers();
    }

    public void setUserFederationMappers(Collection<UserFederationMapperEntity> userFederationMappers) {
        this.$$_hibernate_write_userFederationMappers(userFederationMappers);
    }

    public Collection<RealmAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(Collection<RealmAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public List<IdentityProviderEntity> getIdentityProviders() {
        if (this.$$_hibernate_read_identityProviders() == null) {
            this.$$_hibernate_write_identityProviders(new LinkedList());
        }
        return this.$$_hibernate_read_identityProviders();
    }

    public void setIdentityProviders(List<IdentityProviderEntity> identityProviders) {
        this.$$_hibernate_write_identityProviders(identityProviders);
    }

    public void addIdentityProvider(IdentityProviderEntity entity) {
        entity.setRealm(this);
        this.getIdentityProviders().add(entity);
    }

    public boolean isInternationalizationEnabled() {
        return this.$$_hibernate_read_internationalizationEnabled();
    }

    public void setInternationalizationEnabled(boolean internationalizationEnabled) {
        this.$$_hibernate_write_internationalizationEnabled(internationalizationEnabled);
    }

    public Set<String> getSupportedLocales() {
        if (this.$$_hibernate_read_supportedLocales() == null) {
            this.$$_hibernate_write_supportedLocales(new HashSet());
        }
        return this.$$_hibernate_read_supportedLocales();
    }

    public void setSupportedLocales(Set<String> supportedLocales) {
        this.$$_hibernate_write_supportedLocales(supportedLocales);
    }

    public String getDefaultLocale() {
        return this.$$_hibernate_read_defaultLocale();
    }

    public void setDefaultLocale(String defaultLocale) {
        this.$$_hibernate_write_defaultLocale(defaultLocale);
    }

    public Collection<IdentityProviderMapperEntity> getIdentityProviderMappers() {
        if (this.$$_hibernate_read_identityProviderMappers() == null) {
            this.$$_hibernate_write_identityProviderMappers(new LinkedList());
        }
        return this.$$_hibernate_read_identityProviderMappers();
    }

    public void setIdentityProviderMappers(Collection<IdentityProviderMapperEntity> identityProviderMappers) {
        this.$$_hibernate_write_identityProviderMappers(identityProviderMappers);
    }

    public Collection<AuthenticatorConfigEntity> getAuthenticatorConfigs() {
        if (this.$$_hibernate_read_authenticators() == null) {
            this.$$_hibernate_write_authenticators(new LinkedList());
        }
        return this.$$_hibernate_read_authenticators();
    }

    public void setAuthenticatorConfigs(Collection<AuthenticatorConfigEntity> authenticators) {
        this.$$_hibernate_write_authenticators(authenticators);
    }

    public Collection<RequiredActionProviderEntity> getRequiredActionProviders() {
        if (this.$$_hibernate_read_requiredActionProviders() == null) {
            this.$$_hibernate_write_requiredActionProviders(new LinkedList());
        }
        return this.$$_hibernate_read_requiredActionProviders();
    }

    public void setRequiredActionProviders(Collection<RequiredActionProviderEntity> requiredActionProviders) {
        this.$$_hibernate_write_requiredActionProviders(requiredActionProviders);
    }

    public Collection<AuthenticationFlowEntity> getAuthenticationFlows() {
        if (this.$$_hibernate_read_authenticationFlows() == null) {
            this.$$_hibernate_write_authenticationFlows(new LinkedList());
        }
        return this.$$_hibernate_read_authenticationFlows();
    }

    public void setAuthenticationFlows(Collection<AuthenticationFlowEntity> authenticationFlows) {
        this.$$_hibernate_write_authenticationFlows(authenticationFlows);
    }

    public Set<ComponentEntity> getComponents() {
        if (this.$$_hibernate_read_components() == null) {
            this.$$_hibernate_write_components(new HashSet());
        }
        return this.$$_hibernate_read_components();
    }

    public void setComponents(Set<ComponentEntity> components) {
        this.$$_hibernate_write_components(components);
    }

    public String getOtpPolicyType() {
        return this.$$_hibernate_read_otpPolicyType();
    }

    public void setOtpPolicyType(String otpPolicyType) {
        this.$$_hibernate_write_otpPolicyType(otpPolicyType);
    }

    public String getOtpPolicyAlgorithm() {
        return this.$$_hibernate_read_otpPolicyAlgorithm();
    }

    public void setOtpPolicyAlgorithm(String otpPolicyAlgorithm) {
        this.$$_hibernate_write_otpPolicyAlgorithm(otpPolicyAlgorithm);
    }

    public int getOtpPolicyInitialCounter() {
        return this.$$_hibernate_read_otpPolicyInitialCounter();
    }

    public void setOtpPolicyInitialCounter(int otpPolicyInitialCounter) {
        this.$$_hibernate_write_otpPolicyInitialCounter(otpPolicyInitialCounter);
    }

    public int getOtpPolicyDigits() {
        return this.$$_hibernate_read_otpPolicyDigits();
    }

    public void setOtpPolicyDigits(int otpPolicyDigits) {
        this.$$_hibernate_write_otpPolicyDigits(otpPolicyDigits);
    }

    public int getOtpPolicyLookAheadWindow() {
        return this.$$_hibernate_read_otpPolicyLookAheadWindow();
    }

    public void setOtpPolicyLookAheadWindow(int otpPolicyLookAheadWindow) {
        this.$$_hibernate_write_otpPolicyLookAheadWindow(otpPolicyLookAheadWindow);
    }

    public int getOtpPolicyPeriod() {
        return this.$$_hibernate_read_otpPolicyPeriod();
    }

    public void setOtpPolicyPeriod(int otpPolicyPeriod) {
        this.$$_hibernate_write_otpPolicyPeriod(otpPolicyPeriod);
    }

    public String getBrowserFlow() {
        return this.$$_hibernate_read_browserFlow();
    }

    public void setBrowserFlow(String browserFlow) {
        this.$$_hibernate_write_browserFlow(browserFlow);
    }

    public String getRegistrationFlow() {
        return this.$$_hibernate_read_registrationFlow();
    }

    public void setRegistrationFlow(String registrationFlow) {
        this.$$_hibernate_write_registrationFlow(registrationFlow);
    }

    public String getDirectGrantFlow() {
        return this.$$_hibernate_read_directGrantFlow();
    }

    public void setDirectGrantFlow(String directGrantFlow) {
        this.$$_hibernate_write_directGrantFlow(directGrantFlow);
    }

    public String getResetCredentialsFlow() {
        return this.$$_hibernate_read_resetCredentialsFlow();
    }

    public void setResetCredentialsFlow(String resetCredentialsFlow) {
        this.$$_hibernate_write_resetCredentialsFlow(resetCredentialsFlow);
    }

    public String getClientAuthenticationFlow() {
        return this.$$_hibernate_read_clientAuthenticationFlow();
    }

    public void setClientAuthenticationFlow(String clientAuthenticationFlow) {
        this.$$_hibernate_write_clientAuthenticationFlow(clientAuthenticationFlow);
    }

    public String getDockerAuthenticationFlow() {
        return this.$$_hibernate_read_dockerAuthenticationFlow();
    }

    public RealmEntity setDockerAuthenticationFlow(String dockerAuthenticationFlow) {
        this.$$_hibernate_write_dockerAuthenticationFlow(dockerAuthenticationFlow);
        return this;
    }

    public void setAllowUserManagedAccess(boolean allowUserManagedAccess) {
        this.$$_hibernate_write_allowUserManagedAccess(allowUserManagedAccess);
    }

    public boolean isAllowUserManagedAccess() {
        return this.$$_hibernate_read_allowUserManagedAccess();
    }

    public Map<String, RealmLocalizationTextsEntity> getRealmLocalizationTexts() {
        if (this.$$_hibernate_read_realmLocalizationTexts() == null) {
            this.$$_hibernate_write_realmLocalizationTexts(new HashMap());
        }
        return this.$$_hibernate_read_realmLocalizationTexts();
    }

    public void setRealmLocalizationTexts(Map<String, RealmLocalizationTextsEntity> realmLocalizationTexts) {
        this.$$_hibernate_write_realmLocalizationTexts(realmLocalizationTexts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RealmEntity)) {
            return false;
        }
        RealmEntity that = (RealmEntity)o;
        return this.$$_hibernate_read_id().equals(that.getId());
    }

    public String toString() {
        return "Realm{id='" + this.$$_hibernate_read_id() + '\'' + ", name='" + this.$$_hibernate_read_name() + '\'' + '}';
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        RealmEntity realmEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block60: {
            int n2;
            block61: {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                int n15;
                RealmEntity realmEntity = this;
                RealmEntity realmEntity2 = realmEntity;
                RealmEntity realmEntity3 = realmEntity2;
                RealmEntity realmEntity4 = realmEntity3;
                RealmEntity realmEntity5 = realmEntity4;
                RealmEntity realmEntity6 = realmEntity5;
                RealmEntity realmEntity7 = realmEntity6;
                RealmEntity realmEntity8 = realmEntity7;
                RealmEntity realmEntity9 = realmEntity8;
                RealmEntity realmEntity10 = realmEntity9;
                RealmEntity realmEntity11 = realmEntity10;
                RealmEntity realmEntity12 = realmEntity11;
                RealmEntity realmEntity13 = realmEntity12;
                RealmEntity realmEntity14 = realmEntity13;
                RealmEntity realmEntity15 = realmEntity14;
                RealmEntity realmEntity16 = realmEntity15;
                int n16 = 0;
                if (n16 == 0 && realmEntity15.$$_hibernate_collectionTracker != null) {
                    int n17 = realmEntity15.$$_hibernate_collectionTracker.getSize("attributes");
                    if (realmEntity15.attributes == null && n17 != -1) {
                        n16 = 1;
                    } else if (realmEntity15.attributes != null && (!(realmEntity15.attributes instanceof PersistentCollection) || ((PersistentCollection)realmEntity15.attributes).wasInitialized()) && n17 != realmEntity15.attributes.size()) {
                        n16 = 1;
                    }
                }
                if ((n15 = n16) == 0 && realmEntity14.$$_hibernate_collectionTracker != null) {
                    n16 = realmEntity14.$$_hibernate_collectionTracker.getSize("requiredCredentials");
                    if (realmEntity14.requiredCredentials == null && n16 != -1) {
                        n15 = 1;
                    } else if (realmEntity14.requiredCredentials != null && (!(realmEntity14.requiredCredentials instanceof PersistentCollection) || ((PersistentCollection)realmEntity14.requiredCredentials).wasInitialized()) && n16 != realmEntity14.requiredCredentials.size()) {
                        n15 = 1;
                    }
                }
                if ((n14 = n15) == 0 && realmEntity13.$$_hibernate_collectionTracker != null) {
                    n15 = realmEntity13.$$_hibernate_collectionTracker.getSize("userFederationProviders");
                    if (realmEntity13.userFederationProviders == null && n15 != -1) {
                        n14 = 1;
                    } else if (realmEntity13.userFederationProviders != null && (!(realmEntity13.userFederationProviders instanceof PersistentCollection) || ((PersistentCollection)realmEntity13.userFederationProviders).wasInitialized()) && n15 != realmEntity13.userFederationProviders.size()) {
                        n14 = 1;
                    }
                }
                if ((n13 = n14) == 0 && realmEntity12.$$_hibernate_collectionTracker != null) {
                    n14 = realmEntity12.$$_hibernate_collectionTracker.getSize("userFederationMappers");
                    if (realmEntity12.userFederationMappers == null && n14 != -1) {
                        n13 = 1;
                    } else if (realmEntity12.userFederationMappers != null && (!(realmEntity12.userFederationMappers instanceof PersistentCollection) || ((PersistentCollection)realmEntity12.userFederationMappers).wasInitialized()) && n14 != realmEntity12.userFederationMappers.size()) {
                        n13 = 1;
                    }
                }
                if ((n12 = n13) == 0 && realmEntity11.$$_hibernate_collectionTracker != null) {
                    n13 = realmEntity11.$$_hibernate_collectionTracker.getSize("smtpConfig");
                    if (realmEntity11.smtpConfig == null && n13 != -1) {
                        n12 = 1;
                    } else if (realmEntity11.smtpConfig != null && (!(realmEntity11.smtpConfig instanceof PersistentCollection) || ((PersistentCollection)realmEntity11.smtpConfig).wasInitialized()) && n13 != realmEntity11.smtpConfig.size()) {
                        n12 = 1;
                    }
                }
                if ((n11 = n12) == 0 && realmEntity10.$$_hibernate_collectionTracker != null) {
                    n12 = realmEntity10.$$_hibernate_collectionTracker.getSize("defaultGroupIds");
                    if (realmEntity10.defaultGroupIds == null && n12 != -1) {
                        n11 = 1;
                    } else if (realmEntity10.defaultGroupIds != null && (!(realmEntity10.defaultGroupIds instanceof PersistentCollection) || ((PersistentCollection)realmEntity10.defaultGroupIds).wasInitialized()) && n12 != realmEntity10.defaultGroupIds.size()) {
                        n11 = 1;
                    }
                }
                if ((n10 = n11) == 0 && realmEntity9.$$_hibernate_collectionTracker != null) {
                    n11 = realmEntity9.$$_hibernate_collectionTracker.getSize("eventsListeners");
                    if (realmEntity9.eventsListeners == null && n11 != -1) {
                        n10 = 1;
                    } else if (realmEntity9.eventsListeners != null && (!(realmEntity9.eventsListeners instanceof PersistentCollection) || ((PersistentCollection)realmEntity9.eventsListeners).wasInitialized()) && n11 != realmEntity9.eventsListeners.size()) {
                        n10 = 1;
                    }
                }
                if ((n9 = n10) == 0 && realmEntity8.$$_hibernate_collectionTracker != null) {
                    n10 = realmEntity8.$$_hibernate_collectionTracker.getSize("enabledEventTypes");
                    if (realmEntity8.enabledEventTypes == null && n10 != -1) {
                        n9 = 1;
                    } else if (realmEntity8.enabledEventTypes != null && (!(realmEntity8.enabledEventTypes instanceof PersistentCollection) || ((PersistentCollection)realmEntity8.enabledEventTypes).wasInitialized()) && n10 != realmEntity8.enabledEventTypes.size()) {
                        n9 = 1;
                    }
                }
                if ((n8 = n9) == 0 && realmEntity7.$$_hibernate_collectionTracker != null) {
                    n9 = realmEntity7.$$_hibernate_collectionTracker.getSize("identityProviders");
                    if (realmEntity7.identityProviders == null && n9 != -1) {
                        n8 = 1;
                    } else if (realmEntity7.identityProviders != null && (!(realmEntity7.identityProviders instanceof PersistentCollection) || ((PersistentCollection)realmEntity7.identityProviders).wasInitialized()) && n9 != realmEntity7.identityProviders.size()) {
                        n8 = 1;
                    }
                }
                if ((n7 = n8) == 0 && realmEntity6.$$_hibernate_collectionTracker != null) {
                    n8 = realmEntity6.$$_hibernate_collectionTracker.getSize("identityProviderMappers");
                    if (realmEntity6.identityProviderMappers == null && n8 != -1) {
                        n7 = 1;
                    } else if (realmEntity6.identityProviderMappers != null && (!(realmEntity6.identityProviderMappers instanceof PersistentCollection) || ((PersistentCollection)realmEntity6.identityProviderMappers).wasInitialized()) && n8 != realmEntity6.identityProviderMappers.size()) {
                        n7 = 1;
                    }
                }
                if ((n6 = n7) == 0 && realmEntity5.$$_hibernate_collectionTracker != null) {
                    n7 = realmEntity5.$$_hibernate_collectionTracker.getSize("authenticators");
                    if (realmEntity5.authenticators == null && n7 != -1) {
                        n6 = 1;
                    } else if (realmEntity5.authenticators != null && (!(realmEntity5.authenticators instanceof PersistentCollection) || ((PersistentCollection)realmEntity5.authenticators).wasInitialized()) && n7 != realmEntity5.authenticators.size()) {
                        n6 = 1;
                    }
                }
                if ((n5 = n6) == 0 && realmEntity4.$$_hibernate_collectionTracker != null) {
                    n6 = realmEntity4.$$_hibernate_collectionTracker.getSize("requiredActionProviders");
                    if (realmEntity4.requiredActionProviders == null && n6 != -1) {
                        n5 = 1;
                    } else if (realmEntity4.requiredActionProviders != null && (!(realmEntity4.requiredActionProviders instanceof PersistentCollection) || ((PersistentCollection)realmEntity4.requiredActionProviders).wasInitialized()) && n6 != realmEntity4.requiredActionProviders.size()) {
                        n5 = 1;
                    }
                }
                if ((n4 = n5) == 0 && realmEntity3.$$_hibernate_collectionTracker != null) {
                    n5 = realmEntity3.$$_hibernate_collectionTracker.getSize("authenticationFlows");
                    if (realmEntity3.authenticationFlows == null && n5 != -1) {
                        n4 = 1;
                    } else if (realmEntity3.authenticationFlows != null && (!(realmEntity3.authenticationFlows instanceof PersistentCollection) || ((PersistentCollection)realmEntity3.authenticationFlows).wasInitialized()) && n5 != realmEntity3.authenticationFlows.size()) {
                        n4 = 1;
                    }
                }
                if ((n3 = n4) == 0 && realmEntity2.$$_hibernate_collectionTracker != null) {
                    n4 = realmEntity2.$$_hibernate_collectionTracker.getSize("components");
                    if (realmEntity2.components == null && n4 != -1) {
                        n3 = 1;
                    } else if (realmEntity2.components != null && (!(realmEntity2.components instanceof PersistentCollection) || ((PersistentCollection)realmEntity2.components).wasInitialized()) && n4 != realmEntity2.components.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && realmEntity.$$_hibernate_collectionTracker != null) {
                    n3 = realmEntity.$$_hibernate_collectionTracker.getSize("supportedLocales");
                    if (realmEntity.supportedLocales == null && n3 != -1) {
                        n2 = 1;
                    } else if (realmEntity.supportedLocales != null && (!(realmEntity.supportedLocales instanceof PersistentCollection) || ((PersistentCollection)realmEntity.supportedLocales).wasInitialized()) && n3 != realmEntity.supportedLocales.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block60;
                n2 = this.$$_hibernate_collectionTracker.getSize("realmLocalizationTexts");
                if (this.realmLocalizationTexts != null || n2 == -1) break block61;
                n = 1;
                break block60;
            }
            if (this.realmLocalizationTexts == null || this.realmLocalizationTexts instanceof PersistentCollection && !((PersistentCollection)this.realmLocalizationTexts).wasInitialized() || n2 == this.realmLocalizationTexts.size()) break block60;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block60: {
            int n;
            block61: {
                RealmEntity realmEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                RealmEntity realmEntity2 = realmEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                RealmEntity realmEntity3 = realmEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                RealmEntity realmEntity4 = realmEntity3;
                DirtyTracker dirtyTracker5 = dirtyTracker4;
                RealmEntity realmEntity5 = realmEntity4;
                DirtyTracker dirtyTracker6 = dirtyTracker5;
                RealmEntity realmEntity6 = realmEntity5;
                DirtyTracker dirtyTracker7 = dirtyTracker6;
                RealmEntity realmEntity7 = realmEntity6;
                DirtyTracker dirtyTracker8 = dirtyTracker7;
                RealmEntity realmEntity8 = realmEntity7;
                DirtyTracker dirtyTracker9 = dirtyTracker8;
                RealmEntity realmEntity9 = realmEntity8;
                DirtyTracker dirtyTracker10 = dirtyTracker9;
                RealmEntity realmEntity10 = realmEntity9;
                DirtyTracker dirtyTracker11 = dirtyTracker10;
                RealmEntity realmEntity11 = realmEntity10;
                DirtyTracker dirtyTracker12 = dirtyTracker11;
                RealmEntity realmEntity12 = realmEntity11;
                DirtyTracker dirtyTracker13 = dirtyTracker12;
                RealmEntity realmEntity13 = realmEntity12;
                DirtyTracker dirtyTracker14 = dirtyTracker13;
                RealmEntity realmEntity14 = realmEntity13;
                DirtyTracker dirtyTracker15 = dirtyTracker14;
                RealmEntity realmEntity15 = realmEntity14;
                DirtyTracker dirtyTracker16 = dirtyTracker15;
                RealmEntity realmEntity16 = realmEntity15;
                DirtyTracker dirtyTracker17 = dirtyTracker16;
                if (realmEntity15.$$_hibernate_collectionTracker != null) {
                    int n2 = realmEntity15.$$_hibernate_collectionTracker.getSize("attributes");
                    if (realmEntity15.attributes == null && n2 != -1) {
                        dirtyTracker16.add("attributes");
                    } else if (realmEntity15.attributes != null && (!(realmEntity15.attributes instanceof PersistentCollection) || ((PersistentCollection)realmEntity15.attributes).wasInitialized()) && n2 != realmEntity15.attributes.size()) {
                        dirtyTracker16.add("attributes");
                    }
                }
                if (realmEntity14.$$_hibernate_collectionTracker != null) {
                    int n3 = realmEntity14.$$_hibernate_collectionTracker.getSize("requiredCredentials");
                    if (realmEntity14.requiredCredentials == null && n3 != -1) {
                        dirtyTracker15.add("requiredCredentials");
                    } else if (realmEntity14.requiredCredentials != null && (!(realmEntity14.requiredCredentials instanceof PersistentCollection) || ((PersistentCollection)realmEntity14.requiredCredentials).wasInitialized()) && n3 != realmEntity14.requiredCredentials.size()) {
                        dirtyTracker15.add("requiredCredentials");
                    }
                }
                if (realmEntity13.$$_hibernate_collectionTracker != null) {
                    int n4 = realmEntity13.$$_hibernate_collectionTracker.getSize("userFederationProviders");
                    if (realmEntity13.userFederationProviders == null && n4 != -1) {
                        dirtyTracker14.add("userFederationProviders");
                    } else if (realmEntity13.userFederationProviders != null && (!(realmEntity13.userFederationProviders instanceof PersistentCollection) || ((PersistentCollection)realmEntity13.userFederationProviders).wasInitialized()) && n4 != realmEntity13.userFederationProviders.size()) {
                        dirtyTracker14.add("userFederationProviders");
                    }
                }
                if (realmEntity12.$$_hibernate_collectionTracker != null) {
                    int n5 = realmEntity12.$$_hibernate_collectionTracker.getSize("userFederationMappers");
                    if (realmEntity12.userFederationMappers == null && n5 != -1) {
                        dirtyTracker13.add("userFederationMappers");
                    } else if (realmEntity12.userFederationMappers != null && (!(realmEntity12.userFederationMappers instanceof PersistentCollection) || ((PersistentCollection)realmEntity12.userFederationMappers).wasInitialized()) && n5 != realmEntity12.userFederationMappers.size()) {
                        dirtyTracker13.add("userFederationMappers");
                    }
                }
                if (realmEntity11.$$_hibernate_collectionTracker != null) {
                    int n6 = realmEntity11.$$_hibernate_collectionTracker.getSize("smtpConfig");
                    if (realmEntity11.smtpConfig == null && n6 != -1) {
                        dirtyTracker12.add("smtpConfig");
                    } else if (realmEntity11.smtpConfig != null && (!(realmEntity11.smtpConfig instanceof PersistentCollection) || ((PersistentCollection)realmEntity11.smtpConfig).wasInitialized()) && n6 != realmEntity11.smtpConfig.size()) {
                        dirtyTracker12.add("smtpConfig");
                    }
                }
                if (realmEntity10.$$_hibernate_collectionTracker != null) {
                    int n7 = realmEntity10.$$_hibernate_collectionTracker.getSize("defaultGroupIds");
                    if (realmEntity10.defaultGroupIds == null && n7 != -1) {
                        dirtyTracker11.add("defaultGroupIds");
                    } else if (realmEntity10.defaultGroupIds != null && (!(realmEntity10.defaultGroupIds instanceof PersistentCollection) || ((PersistentCollection)realmEntity10.defaultGroupIds).wasInitialized()) && n7 != realmEntity10.defaultGroupIds.size()) {
                        dirtyTracker11.add("defaultGroupIds");
                    }
                }
                if (realmEntity9.$$_hibernate_collectionTracker != null) {
                    int n8 = realmEntity9.$$_hibernate_collectionTracker.getSize("eventsListeners");
                    if (realmEntity9.eventsListeners == null && n8 != -1) {
                        dirtyTracker10.add("eventsListeners");
                    } else if (realmEntity9.eventsListeners != null && (!(realmEntity9.eventsListeners instanceof PersistentCollection) || ((PersistentCollection)realmEntity9.eventsListeners).wasInitialized()) && n8 != realmEntity9.eventsListeners.size()) {
                        dirtyTracker10.add("eventsListeners");
                    }
                }
                if (realmEntity8.$$_hibernate_collectionTracker != null) {
                    int n9 = realmEntity8.$$_hibernate_collectionTracker.getSize("enabledEventTypes");
                    if (realmEntity8.enabledEventTypes == null && n9 != -1) {
                        dirtyTracker9.add("enabledEventTypes");
                    } else if (realmEntity8.enabledEventTypes != null && (!(realmEntity8.enabledEventTypes instanceof PersistentCollection) || ((PersistentCollection)realmEntity8.enabledEventTypes).wasInitialized()) && n9 != realmEntity8.enabledEventTypes.size()) {
                        dirtyTracker9.add("enabledEventTypes");
                    }
                }
                if (realmEntity7.$$_hibernate_collectionTracker != null) {
                    int n10 = realmEntity7.$$_hibernate_collectionTracker.getSize("identityProviders");
                    if (realmEntity7.identityProviders == null && n10 != -1) {
                        dirtyTracker8.add("identityProviders");
                    } else if (realmEntity7.identityProviders != null && (!(realmEntity7.identityProviders instanceof PersistentCollection) || ((PersistentCollection)realmEntity7.identityProviders).wasInitialized()) && n10 != realmEntity7.identityProviders.size()) {
                        dirtyTracker8.add("identityProviders");
                    }
                }
                if (realmEntity6.$$_hibernate_collectionTracker != null) {
                    int n11 = realmEntity6.$$_hibernate_collectionTracker.getSize("identityProviderMappers");
                    if (realmEntity6.identityProviderMappers == null && n11 != -1) {
                        dirtyTracker7.add("identityProviderMappers");
                    } else if (realmEntity6.identityProviderMappers != null && (!(realmEntity6.identityProviderMappers instanceof PersistentCollection) || ((PersistentCollection)realmEntity6.identityProviderMappers).wasInitialized()) && n11 != realmEntity6.identityProviderMappers.size()) {
                        dirtyTracker7.add("identityProviderMappers");
                    }
                }
                if (realmEntity5.$$_hibernate_collectionTracker != null) {
                    int n12 = realmEntity5.$$_hibernate_collectionTracker.getSize("authenticators");
                    if (realmEntity5.authenticators == null && n12 != -1) {
                        dirtyTracker6.add("authenticators");
                    } else if (realmEntity5.authenticators != null && (!(realmEntity5.authenticators instanceof PersistentCollection) || ((PersistentCollection)realmEntity5.authenticators).wasInitialized()) && n12 != realmEntity5.authenticators.size()) {
                        dirtyTracker6.add("authenticators");
                    }
                }
                if (realmEntity4.$$_hibernate_collectionTracker != null) {
                    int n13 = realmEntity4.$$_hibernate_collectionTracker.getSize("requiredActionProviders");
                    if (realmEntity4.requiredActionProviders == null && n13 != -1) {
                        dirtyTracker5.add("requiredActionProviders");
                    } else if (realmEntity4.requiredActionProviders != null && (!(realmEntity4.requiredActionProviders instanceof PersistentCollection) || ((PersistentCollection)realmEntity4.requiredActionProviders).wasInitialized()) && n13 != realmEntity4.requiredActionProviders.size()) {
                        dirtyTracker5.add("requiredActionProviders");
                    }
                }
                if (realmEntity3.$$_hibernate_collectionTracker != null) {
                    int n14 = realmEntity3.$$_hibernate_collectionTracker.getSize("authenticationFlows");
                    if (realmEntity3.authenticationFlows == null && n14 != -1) {
                        dirtyTracker4.add("authenticationFlows");
                    } else if (realmEntity3.authenticationFlows != null && (!(realmEntity3.authenticationFlows instanceof PersistentCollection) || ((PersistentCollection)realmEntity3.authenticationFlows).wasInitialized()) && n14 != realmEntity3.authenticationFlows.size()) {
                        dirtyTracker4.add("authenticationFlows");
                    }
                }
                if (realmEntity2.$$_hibernate_collectionTracker != null) {
                    int n15 = realmEntity2.$$_hibernate_collectionTracker.getSize("components");
                    if (realmEntity2.components == null && n15 != -1) {
                        dirtyTracker3.add("components");
                    } else if (realmEntity2.components != null && (!(realmEntity2.components instanceof PersistentCollection) || ((PersistentCollection)realmEntity2.components).wasInitialized()) && n15 != realmEntity2.components.size()) {
                        dirtyTracker3.add("components");
                    }
                }
                if (realmEntity.$$_hibernate_collectionTracker != null) {
                    int n16 = realmEntity.$$_hibernate_collectionTracker.getSize("supportedLocales");
                    if (realmEntity.supportedLocales == null && n16 != -1) {
                        dirtyTracker2.add("supportedLocales");
                    } else if (realmEntity.supportedLocales != null && (!(realmEntity.supportedLocales instanceof PersistentCollection) || ((PersistentCollection)realmEntity.supportedLocales).wasInitialized()) && n16 != realmEntity.supportedLocales.size()) {
                        dirtyTracker2.add("supportedLocales");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block60;
                n = this.$$_hibernate_collectionTracker.getSize("realmLocalizationTexts");
                if (this.realmLocalizationTexts != null || n == -1) break block61;
                dirtyTracker.add("realmLocalizationTexts");
                break block60;
            }
            if (this.realmLocalizationTexts == null || this.realmLocalizationTexts instanceof PersistentCollection && !((PersistentCollection)this.realmLocalizationTexts).wasInitialized() || n == this.realmLocalizationTexts.size()) break block60;
            dirtyTracker.add("realmLocalizationTexts");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block48: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            RealmEntity realmEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            RealmEntity realmEntity2 = realmEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            RealmEntity realmEntity3 = realmEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            RealmEntity realmEntity4 = realmEntity3;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor5 = lazyAttributeLoadingInterceptor4;
            RealmEntity realmEntity5 = realmEntity4;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor6 = lazyAttributeLoadingInterceptor5;
            RealmEntity realmEntity6 = realmEntity5;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor7 = lazyAttributeLoadingInterceptor6;
            RealmEntity realmEntity7 = realmEntity6;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor8 = lazyAttributeLoadingInterceptor7;
            RealmEntity realmEntity8 = realmEntity7;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor9 = lazyAttributeLoadingInterceptor8;
            RealmEntity realmEntity9 = realmEntity8;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor10 = lazyAttributeLoadingInterceptor9;
            RealmEntity realmEntity10 = realmEntity9;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor11 = lazyAttributeLoadingInterceptor10;
            RealmEntity realmEntity11 = realmEntity10;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor12 = lazyAttributeLoadingInterceptor11;
            RealmEntity realmEntity12 = realmEntity11;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor13 = lazyAttributeLoadingInterceptor12;
            RealmEntity realmEntity13 = realmEntity12;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor14 = lazyAttributeLoadingInterceptor13;
            RealmEntity realmEntity14 = realmEntity13;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor15 = lazyAttributeLoadingInterceptor14;
            RealmEntity realmEntity15 = realmEntity14;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor16 = lazyAttributeLoadingInterceptor15;
            RealmEntity realmEntity16 = realmEntity15;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor17 = lazyAttributeLoadingInterceptor16;
            if (lazyAttributeLoadingInterceptor16 == null || lazyAttributeLoadingInterceptor16.isAttributeLoaded("attributes")) {
                if (realmEntity15.attributes == null || realmEntity15.attributes instanceof PersistentCollection && !((PersistentCollection)realmEntity15.attributes).wasInitialized()) {
                    realmEntity15.$$_hibernate_collectionTracker.add("attributes", -1);
                } else {
                    realmEntity15.$$_hibernate_collectionTracker.add("attributes", realmEntity15.attributes.size());
                }
            }
            if (lazyAttributeLoadingInterceptor15 == null || lazyAttributeLoadingInterceptor15.isAttributeLoaded("requiredCredentials")) {
                if (realmEntity14.requiredCredentials == null || realmEntity14.requiredCredentials instanceof PersistentCollection && !((PersistentCollection)realmEntity14.requiredCredentials).wasInitialized()) {
                    realmEntity14.$$_hibernate_collectionTracker.add("requiredCredentials", -1);
                } else {
                    realmEntity14.$$_hibernate_collectionTracker.add("requiredCredentials", realmEntity14.requiredCredentials.size());
                }
            }
            if (lazyAttributeLoadingInterceptor14 == null || lazyAttributeLoadingInterceptor14.isAttributeLoaded("userFederationProviders")) {
                if (realmEntity13.userFederationProviders == null || realmEntity13.userFederationProviders instanceof PersistentCollection && !((PersistentCollection)realmEntity13.userFederationProviders).wasInitialized()) {
                    realmEntity13.$$_hibernate_collectionTracker.add("userFederationProviders", -1);
                } else {
                    realmEntity13.$$_hibernate_collectionTracker.add("userFederationProviders", realmEntity13.userFederationProviders.size());
                }
            }
            if (lazyAttributeLoadingInterceptor13 == null || lazyAttributeLoadingInterceptor13.isAttributeLoaded("userFederationMappers")) {
                if (realmEntity12.userFederationMappers == null || realmEntity12.userFederationMappers instanceof PersistentCollection && !((PersistentCollection)realmEntity12.userFederationMappers).wasInitialized()) {
                    realmEntity12.$$_hibernate_collectionTracker.add("userFederationMappers", -1);
                } else {
                    realmEntity12.$$_hibernate_collectionTracker.add("userFederationMappers", realmEntity12.userFederationMappers.size());
                }
            }
            if (lazyAttributeLoadingInterceptor12 == null || lazyAttributeLoadingInterceptor12.isAttributeLoaded("smtpConfig")) {
                if (realmEntity11.smtpConfig == null || realmEntity11.smtpConfig instanceof PersistentCollection && !((PersistentCollection)realmEntity11.smtpConfig).wasInitialized()) {
                    realmEntity11.$$_hibernate_collectionTracker.add("smtpConfig", -1);
                } else {
                    realmEntity11.$$_hibernate_collectionTracker.add("smtpConfig", realmEntity11.smtpConfig.size());
                }
            }
            if (lazyAttributeLoadingInterceptor11 == null || lazyAttributeLoadingInterceptor11.isAttributeLoaded("defaultGroupIds")) {
                if (realmEntity10.defaultGroupIds == null || realmEntity10.defaultGroupIds instanceof PersistentCollection && !((PersistentCollection)realmEntity10.defaultGroupIds).wasInitialized()) {
                    realmEntity10.$$_hibernate_collectionTracker.add("defaultGroupIds", -1);
                } else {
                    realmEntity10.$$_hibernate_collectionTracker.add("defaultGroupIds", realmEntity10.defaultGroupIds.size());
                }
            }
            if (lazyAttributeLoadingInterceptor10 == null || lazyAttributeLoadingInterceptor10.isAttributeLoaded("eventsListeners")) {
                if (realmEntity9.eventsListeners == null || realmEntity9.eventsListeners instanceof PersistentCollection && !((PersistentCollection)realmEntity9.eventsListeners).wasInitialized()) {
                    realmEntity9.$$_hibernate_collectionTracker.add("eventsListeners", -1);
                } else {
                    realmEntity9.$$_hibernate_collectionTracker.add("eventsListeners", realmEntity9.eventsListeners.size());
                }
            }
            if (lazyAttributeLoadingInterceptor9 == null || lazyAttributeLoadingInterceptor9.isAttributeLoaded("enabledEventTypes")) {
                if (realmEntity8.enabledEventTypes == null || realmEntity8.enabledEventTypes instanceof PersistentCollection && !((PersistentCollection)realmEntity8.enabledEventTypes).wasInitialized()) {
                    realmEntity8.$$_hibernate_collectionTracker.add("enabledEventTypes", -1);
                } else {
                    realmEntity8.$$_hibernate_collectionTracker.add("enabledEventTypes", realmEntity8.enabledEventTypes.size());
                }
            }
            if (lazyAttributeLoadingInterceptor8 == null || lazyAttributeLoadingInterceptor8.isAttributeLoaded("identityProviders")) {
                if (realmEntity7.identityProviders == null || realmEntity7.identityProviders instanceof PersistentCollection && !((PersistentCollection)realmEntity7.identityProviders).wasInitialized()) {
                    realmEntity7.$$_hibernate_collectionTracker.add("identityProviders", -1);
                } else {
                    realmEntity7.$$_hibernate_collectionTracker.add("identityProviders", realmEntity7.identityProviders.size());
                }
            }
            if (lazyAttributeLoadingInterceptor7 == null || lazyAttributeLoadingInterceptor7.isAttributeLoaded("identityProviderMappers")) {
                if (realmEntity6.identityProviderMappers == null || realmEntity6.identityProviderMappers instanceof PersistentCollection && !((PersistentCollection)realmEntity6.identityProviderMappers).wasInitialized()) {
                    realmEntity6.$$_hibernate_collectionTracker.add("identityProviderMappers", -1);
                } else {
                    realmEntity6.$$_hibernate_collectionTracker.add("identityProviderMappers", realmEntity6.identityProviderMappers.size());
                }
            }
            if (lazyAttributeLoadingInterceptor6 == null || lazyAttributeLoadingInterceptor6.isAttributeLoaded("authenticators")) {
                if (realmEntity5.authenticators == null || realmEntity5.authenticators instanceof PersistentCollection && !((PersistentCollection)realmEntity5.authenticators).wasInitialized()) {
                    realmEntity5.$$_hibernate_collectionTracker.add("authenticators", -1);
                } else {
                    realmEntity5.$$_hibernate_collectionTracker.add("authenticators", realmEntity5.authenticators.size());
                }
            }
            if (lazyAttributeLoadingInterceptor5 == null || lazyAttributeLoadingInterceptor5.isAttributeLoaded("requiredActionProviders")) {
                if (realmEntity4.requiredActionProviders == null || realmEntity4.requiredActionProviders instanceof PersistentCollection && !((PersistentCollection)realmEntity4.requiredActionProviders).wasInitialized()) {
                    realmEntity4.$$_hibernate_collectionTracker.add("requiredActionProviders", -1);
                } else {
                    realmEntity4.$$_hibernate_collectionTracker.add("requiredActionProviders", realmEntity4.requiredActionProviders.size());
                }
            }
            if (lazyAttributeLoadingInterceptor4 == null || lazyAttributeLoadingInterceptor4.isAttributeLoaded("authenticationFlows")) {
                if (realmEntity3.authenticationFlows == null || realmEntity3.authenticationFlows instanceof PersistentCollection && !((PersistentCollection)realmEntity3.authenticationFlows).wasInitialized()) {
                    realmEntity3.$$_hibernate_collectionTracker.add("authenticationFlows", -1);
                } else {
                    realmEntity3.$$_hibernate_collectionTracker.add("authenticationFlows", realmEntity3.authenticationFlows.size());
                }
            }
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("components")) {
                if (realmEntity2.components == null || realmEntity2.components instanceof PersistentCollection && !((PersistentCollection)realmEntity2.components).wasInitialized()) {
                    realmEntity2.$$_hibernate_collectionTracker.add("components", -1);
                } else {
                    realmEntity2.$$_hibernate_collectionTracker.add("components", realmEntity2.components.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("supportedLocales")) {
                if (realmEntity.supportedLocales == null || realmEntity.supportedLocales instanceof PersistentCollection && !((PersistentCollection)realmEntity.supportedLocales).wasInitialized()) {
                    realmEntity.$$_hibernate_collectionTracker.add("supportedLocales", -1);
                } else {
                    realmEntity.$$_hibernate_collectionTracker.add("supportedLocales", realmEntity.supportedLocales.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("realmLocalizationTexts")) break block48;
            if (this.realmLocalizationTexts == null || this.realmLocalizationTexts instanceof PersistentCollection && !((PersistentCollection)this.realmLocalizationTexts).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("realmLocalizationTexts", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("realmLocalizationTexts", this.realmLocalizationTexts.size());
            }
        }
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public boolean $$_hibernate_read_enabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "enabled", this.enabled);
        }
        return this.enabled;
    }

    public void $$_hibernate_write_enabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"enabled", (boolean)bl, (boolean)this.enabled)) {
            this.$$_hibernate_trackChange("enabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "enabled", this.enabled, bl);
            return;
        }
        this.enabled = bl;
    }

    public String $$_hibernate_read_sslRequired() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.sslRequired = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "sslRequired", (Object)this.sslRequired);
        }
        return this.sslRequired;
    }

    public void $$_hibernate_write_sslRequired(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"sslRequired", (Object)string, (Object)this.sslRequired)) {
            this.$$_hibernate_trackChange("sslRequired");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.sslRequired = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "sslRequired", (Object)this.sslRequired, (Object)string);
            return;
        }
        this.sslRequired = string;
    }

    public boolean $$_hibernate_read_registrationAllowed() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationAllowed = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "registrationAllowed", this.registrationAllowed);
        }
        return this.registrationAllowed;
    }

    public void $$_hibernate_write_registrationAllowed(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"registrationAllowed", (boolean)bl, (boolean)this.registrationAllowed)) {
            this.$$_hibernate_trackChange("registrationAllowed");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationAllowed = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "registrationAllowed", this.registrationAllowed, bl);
            return;
        }
        this.registrationAllowed = bl;
    }

    public boolean $$_hibernate_read_registrationEmailAsUsername() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationEmailAsUsername = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "registrationEmailAsUsername", this.registrationEmailAsUsername);
        }
        return this.registrationEmailAsUsername;
    }

    public void $$_hibernate_write_registrationEmailAsUsername(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"registrationEmailAsUsername", (boolean)bl, (boolean)this.registrationEmailAsUsername)) {
            this.$$_hibernate_trackChange("registrationEmailAsUsername");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationEmailAsUsername = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "registrationEmailAsUsername", this.registrationEmailAsUsername, bl);
            return;
        }
        this.registrationEmailAsUsername = bl;
    }

    public boolean $$_hibernate_read_verifyEmail() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.verifyEmail = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "verifyEmail", this.verifyEmail);
        }
        return this.verifyEmail;
    }

    public void $$_hibernate_write_verifyEmail(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"verifyEmail", (boolean)bl, (boolean)this.verifyEmail)) {
            this.$$_hibernate_trackChange("verifyEmail");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.verifyEmail = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "verifyEmail", this.verifyEmail, bl);
            return;
        }
        this.verifyEmail = bl;
    }

    public boolean $$_hibernate_read_resetPasswordAllowed() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resetPasswordAllowed = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "resetPasswordAllowed", this.resetPasswordAllowed);
        }
        return this.resetPasswordAllowed;
    }

    public void $$_hibernate_write_resetPasswordAllowed(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resetPasswordAllowed", (boolean)bl, (boolean)this.resetPasswordAllowed)) {
            this.$$_hibernate_trackChange("resetPasswordAllowed");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resetPasswordAllowed = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "resetPasswordAllowed", this.resetPasswordAllowed, bl);
            return;
        }
        this.resetPasswordAllowed = bl;
    }

    public boolean $$_hibernate_read_loginWithEmailAllowed() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.loginWithEmailAllowed = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "loginWithEmailAllowed", this.loginWithEmailAllowed);
        }
        return this.loginWithEmailAllowed;
    }

    public void $$_hibernate_write_loginWithEmailAllowed(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"loginWithEmailAllowed", (boolean)bl, (boolean)this.loginWithEmailAllowed)) {
            this.$$_hibernate_trackChange("loginWithEmailAllowed");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.loginWithEmailAllowed = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "loginWithEmailAllowed", this.loginWithEmailAllowed, bl);
            return;
        }
        this.loginWithEmailAllowed = bl;
    }

    public boolean $$_hibernate_read_duplicateEmailsAllowed() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.duplicateEmailsAllowed = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "duplicateEmailsAllowed", this.duplicateEmailsAllowed);
        }
        return this.duplicateEmailsAllowed;
    }

    public void $$_hibernate_write_duplicateEmailsAllowed(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"duplicateEmailsAllowed", (boolean)bl, (boolean)this.duplicateEmailsAllowed)) {
            this.$$_hibernate_trackChange("duplicateEmailsAllowed");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.duplicateEmailsAllowed = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "duplicateEmailsAllowed", this.duplicateEmailsAllowed, bl);
            return;
        }
        this.duplicateEmailsAllowed = bl;
    }

    public boolean $$_hibernate_read_rememberMe() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rememberMe = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "rememberMe", this.rememberMe);
        }
        return this.rememberMe;
    }

    public void $$_hibernate_write_rememberMe(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"rememberMe", (boolean)bl, (boolean)this.rememberMe)) {
            this.$$_hibernate_trackChange("rememberMe");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rememberMe = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "rememberMe", this.rememberMe, bl);
            return;
        }
        this.rememberMe = bl;
    }

    public String $$_hibernate_read_passwordPolicy() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.passwordPolicy = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "passwordPolicy", (Object)this.passwordPolicy);
        }
        return this.passwordPolicy;
    }

    public void $$_hibernate_write_passwordPolicy(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"passwordPolicy", (Object)string, (Object)this.passwordPolicy)) {
            this.$$_hibernate_trackChange("passwordPolicy");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.passwordPolicy = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "passwordPolicy", (Object)this.passwordPolicy, (Object)string);
            return;
        }
        this.passwordPolicy = string;
    }

    public String $$_hibernate_read_otpPolicyType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "otpPolicyType", (Object)this.otpPolicyType);
        }
        return this.otpPolicyType;
    }

    public void $$_hibernate_write_otpPolicyType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"otpPolicyType", (Object)string, (Object)this.otpPolicyType)) {
            this.$$_hibernate_trackChange("otpPolicyType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "otpPolicyType", (Object)this.otpPolicyType, (Object)string);
            return;
        }
        this.otpPolicyType = string;
    }

    public String $$_hibernate_read_otpPolicyAlgorithm() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyAlgorithm = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "otpPolicyAlgorithm", (Object)this.otpPolicyAlgorithm);
        }
        return this.otpPolicyAlgorithm;
    }

    public void $$_hibernate_write_otpPolicyAlgorithm(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"otpPolicyAlgorithm", (Object)string, (Object)this.otpPolicyAlgorithm)) {
            this.$$_hibernate_trackChange("otpPolicyAlgorithm");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyAlgorithm = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "otpPolicyAlgorithm", (Object)this.otpPolicyAlgorithm, (Object)string);
            return;
        }
        this.otpPolicyAlgorithm = string;
    }

    public int $$_hibernate_read_otpPolicyInitialCounter() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyInitialCounter = this.$$_hibernate_getInterceptor().readInt((Object)this, "otpPolicyInitialCounter", this.otpPolicyInitialCounter);
        }
        return this.otpPolicyInitialCounter;
    }

    public void $$_hibernate_write_otpPolicyInitialCounter(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"otpPolicyInitialCounter", (int)n, (int)this.otpPolicyInitialCounter)) {
            this.$$_hibernate_trackChange("otpPolicyInitialCounter");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyInitialCounter = this.$$_hibernate_getInterceptor().writeInt((Object)this, "otpPolicyInitialCounter", this.otpPolicyInitialCounter, n);
            return;
        }
        this.otpPolicyInitialCounter = n;
    }

    public int $$_hibernate_read_otpPolicyDigits() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyDigits = this.$$_hibernate_getInterceptor().readInt((Object)this, "otpPolicyDigits", this.otpPolicyDigits);
        }
        return this.otpPolicyDigits;
    }

    public void $$_hibernate_write_otpPolicyDigits(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"otpPolicyDigits", (int)n, (int)this.otpPolicyDigits)) {
            this.$$_hibernate_trackChange("otpPolicyDigits");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyDigits = this.$$_hibernate_getInterceptor().writeInt((Object)this, "otpPolicyDigits", this.otpPolicyDigits, n);
            return;
        }
        this.otpPolicyDigits = n;
    }

    public int $$_hibernate_read_otpPolicyLookAheadWindow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyLookAheadWindow = this.$$_hibernate_getInterceptor().readInt((Object)this, "otpPolicyLookAheadWindow", this.otpPolicyLookAheadWindow);
        }
        return this.otpPolicyLookAheadWindow;
    }

    public void $$_hibernate_write_otpPolicyLookAheadWindow(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"otpPolicyLookAheadWindow", (int)n, (int)this.otpPolicyLookAheadWindow)) {
            this.$$_hibernate_trackChange("otpPolicyLookAheadWindow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyLookAheadWindow = this.$$_hibernate_getInterceptor().writeInt((Object)this, "otpPolicyLookAheadWindow", this.otpPolicyLookAheadWindow, n);
            return;
        }
        this.otpPolicyLookAheadWindow = n;
    }

    public int $$_hibernate_read_otpPolicyPeriod() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyPeriod = this.$$_hibernate_getInterceptor().readInt((Object)this, "otpPolicyPeriod", this.otpPolicyPeriod);
        }
        return this.otpPolicyPeriod;
    }

    public void $$_hibernate_write_otpPolicyPeriod(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"otpPolicyPeriod", (int)n, (int)this.otpPolicyPeriod)) {
            this.$$_hibernate_trackChange("otpPolicyPeriod");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.otpPolicyPeriod = this.$$_hibernate_getInterceptor().writeInt((Object)this, "otpPolicyPeriod", this.otpPolicyPeriod, n);
            return;
        }
        this.otpPolicyPeriod = n;
    }

    public boolean $$_hibernate_read_editUsernameAllowed() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.editUsernameAllowed = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "editUsernameAllowed", this.editUsernameAllowed);
        }
        return this.editUsernameAllowed;
    }

    public void $$_hibernate_write_editUsernameAllowed(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"editUsernameAllowed", (boolean)bl, (boolean)this.editUsernameAllowed)) {
            this.$$_hibernate_trackChange("editUsernameAllowed");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.editUsernameAllowed = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "editUsernameAllowed", this.editUsernameAllowed, bl);
            return;
        }
        this.editUsernameAllowed = bl;
    }

    public boolean $$_hibernate_read_revokeRefreshToken() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.revokeRefreshToken = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "revokeRefreshToken", this.revokeRefreshToken);
        }
        return this.revokeRefreshToken;
    }

    public void $$_hibernate_write_revokeRefreshToken(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"revokeRefreshToken", (boolean)bl, (boolean)this.revokeRefreshToken)) {
            this.$$_hibernate_trackChange("revokeRefreshToken");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.revokeRefreshToken = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "revokeRefreshToken", this.revokeRefreshToken, bl);
            return;
        }
        this.revokeRefreshToken = bl;
    }

    public int $$_hibernate_read_refreshTokenMaxReuse() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.refreshTokenMaxReuse = this.$$_hibernate_getInterceptor().readInt((Object)this, "refreshTokenMaxReuse", this.refreshTokenMaxReuse);
        }
        return this.refreshTokenMaxReuse;
    }

    public void $$_hibernate_write_refreshTokenMaxReuse(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"refreshTokenMaxReuse", (int)n, (int)this.refreshTokenMaxReuse)) {
            this.$$_hibernate_trackChange("refreshTokenMaxReuse");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.refreshTokenMaxReuse = this.$$_hibernate_getInterceptor().writeInt((Object)this, "refreshTokenMaxReuse", this.refreshTokenMaxReuse, n);
            return;
        }
        this.refreshTokenMaxReuse = n;
    }

    public int $$_hibernate_read_ssoSessionIdleTimeout() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionIdleTimeout = this.$$_hibernate_getInterceptor().readInt((Object)this, "ssoSessionIdleTimeout", this.ssoSessionIdleTimeout);
        }
        return this.ssoSessionIdleTimeout;
    }

    public void $$_hibernate_write_ssoSessionIdleTimeout(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"ssoSessionIdleTimeout", (int)n, (int)this.ssoSessionIdleTimeout)) {
            this.$$_hibernate_trackChange("ssoSessionIdleTimeout");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionIdleTimeout = this.$$_hibernate_getInterceptor().writeInt((Object)this, "ssoSessionIdleTimeout", this.ssoSessionIdleTimeout, n);
            return;
        }
        this.ssoSessionIdleTimeout = n;
    }

    public int $$_hibernate_read_ssoSessionMaxLifespan() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionMaxLifespan = this.$$_hibernate_getInterceptor().readInt((Object)this, "ssoSessionMaxLifespan", this.ssoSessionMaxLifespan);
        }
        return this.ssoSessionMaxLifespan;
    }

    public void $$_hibernate_write_ssoSessionMaxLifespan(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"ssoSessionMaxLifespan", (int)n, (int)this.ssoSessionMaxLifespan)) {
            this.$$_hibernate_trackChange("ssoSessionMaxLifespan");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionMaxLifespan = this.$$_hibernate_getInterceptor().writeInt((Object)this, "ssoSessionMaxLifespan", this.ssoSessionMaxLifespan, n);
            return;
        }
        this.ssoSessionMaxLifespan = n;
    }

    public int $$_hibernate_read_ssoSessionIdleTimeoutRememberMe() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionIdleTimeoutRememberMe = this.$$_hibernate_getInterceptor().readInt((Object)this, "ssoSessionIdleTimeoutRememberMe", this.ssoSessionIdleTimeoutRememberMe);
        }
        return this.ssoSessionIdleTimeoutRememberMe;
    }

    public void $$_hibernate_write_ssoSessionIdleTimeoutRememberMe(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"ssoSessionIdleTimeoutRememberMe", (int)n, (int)this.ssoSessionIdleTimeoutRememberMe)) {
            this.$$_hibernate_trackChange("ssoSessionIdleTimeoutRememberMe");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionIdleTimeoutRememberMe = this.$$_hibernate_getInterceptor().writeInt((Object)this, "ssoSessionIdleTimeoutRememberMe", this.ssoSessionIdleTimeoutRememberMe, n);
            return;
        }
        this.ssoSessionIdleTimeoutRememberMe = n;
    }

    public int $$_hibernate_read_ssoSessionMaxLifespanRememberMe() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionMaxLifespanRememberMe = this.$$_hibernate_getInterceptor().readInt((Object)this, "ssoSessionMaxLifespanRememberMe", this.ssoSessionMaxLifespanRememberMe);
        }
        return this.ssoSessionMaxLifespanRememberMe;
    }

    public void $$_hibernate_write_ssoSessionMaxLifespanRememberMe(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"ssoSessionMaxLifespanRememberMe", (int)n, (int)this.ssoSessionMaxLifespanRememberMe)) {
            this.$$_hibernate_trackChange("ssoSessionMaxLifespanRememberMe");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.ssoSessionMaxLifespanRememberMe = this.$$_hibernate_getInterceptor().writeInt((Object)this, "ssoSessionMaxLifespanRememberMe", this.ssoSessionMaxLifespanRememberMe, n);
            return;
        }
        this.ssoSessionMaxLifespanRememberMe = n;
    }

    public int $$_hibernate_read_offlineSessionIdleTimeout() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offlineSessionIdleTimeout = this.$$_hibernate_getInterceptor().readInt((Object)this, "offlineSessionIdleTimeout", this.offlineSessionIdleTimeout);
        }
        return this.offlineSessionIdleTimeout;
    }

    public void $$_hibernate_write_offlineSessionIdleTimeout(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"offlineSessionIdleTimeout", (int)n, (int)this.offlineSessionIdleTimeout)) {
            this.$$_hibernate_trackChange("offlineSessionIdleTimeout");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offlineSessionIdleTimeout = this.$$_hibernate_getInterceptor().writeInt((Object)this, "offlineSessionIdleTimeout", this.offlineSessionIdleTimeout, n);
            return;
        }
        this.offlineSessionIdleTimeout = n;
    }

    public int $$_hibernate_read_accessTokenLifespan() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessTokenLifespan = this.$$_hibernate_getInterceptor().readInt((Object)this, "accessTokenLifespan", this.accessTokenLifespan);
        }
        return this.accessTokenLifespan;
    }

    public void $$_hibernate_write_accessTokenLifespan(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"accessTokenLifespan", (int)n, (int)this.accessTokenLifespan)) {
            this.$$_hibernate_trackChange("accessTokenLifespan");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessTokenLifespan = this.$$_hibernate_getInterceptor().writeInt((Object)this, "accessTokenLifespan", this.accessTokenLifespan, n);
            return;
        }
        this.accessTokenLifespan = n;
    }

    public int $$_hibernate_read_accessTokenLifespanForImplicitFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessTokenLifespanForImplicitFlow = this.$$_hibernate_getInterceptor().readInt((Object)this, "accessTokenLifespanForImplicitFlow", this.accessTokenLifespanForImplicitFlow);
        }
        return this.accessTokenLifespanForImplicitFlow;
    }

    public void $$_hibernate_write_accessTokenLifespanForImplicitFlow(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"accessTokenLifespanForImplicitFlow", (int)n, (int)this.accessTokenLifespanForImplicitFlow)) {
            this.$$_hibernate_trackChange("accessTokenLifespanForImplicitFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessTokenLifespanForImplicitFlow = this.$$_hibernate_getInterceptor().writeInt((Object)this, "accessTokenLifespanForImplicitFlow", this.accessTokenLifespanForImplicitFlow, n);
            return;
        }
        this.accessTokenLifespanForImplicitFlow = n;
    }

    public int $$_hibernate_read_accessCodeLifespan() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessCodeLifespan = this.$$_hibernate_getInterceptor().readInt((Object)this, "accessCodeLifespan", this.accessCodeLifespan);
        }
        return this.accessCodeLifespan;
    }

    public void $$_hibernate_write_accessCodeLifespan(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"accessCodeLifespan", (int)n, (int)this.accessCodeLifespan)) {
            this.$$_hibernate_trackChange("accessCodeLifespan");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessCodeLifespan = this.$$_hibernate_getInterceptor().writeInt((Object)this, "accessCodeLifespan", this.accessCodeLifespan, n);
            return;
        }
        this.accessCodeLifespan = n;
    }

    public int $$_hibernate_read_accessCodeLifespanUserAction() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessCodeLifespanUserAction = this.$$_hibernate_getInterceptor().readInt((Object)this, "accessCodeLifespanUserAction", this.accessCodeLifespanUserAction);
        }
        return this.accessCodeLifespanUserAction;
    }

    public void $$_hibernate_write_accessCodeLifespanUserAction(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"accessCodeLifespanUserAction", (int)n, (int)this.accessCodeLifespanUserAction)) {
            this.$$_hibernate_trackChange("accessCodeLifespanUserAction");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessCodeLifespanUserAction = this.$$_hibernate_getInterceptor().writeInt((Object)this, "accessCodeLifespanUserAction", this.accessCodeLifespanUserAction, n);
            return;
        }
        this.accessCodeLifespanUserAction = n;
    }

    public int $$_hibernate_read_accessCodeLifespanLogin() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessCodeLifespanLogin = this.$$_hibernate_getInterceptor().readInt((Object)this, "accessCodeLifespanLogin", this.accessCodeLifespanLogin);
        }
        return this.accessCodeLifespanLogin;
    }

    public void $$_hibernate_write_accessCodeLifespanLogin(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"accessCodeLifespanLogin", (int)n, (int)this.accessCodeLifespanLogin)) {
            this.$$_hibernate_trackChange("accessCodeLifespanLogin");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accessCodeLifespanLogin = this.$$_hibernate_getInterceptor().writeInt((Object)this, "accessCodeLifespanLogin", this.accessCodeLifespanLogin, n);
            return;
        }
        this.accessCodeLifespanLogin = n;
    }

    public int $$_hibernate_read_notBefore() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().readInt((Object)this, "notBefore", this.notBefore);
        }
        return this.notBefore;
    }

    public void $$_hibernate_write_notBefore(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notBefore", (int)n, (int)this.notBefore)) {
            this.$$_hibernate_trackChange("notBefore");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notBefore = this.$$_hibernate_getInterceptor().writeInt((Object)this, "notBefore", this.notBefore, n);
            return;
        }
        this.notBefore = n;
    }

    public String $$_hibernate_read_loginTheme() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.loginTheme = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "loginTheme", (Object)this.loginTheme);
        }
        return this.loginTheme;
    }

    public void $$_hibernate_write_loginTheme(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"loginTheme", (Object)string, (Object)this.loginTheme)) {
            this.$$_hibernate_trackChange("loginTheme");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.loginTheme = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "loginTheme", (Object)this.loginTheme, (Object)string);
            return;
        }
        this.loginTheme = string;
    }

    public String $$_hibernate_read_accountTheme() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accountTheme = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "accountTheme", (Object)this.accountTheme);
        }
        return this.accountTheme;
    }

    public void $$_hibernate_write_accountTheme(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"accountTheme", (Object)string, (Object)this.accountTheme)) {
            this.$$_hibernate_trackChange("accountTheme");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.accountTheme = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "accountTheme", (Object)this.accountTheme, (Object)string);
            return;
        }
        this.accountTheme = string;
    }

    public String $$_hibernate_read_adminTheme() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminTheme = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "adminTheme", (Object)this.adminTheme);
        }
        return this.adminTheme;
    }

    public void $$_hibernate_write_adminTheme(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"adminTheme", (Object)string, (Object)this.adminTheme)) {
            this.$$_hibernate_trackChange("adminTheme");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminTheme = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "adminTheme", (Object)this.adminTheme, (Object)string);
            return;
        }
        this.adminTheme = string;
    }

    public String $$_hibernate_read_emailTheme() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailTheme = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "emailTheme", (Object)this.emailTheme);
        }
        return this.emailTheme;
    }

    public void $$_hibernate_write_emailTheme(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"emailTheme", (Object)string, (Object)this.emailTheme)) {
            this.$$_hibernate_trackChange("emailTheme");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.emailTheme = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "emailTheme", (Object)this.emailTheme, (Object)string);
            return;
        }
        this.emailTheme = string;
    }

    public Collection $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)collection);
            return;
        }
        this.attributes = collection;
    }

    public Collection $$_hibernate_read_requiredCredentials() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredCredentials = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "requiredCredentials", this.requiredCredentials);
        }
        return this.requiredCredentials;
    }

    public void $$_hibernate_write_requiredCredentials(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredCredentials = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requiredCredentials", this.requiredCredentials, (Object)collection);
            return;
        }
        this.requiredCredentials = collection;
    }

    public List $$_hibernate_read_userFederationProviders() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userFederationProviders = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "userFederationProviders", this.userFederationProviders);
        }
        return this.userFederationProviders;
    }

    public void $$_hibernate_write_userFederationProviders(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userFederationProviders = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userFederationProviders", this.userFederationProviders, (Object)list);
            return;
        }
        this.userFederationProviders = list;
    }

    public Collection $$_hibernate_read_userFederationMappers() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userFederationMappers = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "userFederationMappers", this.userFederationMappers);
        }
        return this.userFederationMappers;
    }

    public void $$_hibernate_write_userFederationMappers(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userFederationMappers = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userFederationMappers", this.userFederationMappers, (Object)collection);
            return;
        }
        this.userFederationMappers = collection;
    }

    public Map $$_hibernate_read_smtpConfig() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.smtpConfig = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "smtpConfig", this.smtpConfig);
        }
        return this.smtpConfig;
    }

    public void $$_hibernate_write_smtpConfig(Map map) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"smtpConfig", (Object)map, this.smtpConfig)) {
            this.$$_hibernate_trackChange("smtpConfig");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.smtpConfig = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "smtpConfig", this.smtpConfig, (Object)map);
            return;
        }
        this.smtpConfig = map;
    }

    public Set $$_hibernate_read_defaultGroupIds() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultGroupIds = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "defaultGroupIds", this.defaultGroupIds);
        }
        return this.defaultGroupIds;
    }

    public void $$_hibernate_write_defaultGroupIds(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultGroupIds = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "defaultGroupIds", this.defaultGroupIds, (Object)set);
            return;
        }
        this.defaultGroupIds = set;
    }

    public boolean $$_hibernate_read_eventsEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.eventsEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "eventsEnabled", this.eventsEnabled);
        }
        return this.eventsEnabled;
    }

    public void $$_hibernate_write_eventsEnabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"eventsEnabled", (boolean)bl, (boolean)this.eventsEnabled)) {
            this.$$_hibernate_trackChange("eventsEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.eventsEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "eventsEnabled", this.eventsEnabled, bl);
            return;
        }
        this.eventsEnabled = bl;
    }

    public long $$_hibernate_read_eventsExpiration() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.eventsExpiration = this.$$_hibernate_getInterceptor().readLong((Object)this, "eventsExpiration", this.eventsExpiration);
        }
        return this.eventsExpiration;
    }

    public void $$_hibernate_write_eventsExpiration(long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"eventsExpiration", (long)l, (long)this.eventsExpiration)) {
            this.$$_hibernate_trackChange("eventsExpiration");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.eventsExpiration = this.$$_hibernate_getInterceptor().writeLong((Object)this, "eventsExpiration", this.eventsExpiration, l);
            return;
        }
        this.eventsExpiration = l;
    }

    public Set $$_hibernate_read_eventsListeners() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.eventsListeners = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "eventsListeners", this.eventsListeners);
        }
        return this.eventsListeners;
    }

    public void $$_hibernate_write_eventsListeners(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.eventsListeners = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "eventsListeners", this.eventsListeners, (Object)set);
            return;
        }
        this.eventsListeners = set;
    }

    public Set $$_hibernate_read_enabledEventTypes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabledEventTypes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "enabledEventTypes", this.enabledEventTypes);
        }
        return this.enabledEventTypes;
    }

    public void $$_hibernate_write_enabledEventTypes(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.enabledEventTypes = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "enabledEventTypes", this.enabledEventTypes, (Object)set);
            return;
        }
        this.enabledEventTypes = set;
    }

    public boolean $$_hibernate_read_adminEventsEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminEventsEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "adminEventsEnabled", this.adminEventsEnabled);
        }
        return this.adminEventsEnabled;
    }

    public void $$_hibernate_write_adminEventsEnabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"adminEventsEnabled", (boolean)bl, (boolean)this.adminEventsEnabled)) {
            this.$$_hibernate_trackChange("adminEventsEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminEventsEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "adminEventsEnabled", this.adminEventsEnabled, bl);
            return;
        }
        this.adminEventsEnabled = bl;
    }

    public boolean $$_hibernate_read_adminEventsDetailsEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminEventsDetailsEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "adminEventsDetailsEnabled", this.adminEventsDetailsEnabled);
        }
        return this.adminEventsDetailsEnabled;
    }

    public void $$_hibernate_write_adminEventsDetailsEnabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"adminEventsDetailsEnabled", (boolean)bl, (boolean)this.adminEventsDetailsEnabled)) {
            this.$$_hibernate_trackChange("adminEventsDetailsEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.adminEventsDetailsEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "adminEventsDetailsEnabled", this.adminEventsDetailsEnabled, bl);
            return;
        }
        this.adminEventsDetailsEnabled = bl;
    }

    public String $$_hibernate_read_masterAdminClient() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.masterAdminClient = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "masterAdminClient", (Object)this.masterAdminClient);
        }
        return this.masterAdminClient;
    }

    public void $$_hibernate_write_masterAdminClient(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"masterAdminClient", (Object)string, (Object)this.masterAdminClient)) {
            this.$$_hibernate_trackChange("masterAdminClient");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.masterAdminClient = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "masterAdminClient", (Object)this.masterAdminClient, (Object)string);
            return;
        }
        this.masterAdminClient = string;
    }

    public String $$_hibernate_read_defaultRoleId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultRoleId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "defaultRoleId", (Object)this.defaultRoleId);
        }
        return this.defaultRoleId;
    }

    public void $$_hibernate_write_defaultRoleId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"defaultRoleId", (Object)string, (Object)this.defaultRoleId)) {
            this.$$_hibernate_trackChange("defaultRoleId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultRoleId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "defaultRoleId", (Object)this.defaultRoleId, (Object)string);
            return;
        }
        this.defaultRoleId = string;
    }

    public List $$_hibernate_read_identityProviders() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.identityProviders = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "identityProviders", this.identityProviders);
        }
        return this.identityProviders;
    }

    public void $$_hibernate_write_identityProviders(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.identityProviders = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "identityProviders", this.identityProviders, (Object)list);
            return;
        }
        this.identityProviders = list;
    }

    public Collection $$_hibernate_read_identityProviderMappers() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.identityProviderMappers = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "identityProviderMappers", this.identityProviderMappers);
        }
        return this.identityProviderMappers;
    }

    public void $$_hibernate_write_identityProviderMappers(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.identityProviderMappers = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "identityProviderMappers", this.identityProviderMappers, (Object)collection);
            return;
        }
        this.identityProviderMappers = collection;
    }

    public Collection $$_hibernate_read_authenticators() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authenticators = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "authenticators", this.authenticators);
        }
        return this.authenticators;
    }

    public void $$_hibernate_write_authenticators(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authenticators = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authenticators", this.authenticators, (Object)collection);
            return;
        }
        this.authenticators = collection;
    }

    public Collection $$_hibernate_read_requiredActionProviders() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredActionProviders = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "requiredActionProviders", this.requiredActionProviders);
        }
        return this.requiredActionProviders;
    }

    public void $$_hibernate_write_requiredActionProviders(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requiredActionProviders = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requiredActionProviders", this.requiredActionProviders, (Object)collection);
            return;
        }
        this.requiredActionProviders = collection;
    }

    public Collection $$_hibernate_read_authenticationFlows() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authenticationFlows = (Collection)this.$$_hibernate_getInterceptor().readObject((Object)this, "authenticationFlows", this.authenticationFlows);
        }
        return this.authenticationFlows;
    }

    public void $$_hibernate_write_authenticationFlows(Collection collection) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.authenticationFlows = (Collection)this.$$_hibernate_getInterceptor().writeObject((Object)this, "authenticationFlows", this.authenticationFlows, (Object)collection);
            return;
        }
        this.authenticationFlows = collection;
    }

    public Set $$_hibernate_read_components() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.components = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "components", this.components);
        }
        return this.components;
    }

    public void $$_hibernate_write_components(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.components = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "components", this.components, (Object)set);
            return;
        }
        this.components = set;
    }

    public String $$_hibernate_read_browserFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.browserFlow = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "browserFlow", (Object)this.browserFlow);
        }
        return this.browserFlow;
    }

    public void $$_hibernate_write_browserFlow(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"browserFlow", (Object)string, (Object)this.browserFlow)) {
            this.$$_hibernate_trackChange("browserFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.browserFlow = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "browserFlow", (Object)this.browserFlow, (Object)string);
            return;
        }
        this.browserFlow = string;
    }

    public String $$_hibernate_read_registrationFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationFlow = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "registrationFlow", (Object)this.registrationFlow);
        }
        return this.registrationFlow;
    }

    public void $$_hibernate_write_registrationFlow(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"registrationFlow", (Object)string, (Object)this.registrationFlow)) {
            this.$$_hibernate_trackChange("registrationFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.registrationFlow = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "registrationFlow", (Object)this.registrationFlow, (Object)string);
            return;
        }
        this.registrationFlow = string;
    }

    public String $$_hibernate_read_directGrantFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.directGrantFlow = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "directGrantFlow", (Object)this.directGrantFlow);
        }
        return this.directGrantFlow;
    }

    public void $$_hibernate_write_directGrantFlow(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"directGrantFlow", (Object)string, (Object)this.directGrantFlow)) {
            this.$$_hibernate_trackChange("directGrantFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.directGrantFlow = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "directGrantFlow", (Object)this.directGrantFlow, (Object)string);
            return;
        }
        this.directGrantFlow = string;
    }

    public String $$_hibernate_read_resetCredentialsFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resetCredentialsFlow = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "resetCredentialsFlow", (Object)this.resetCredentialsFlow);
        }
        return this.resetCredentialsFlow;
    }

    public void $$_hibernate_write_resetCredentialsFlow(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resetCredentialsFlow", (Object)string, (Object)this.resetCredentialsFlow)) {
            this.$$_hibernate_trackChange("resetCredentialsFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resetCredentialsFlow = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resetCredentialsFlow", (Object)this.resetCredentialsFlow, (Object)string);
            return;
        }
        this.resetCredentialsFlow = string;
    }

    public String $$_hibernate_read_clientAuthenticationFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientAuthenticationFlow = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientAuthenticationFlow", (Object)this.clientAuthenticationFlow);
        }
        return this.clientAuthenticationFlow;
    }

    public void $$_hibernate_write_clientAuthenticationFlow(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientAuthenticationFlow", (Object)string, (Object)this.clientAuthenticationFlow)) {
            this.$$_hibernate_trackChange("clientAuthenticationFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientAuthenticationFlow = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientAuthenticationFlow", (Object)this.clientAuthenticationFlow, (Object)string);
            return;
        }
        this.clientAuthenticationFlow = string;
    }

    public String $$_hibernate_read_dockerAuthenticationFlow() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.dockerAuthenticationFlow = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "dockerAuthenticationFlow", (Object)this.dockerAuthenticationFlow);
        }
        return this.dockerAuthenticationFlow;
    }

    public void $$_hibernate_write_dockerAuthenticationFlow(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"dockerAuthenticationFlow", (Object)string, (Object)this.dockerAuthenticationFlow)) {
            this.$$_hibernate_trackChange("dockerAuthenticationFlow");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.dockerAuthenticationFlow = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "dockerAuthenticationFlow", (Object)this.dockerAuthenticationFlow, (Object)string);
            return;
        }
        this.dockerAuthenticationFlow = string;
    }

    public boolean $$_hibernate_read_internationalizationEnabled() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.internationalizationEnabled = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "internationalizationEnabled", this.internationalizationEnabled);
        }
        return this.internationalizationEnabled;
    }

    public void $$_hibernate_write_internationalizationEnabled(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"internationalizationEnabled", (boolean)bl, (boolean)this.internationalizationEnabled)) {
            this.$$_hibernate_trackChange("internationalizationEnabled");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.internationalizationEnabled = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "internationalizationEnabled", this.internationalizationEnabled, bl);
            return;
        }
        this.internationalizationEnabled = bl;
    }

    public Set $$_hibernate_read_supportedLocales() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.supportedLocales = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "supportedLocales", this.supportedLocales);
        }
        return this.supportedLocales;
    }

    public void $$_hibernate_write_supportedLocales(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.supportedLocales = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "supportedLocales", this.supportedLocales, (Object)set);
            return;
        }
        this.supportedLocales = set;
    }

    public String $$_hibernate_read_defaultLocale() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultLocale = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "defaultLocale", (Object)this.defaultLocale);
        }
        return this.defaultLocale;
    }

    public void $$_hibernate_write_defaultLocale(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"defaultLocale", (Object)string, (Object)this.defaultLocale)) {
            this.$$_hibernate_trackChange("defaultLocale");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.defaultLocale = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "defaultLocale", (Object)this.defaultLocale, (Object)string);
            return;
        }
        this.defaultLocale = string;
    }

    public boolean $$_hibernate_read_allowUserManagedAccess() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.allowUserManagedAccess = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "allowUserManagedAccess", this.allowUserManagedAccess);
        }
        return this.allowUserManagedAccess;
    }

    public void $$_hibernate_write_allowUserManagedAccess(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"allowUserManagedAccess", (boolean)bl, (boolean)this.allowUserManagedAccess)) {
            this.$$_hibernate_trackChange("allowUserManagedAccess");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.allowUserManagedAccess = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "allowUserManagedAccess", this.allowUserManagedAccess, bl);
            return;
        }
        this.allowUserManagedAccess = bl;
    }

    public Map $$_hibernate_read_realmLocalizationTexts() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmLocalizationTexts = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmLocalizationTexts", this.realmLocalizationTexts);
        }
        return this.realmLocalizationTexts;
    }

    public void $$_hibernate_write_realmLocalizationTexts(Map map) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"realmLocalizationTexts", (Object)map, this.realmLocalizationTexts)) {
            this.$$_hibernate_trackChange("realmLocalizationTexts");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmLocalizationTexts = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmLocalizationTexts", this.realmLocalizationTexts, (Object)map);
            return;
        }
        this.realmLocalizationTexts = map;
    }
}

