/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.internal.Monitor;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.DownHostsCache;

public class InetAddressResolver {
    private static Hashtable<String, InetAddress[]> inetAddressesCache = new Hashtable();
    private static Hashtable<String, Integer> circularOffsets = new Hashtable();
    private static final Monitor CIRCULAR_OFFSETS_MONITOR = Monitor.newInstance();

    protected static final Iterator<InetSocketAddress> resolveInetSocketAddresses(String host, int port, OracleHostnameResolver hostnameResolver, Properties socketOptions, String protocol, String addr) throws UnknownHostException, NetException {
        InetSocketAddress[] resolvedSocketAddresses = null;
        if (!InetAddressResolver.isInetAddressResolutionRequired(addr, protocol, socketOptions)) {
            resolvedSocketAddresses = new InetSocketAddress[]{InetSocketAddress.createUnresolved(host, port)};
            return new InetSocketAddressIterator(resolvedSocketAddresses);
        }
        InetAddress[] resolvedAddresses = null;
        resolvedAddresses = hostnameResolver != null ? hostnameResolver.getAllByName(host) : InetAddress.getAllByName(host);
        boolean forceDNSLoadBalancing = Boolean.parseBoolean((String)socketOptions.get(18));
        if (forceDNSLoadBalancing && resolvedAddresses.length > 1) {
            resolvedAddresses = InetAddressResolver.getAddressesInCircularOrder(host, resolvedAddresses);
        }
        DownHostsCache.getInstance().reorderAddresses(resolvedAddresses, port);
        if (resolvedAddresses.length > 0) {
            resolvedSocketAddresses = new InetSocketAddress[resolvedAddresses.length];
            for (int i = 0; i < resolvedAddresses.length; ++i) {
                resolvedSocketAddresses[i] = new InetSocketAddress(resolvedAddresses[i], port);
            }
        }
        return new InetSocketAddressIterator(resolvedSocketAddresses);
    }

    private static boolean isInetAddressResolutionRequired(String addr, String protocol, Properties socketOptions) throws NetException {
        boolean socksProxy;
        boolean httpProxy;
        if (!(protocol.equalsIgnoreCase("tcp") || protocol.equalsIgnoreCase("tcps") || protocol.equalsIgnoreCase("wss"))) {
            return true;
        }
        boolean isRemoteDNS = Boolean.parseBoolean((String)socketOptions.getOrDefault((Object)39, "false"));
        NVNavigator nav = new NVNavigator();
        try {
            NVPair nvpAddr = new NVFactory().createNVPair(addr);
            httpProxy = nav.findNVPair(nvpAddr, "HTTPS_PROXY") != null && nav.findNVPair(nvpAddr, "HTTPS_PROXY") != null;
        }
        catch (NLException e) {
            throw new NetException(18951);
        }
        boolean bl = socksProxy = socketOptions.containsKey(36) && socketOptions.containsKey(37) || System.getProperty("socksProxyHost", null) != null;
        return !isRemoteDNS || !httpProxy && !socksProxy;
    }

    static final InetAddress[] getAddressesInCircularOrder(String hostname, InetAddress[] inetAddressesFromJVM) {
        try (Monitor.CloseableLock lock = CIRCULAR_OFFSETS_MONITOR.acquireCloseableLock();){
            InetAddress[] cachedAddresses = inetAddressesCache.get(hostname);
            Integer offset = circularOffsets.get(hostname);
            if (cachedAddresses == null || !InetAddressResolver.areEquals(cachedAddresses, inetAddressesFromJVM)) {
                offset = new Integer(0);
                cachedAddresses = inetAddressesFromJVM;
                inetAddressesCache.put(hostname, inetAddressesFromJVM);
                circularOffsets.put(hostname, offset);
            }
            InetAddress[] addrb = InetAddressResolver.getCopyAddresses(cachedAddresses, offset);
            circularOffsets.put(hostname, new Integer((offset + 1) % cachedAddresses.length));
            InetAddress[] inetAddressArray = addrb;
            return inetAddressArray;
        }
    }

    private static final boolean areEquals(InetAddress[] add1, InetAddress[] add2) {
        if (add1.length != add2.length) {
            return false;
        }
        for (int i = 0; i < add1.length; ++i) {
            if (add1[i].equals(add2[i])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] add, int nbOfRotation) {
        InetAddress[] addcp = new InetAddress[add.length];
        for (int i = 0; i < add.length; ++i) {
            addcp[i] = add[(i + nbOfRotation) % add.length];
        }
        return addcp;
    }

    private static final class InetSocketAddressIterator
    implements Iterator<InetSocketAddress> {
        private final InetSocketAddress[] socketAddresses;
        private int socketAddressIndex = 0;

        private InetSocketAddressIterator(InetSocketAddress[] socketAddresses) {
            this.socketAddresses = socketAddresses;
        }

        @Override
        public boolean hasNext() {
            return this.socketAddressIndex < this.socketAddresses.length;
        }

        @Override
        public InetSocketAddress next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.socketAddresses[this.socketAddressIndex++];
        }

        public String toString() {
            return "(" + this.socketAddressIndex + "/" + this.socketAddresses.length + ")";
        }
    }
}

