/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.CacheType;
import org.infinispan.configuration.parsing.Element;

public enum CacheMode {
    LOCAL,
    REPL_SYNC,
    REPL_ASYNC,
    INVALIDATION_SYNC,
    INVALIDATION_ASYNC,
    DIST_SYNC,
    DIST_ASYNC,
    SCATTERED_SYNC;

    private static final CacheMode[] cachedValues;

    public static CacheMode valueOf(int order) {
        return cachedValues[order];
    }

    public static CacheMode of(CacheType cacheType, boolean sync) {
        switch (cacheType) {
            case REPLICATION: {
                return sync ? REPL_SYNC : REPL_ASYNC;
            }
            case DISTRIBUTION: {
                return sync ? DIST_SYNC : DIST_ASYNC;
            }
            case INVALIDATION: {
                return sync ? INVALIDATION_SYNC : INVALIDATION_ASYNC;
            }
            case SCATTERED: {
                return SCATTERED_SYNC;
            }
        }
        return LOCAL;
    }

    public boolean isInvalidation() {
        return this == INVALIDATION_SYNC || this == INVALIDATION_ASYNC;
    }

    public boolean isSynchronous() {
        return this == REPL_SYNC || this == DIST_SYNC || this == INVALIDATION_SYNC || this == SCATTERED_SYNC || this == LOCAL;
    }

    public boolean isClustered() {
        return this != LOCAL;
    }

    public boolean isDistributed() {
        return this == DIST_SYNC || this == DIST_ASYNC;
    }

    public boolean isReplicated() {
        return this == REPL_SYNC || this == REPL_ASYNC;
    }

    @Deprecated
    public boolean isScattered() {
        return this == SCATTERED_SYNC;
    }

    public boolean needsStateTransfer() {
        return this.isReplicated() || this.isDistributed() || this.isScattered();
    }

    public CacheMode toSync() {
        switch (this) {
            case REPL_ASYNC: {
                return REPL_SYNC;
            }
            case INVALIDATION_ASYNC: {
                return INVALIDATION_SYNC;
            }
            case DIST_ASYNC: {
                return DIST_SYNC;
            }
        }
        return this;
    }

    public CacheMode toSync(boolean sync) {
        return sync ? this.toSync() : this.toAsync();
    }

    public CacheMode toAsync() {
        switch (this) {
            case REPL_SYNC: {
                return REPL_ASYNC;
            }
            case INVALIDATION_SYNC: {
                return INVALIDATION_ASYNC;
            }
            case DIST_SYNC: {
                return DIST_ASYNC;
            }
            case SCATTERED_SYNC: {
                throw new IllegalArgumentException("Scattered mode does not have asynchronous mode.");
            }
        }
        return this;
    }

    public String friendlyCacheModeString() {
        switch (this) {
            case REPL_ASYNC: 
            case REPL_SYNC: {
                return "REPLICATED";
            }
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                return "INVALIDATED";
            }
            case DIST_ASYNC: 
            case DIST_SYNC: {
                return "DISTRIBUTED";
            }
            case SCATTERED_SYNC: {
                return "SCATTERED";
            }
            case LOCAL: {
                return "LOCAL";
            }
        }
        throw new IllegalArgumentException("Unknown cache mode " + this);
    }

    public String toCacheType() {
        switch (this) {
            case DIST_ASYNC: 
            case DIST_SYNC: {
                return Element.DISTRIBUTED_CACHE.getLocalName();
            }
            case REPL_ASYNC: 
            case REPL_SYNC: {
                return Element.REPLICATED_CACHE.getLocalName();
            }
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                return Element.INVALIDATION_CACHE.getLocalName();
            }
            case SCATTERED_SYNC: {
                return Element.SCATTERED_CACHE.getLocalName();
            }
        }
        return Element.LOCAL_CACHE.getLocalName();
    }

    public Element toElement(boolean template) {
        switch (this) {
            case DIST_ASYNC: 
            case DIST_SYNC: {
                return template ? Element.DISTRIBUTED_CACHE_CONFIGURATION : Element.DISTRIBUTED_CACHE;
            }
            case REPL_ASYNC: 
            case REPL_SYNC: {
                return template ? Element.REPLICATED_CACHE_CONFIGURATION : Element.REPLICATED_CACHE;
            }
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                return template ? Element.INVALIDATION_CACHE_CONFIGURATION : Element.INVALIDATION_CACHE;
            }
            case SCATTERED_SYNC: {
                return template ? Element.SCATTERED_CACHE_CONFIGURATION : Element.SCATTERED_CACHE;
            }
        }
        return template ? Element.LOCAL_CACHE_CONFIGURATION : Element.LOCAL_CACHE;
    }

    public CacheType cacheType() {
        switch (this) {
            case DIST_ASYNC: 
            case DIST_SYNC: {
                return CacheType.DISTRIBUTION;
            }
            case REPL_ASYNC: 
            case REPL_SYNC: {
                return CacheType.REPLICATION;
            }
            case INVALIDATION_ASYNC: 
            case INVALIDATION_SYNC: {
                return CacheType.INVALIDATION;
            }
            case SCATTERED_SYNC: {
                return CacheType.SCATTERED;
            }
        }
        return CacheType.LOCAL;
    }

    static {
        cachedValues = CacheMode.values();
    }
}

