/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.exceptions.MissingBackpressureException;
import io.reactivex.rxjava3.functions.Cancellable;
import io.reactivex.rxjava3.internal.disposables.CancellableDisposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCreate<T>
extends Flowable<T> {
    final FlowableOnSubscribe<T> source;
    final BackpressureStrategy backpressure;

    public FlowableCreate(FlowableOnSubscribe<T> source, BackpressureStrategy backpressure) {
        this.source = source;
        this.backpressure = backpressure;
    }

    public void subscribeActual(Subscriber<? super T> t) {
        BaseEmitter emitter;
        switch (this.backpressure) {
            case MISSING: {
                emitter = new MissingEmitter<T>(t, this.source);
                break;
            }
            case ERROR: {
                emitter = new ErrorAsyncEmitter<T>(t, this.source);
                break;
            }
            case DROP: {
                emitter = new DropAsyncEmitter<T>(t, this.source);
                break;
            }
            case LATEST: {
                emitter = new LatestAsyncEmitter<T>(t, this.source);
                break;
            }
            default: {
                emitter = new BufferAsyncEmitter<T>(t, this.source, FlowableCreate.bufferSize());
            }
        }
        t.onSubscribe(emitter);
    }

    static final class MissingEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 3776720187248809713L;

        MissingEmitter(Subscriber<? super T> downstream, FlowableOnSubscribe<T> source) {
            super(downstream, source);
        }

        public void onNext(T t) {
            long r;
            if (this.isCancelled()) {
                return;
            }
            if (t != null) {
                this.downstream.onNext(t);
            } else {
                this.onError(ExceptionHelper.createNullPointerException((String)"onNext called with a null value."));
                return;
            }
            while ((r = this.get()) != 0L && !this.compareAndSet(r, r - 1L)) {
            }
        }
    }

    static final class ErrorAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 338953216916120960L;

        ErrorAsyncEmitter(Subscriber<? super T> downstream, FlowableOnSubscribe<T> source) {
            super(downstream, source);
        }

        @Override
        void onOverflow() {
            this.onError((Throwable)new MissingBackpressureException("create: could not emit value due to lack of requests"));
        }
    }

    static final class DropAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 8360058422307496563L;

        DropAsyncEmitter(Subscriber<? super T> downstream, FlowableOnSubscribe<T> source) {
            super(downstream, source);
        }

        @Override
        void onOverflow() {
        }
    }

    static final class LatestAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4023437720691792495L;
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip = new AtomicInteger();

        LatestAsyncEmitter(Subscriber<? super T> downstream, FlowableOnSubscribe<T> source) {
            super(downstream, source);
        }

        public void onNext(T t) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t == null) {
                this.onError(ExceptionHelper.createNullPointerException((String)"onNext called with a null value."));
                return;
            }
            this.queue.set(t);
            this.drain();
        }

        @Override
        public boolean signalError(Throwable e) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            this.error = e;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.downstream;
            AtomicReference<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced((AtomicLong)this, (long)e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BufferAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 2427151001689639875L;
        final SpscLinkedArrayQueue<T> queue;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        BufferAsyncEmitter(Subscriber<? super T> actual, FlowableOnSubscribe<T> source, int capacityHint) {
            super(actual, source);
            this.queue = new SpscLinkedArrayQueue(capacityHint);
            this.wip = new AtomicInteger();
        }

        public void onNext(T t) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t == null) {
                this.onError(ExceptionHelper.createNullPointerException((String)"onNext called with a null value."));
                return;
            }
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public boolean signalError(Throwable e) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            this.error = e;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.downstream;
            SpscLinkedArrayQueue<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    Object o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.errorDownstream(ex);
                        } else {
                            this.completeDownstream();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced((AtomicLong)this, (long)e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static abstract class NoOverflowBaseAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4127754106204442833L;

        NoOverflowBaseAsyncEmitter(Subscriber<? super T> downstream, FlowableOnSubscribe<T> source) {
            super(downstream, source);
        }

        public final void onNext(T t) {
            if (this.isCancelled()) {
                return;
            }
            if (t == null) {
                this.onError(ExceptionHelper.createNullPointerException((String)"onNext called with a null value."));
                return;
            }
            if (this.get() != 0L) {
                this.downstream.onNext(t);
                BackpressureHelper.produced((AtomicLong)this, (long)1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static abstract class BaseEmitter<T>
    extends AtomicLong
    implements FlowableEmitter<T>,
    Subscription {
        private static final long serialVersionUID = 7326289992464377023L;
        final Subscriber<? super T> downstream;
        final FlowableOnSubscribe<T> source;
        final SequentialDisposable serial;
        final AtomicInteger sip;

        BaseEmitter(Subscriber<? super T> downstream, FlowableOnSubscribe<T> source) {
            this.downstream = downstream;
            this.source = source;
            this.serial = new SequentialDisposable();
            this.sip = new AtomicInteger();
        }

        public void onComplete() {
            this.completeDownstream();
        }

        protected void completeDownstream() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.downstream.onComplete();
            }
            finally {
                this.serial.dispose();
            }
        }

        public final void onError(Throwable e) {
            if (e == null) {
                e = ExceptionHelper.createNullPointerException((String)"onError called with a null Throwable.");
            }
            if (!this.signalError(e)) {
                RxJavaPlugins.onError((Throwable)e);
            }
        }

        public final boolean tryOnError(Throwable e) {
            if (e == null) {
                e = ExceptionHelper.createNullPointerException((String)"tryOnError called with a null Throwable.");
            }
            return this.signalError(e);
        }

        public boolean signalError(Throwable e) {
            return this.errorDownstream(e);
        }

        protected boolean errorDownstream(Throwable e) {
            if (this.isCancelled()) {
                return false;
            }
            try {
                this.downstream.onError(e);
            }
            finally {
                this.serial.dispose();
            }
            return true;
        }

        public final void cancel() {
            this.serial.dispose();
            this.onUnsubscribed();
        }

        public final void attemptSubscribe() {
            block3: {
                if (this.sip.getAndIncrement() != 0) break block3;
                int missed = 1;
                do {
                    if (this.get() <= 0L) continue;
                    try {
                        this.source.subscribe((FlowableEmitter)this);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal((Throwable)ex);
                        this.onError(ex);
                    }
                } while ((missed = this.sip.addAndGet(-missed)) != 0 && !this.serial.isDisposed());
            }
        }

        void onUnsubscribed() {
        }

        public final boolean isCancelled() {
            return this.serial.isDisposed();
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate((long)n) && !this.serial.isDisposed()) {
                BackpressureHelper.add((AtomicLong)this, (long)n);
                this.attemptSubscribe();
                this.onRequested();
            }
        }

        void onRequested() {
        }

        public final void setDisposable(Disposable d) {
            this.serial.update(d);
        }

        public final void setCancellable(Cancellable c) {
            this.setDisposable((Disposable)new CancellableDisposable(c));
        }

        public final long requested() {
            return this.get();
        }

        public final FlowableEmitter<T> serialize() {
            return new SerializedEmitter(this);
        }

        @Override
        public String toString() {
            return String.format("%s{%s}", this.getClass().getSimpleName(), super.toString());
        }
    }

    static final class SerializedEmitter<T>
    extends AtomicInteger
    implements FlowableEmitter<T> {
        private static final long serialVersionUID = 4883307006032401862L;
        final BaseEmitter<T> emitter;
        final AtomicThrowable errors;
        final SimplePlainQueue<T> queue;
        volatile boolean done;

        SerializedEmitter(BaseEmitter<T> emitter) {
            this.emitter = emitter;
            this.errors = new AtomicThrowable();
            this.queue = new SpscLinkedArrayQueue(16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            if (t == null) {
                this.onError(ExceptionHelper.createNullPointerException((String)"onNext called with a null value."));
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.emitter.onNext(t);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q;
                SimplePlainQueue<T> simplePlainQueue = q = this.queue;
                synchronized (simplePlainQueue) {
                    q.offer(t);
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        public void onError(Throwable t) {
            if (!this.tryOnError(t)) {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public boolean tryOnError(Throwable t) {
            if (this.emitter.isCancelled() || this.done) {
                return false;
            }
            if (t == null) {
                t = ExceptionHelper.createNullPointerException((String)"onError called with a null Throwable.");
            }
            if (this.errors.tryAddThrowable(t)) {
                this.done = true;
                this.drain();
                return true;
            }
            return false;
        }

        public void onComplete() {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseEmitter<T> e = this.emitter;
            SimplePlainQueue<T> q = this.queue;
            AtomicThrowable errors = this.errors;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e.isCancelled()) {
                    q.clear();
                    return;
                }
                if (errors.get() != null) {
                    q.clear();
                    errors.tryTerminateConsumer(e);
                    return;
                }
                boolean d = this.done;
                Object v = q.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    e.onComplete();
                    return;
                }
                if (!empty) {
                    e.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        public void setDisposable(Disposable d) {
            this.emitter.setDisposable(d);
        }

        public void setCancellable(Cancellable c) {
            this.emitter.setCancellable(c);
        }

        public long requested() {
            return this.emitter.requested();
        }

        public boolean isCancelled() {
            return this.emitter.isCancelled();
        }

        public FlowableEmitter<T> serialize() {
            return this;
        }

        @Override
        public String toString() {
            return this.emitter.toString();
        }
    }
}

