/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.web.sstore;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.ext.web.Session;

@MutinyGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public SessionStore(Object delegate) {
        this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
    }

    SessionStore() {
        this.delegate = null;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionStore that = (SessionStore)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static SessionStore create(io.vertx.mutiny.core.Vertx vertx) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static SessionStore create(io.vertx.mutiny.core.Vertx vertx, JsonObject options) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate(), (JsonObject)options));
        return ret;
    }

    @Fluent
    public SessionStore init(io.vertx.mutiny.core.Vertx vertx, JsonObject options) {
        this.delegate.init(vertx.getDelegate(), options);
        return this;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    @CheckReturnValue
    public Uni<Session> get(String cookieValue) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.get(cookieValue, (Handler)new DelegatingHandler(resultHandler, ar -> ar.map(event -> Session.newInstance(event)))));
    }

    public Session getAndAwait(String cookieValue) {
        return (Session)this.get(cookieValue).await().indefinitely();
    }

    @Fluent
    public SessionStore getAndForget(String cookieValue) {
        this.get(cookieValue).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> delete(String id) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.delete(id, resultHandler));
    }

    public Void deleteAndAwait(String id) {
        return (Void)this.delete(id).await().indefinitely();
    }

    @Fluent
    public SessionStore deleteAndForget(String id) {
        this.delete(id).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> put(Session session) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.put(session.getDelegate(), resultHandler));
    }

    public Void putAndAwait(Session session) {
        return (Void)this.put(session).await().indefinitely();
    }

    @Fluent
    public SessionStore putAndForget(Session session) {
        this.put(session).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> clear() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.clear(resultHandler));
    }

    public Void clearAndAwait() {
        return (Void)this.clear().await().indefinitely();
    }

    @Fluent
    public SessionStore clearAndForget() {
        this.clear().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Integer> size() {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.size(resultHandler));
    }

    public Integer sizeAndAwait() {
        return (Integer)this.size().await().indefinitely();
    }

    @Fluent
    public SessionStore sizeAndForget() {
        this.size().subscribe().with(UniHelper.NOOP);
        return this;
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

