/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.forms;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.AuthenticationFlowException;
import org.keycloak.authentication.FormAction;
import org.keycloak.authentication.FormActionFactory;
import org.keycloak.authentication.FormContext;
import org.keycloak.authentication.ValidationContext;
import org.keycloak.events.EventType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.userprofile.ValidationException;

public class RegistrationUserCreation
implements FormAction,
FormActionFactory {
    public static final String PROVIDER_ID = "registration-user-creation";
    private static AuthenticationExecutionModel.Requirement[] REQUIREMENT_CHOICES = new AuthenticationExecutionModel.Requirement[]{AuthenticationExecutionModel.Requirement.REQUIRED, AuthenticationExecutionModel.Requirement.DISABLED};

    public String getHelpText() {
        return "This action must always be first! Validates the username of the user in validation phase.  In success phase, this will create the user in the database.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return null;
    }

    public void validate(ValidationContext context) {
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        context.getEvent().detail("register_method", "form");
        KeycloakSession session = context.getSession();
        UserProfileProvider profileProvider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.REGISTRATION_USER_CREATION, (Map)formData);
        String email = profile.getAttributes().getFirstValue("email");
        String username = profile.getAttributes().getFirstValue("username");
        String firstName = profile.getAttributes().getFirstValue("firstName");
        String lastName = profile.getAttributes().getFirstValue("lastName");
        context.getEvent().detail("email", email);
        context.getEvent().detail("username", username);
        context.getEvent().detail("first_name", firstName);
        context.getEvent().detail("last_name", lastName);
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            context.getEvent().detail("username", email);
        }
        try {
            profile.validate();
        }
        catch (ValidationException pve) {
            List<FormMessage> errors = Validation.getFormErrorsFromValidation(pve.getErrors());
            if (pve.hasError(new String[]{"emailExistsMessage"})) {
                context.error("email_in_use");
            } else if (pve.hasError(new String[]{"missingEmailMessage", "missingUsernameMessage", "invalidEmailMessage"})) {
                context.error("invalid_registration");
            } else if (pve.hasError(new String[]{"usernameExistsMessage"})) {
                context.error("username_in_use");
            }
            context.validationError(formData, errors);
            return;
        }
        context.success();
    }

    public void buildPage(FormContext context, LoginFormsProvider form) {
        this.checkNotOtherUserAuthenticating(context);
    }

    public void success(FormContext context) {
        this.checkNotOtherUserAuthenticating(context);
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        String email = (String)formData.getFirst((Object)"email");
        String username = (String)formData.getFirst((Object)"username");
        if (context.getRealm().isRegistrationEmailAsUsername()) {
            username = email;
        }
        context.getEvent().detail("username", username).detail("register_method", "form").detail("email", email);
        KeycloakSession session = context.getSession();
        UserProfileProvider profileProvider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UserProfile profile = profileProvider.create(UserProfileContext.REGISTRATION_USER_CREATION, (Map)formData);
        UserModel user = profile.create();
        user.setEnabled(true);
        context.setUser(user);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        context.getEvent().user(user);
        context.getEvent().success();
        context.newEvent().event(EventType.LOGIN);
        context.getEvent().client(context.getAuthenticationSession().getClient().getClientId()).detail("redirect_uri", context.getAuthenticationSession().getRedirectUri()).detail("auth_method", context.getAuthenticationSession().getProtocol());
        String authType = context.getAuthenticationSession().getAuthNote("auth_type");
        if (authType != null) {
            context.getEvent().detail("auth_type", authType);
        }
    }

    private void checkNotOtherUserAuthenticating(FormContext context) {
        if (context.getUser() != null) {
            context.getEvent().detail("previous_user", context.getUser().getUsername());
            throw new AuthenticationFlowException(AuthenticationFlowError.GENERIC_AUTHENTICATION_ERROR, "different_user_authenticating", "expiredActionMessage");
        }
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void close() {
    }

    public String getDisplayType() {
        return "Registration User Creation";
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return false;
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public FormAction create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

