/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import jakarta.ws.rs.core.UriInfo;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionManager;

public class UserConsentManager {
    public static boolean revokeConsentToClient(KeycloakSession session, ClientModel client, UserModel user) {
        RealmModel realm = session.getContext().getRealm();
        boolean revokedConsent = session.users().revokeConsentForClient(realm, user.getId(), client.getId());
        boolean revokedOfflineToken = new UserSessionManager(session).revokeOfflineToken(user, client);
        if (revokedConsent) {
            AuthenticationManager.backchannelLogoutUserFromClient(session, realm, user, client, (UriInfo)session.getContext().getUri(), session.getContext().getRequestHeaders());
        }
        return revokedConsent || revokedOfflineToken;
    }
}

