/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.export;

import io.micrometer.core.instrument.config.MeterRegistryConfig;
import io.micrometer.core.instrument.config.validate.InvalidReason;
import io.micrometer.core.instrument.config.validate.Validated;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.jboss.logging.Logger;

public class ConfigAdapter {
    private static final Logger log = Logger.getLogger(ConfigAdapter.class);
    static final String ROOT = "quarkus.micrometer.export.";
    static final int TRIM_POS = "quarkus.micrometer.export.".length();

    private ConfigAdapter() {
    }

    public static Map<String, String> captureProperties(Config config, String prefix) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String name : config.getPropertyNames()) {
            if (!name.startsWith(prefix)) continue;
            String key = ConfigAdapter.convertKey(name);
            String value = (String)config.getValue(name, String.class);
            properties.put(key, value);
        }
        return properties;
    }

    public static Map<String, String> captureProperties(Map<String, String> config, String prefix) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = prefix + ConfigAdapter.camelHumpify(entry.getKey());
            properties.put(key, entry.getValue());
        }
        return properties;
    }

    public static <T extends MeterRegistryConfig> T validate(T config) {
        return ConfigAdapter.validate(config, config.validate());
    }

    public static <T extends MeterRegistryConfig> T validate(T config, Validated validated) {
        List errors = validated.failures();
        if (validated.isInvalid()) {
            errors.stream().forEach(x -> {
                String name = ConfigAdapter.revertKey(x.getProperty());
                if (x.getReason() == InvalidReason.MISSING) {
                    log.errorf("%s is required", (Object)name);
                } else {
                    log.errorf(x.getException(), "%s is malformed", (Object)name);
                }
            });
        }
        return config;
    }

    static String convertKey(String name) {
        String key = name.substring(TRIM_POS);
        return ConfigAdapter.camelHumpify(key);
    }

    static String revertKey(String name) {
        return ROOT + ConfigAdapter.dashify(name);
    }

    static String camelHumpify(String s) {
        if (s.indexOf(45) >= 0) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == '-') {
                    if (++i >= s.length()) continue;
                    b.append(Character.toUpperCase(s.charAt(i)));
                    continue;
                }
                b.append(s.charAt(i));
            }
            return b.toString();
        }
        return s;
    }

    static String dashify(String s) {
        StringBuilder ret = new StringBuilder();
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && i != chars.length - 1 && c >= 'A' && c <= 'Z') {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(c));
        }
        return ret.toString();
    }
}

