/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.notificators;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.traccar.database.StatisticsManager;
import org.traccar.model.Event;
import org.traccar.model.Notification;
import org.traccar.model.Position;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificationFormatter;
import org.traccar.notification.NotificationMessage;
import org.traccar.notificators.Notificator;
import org.traccar.sms.SmsManager;

@Singleton
public class NotificatorSms
implements Notificator {
    private final SmsManager smsManager;
    private final NotificationFormatter notificationFormatter;
    private final StatisticsManager statisticsManager;

    @Inject
    public NotificatorSms(SmsManager smsManager, NotificationFormatter notificationFormatter, StatisticsManager statisticsManager) {
        this.smsManager = smsManager;
        this.notificationFormatter = notificationFormatter;
        this.statisticsManager = statisticsManager;
    }

    @Override
    public void send(Notification notification, User user, Event event, Position position) throws MessageException {
        if (user.getPhone() != null) {
            NotificationMessage shortMessage = this.notificationFormatter.formatMessage(user, event, position, "short");
            this.statisticsManager.registerSms();
            this.smsManager.sendMessage(user.getPhone(), shortMessage.getBody(), false);
        }
    }
}

