/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.pattern;

import org.jparsec.Parser;
import org.jparsec.Scanners;
import org.jparsec.internal.util.Checks;
import org.jparsec.pattern.LowerBoundedPattern;
import org.jparsec.pattern.ManyPattern;
import org.jparsec.pattern.NotPattern;
import org.jparsec.pattern.OptionalPattern;
import org.jparsec.pattern.OrPattern;
import org.jparsec.pattern.PeekPattern;
import org.jparsec.pattern.RepeatPattern;
import org.jparsec.pattern.SequencePattern;
import org.jparsec.pattern.UpperBoundedPattern;

public abstract class Pattern {
    public static final int MISMATCH = -1;

    public abstract int match(CharSequence var1, int var2, int var3);

    public final Pattern next(Pattern next) {
        return new SequencePattern(this, next);
    }

    public final Pattern optional() {
        return new OptionalPattern(this);
    }

    public final Pattern many() {
        return new ManyPattern(this);
    }

    @Deprecated
    public final Pattern many(int min) {
        return this.atLeast(min);
    }

    public final Pattern atLeast(int min) {
        return new LowerBoundedPattern(Checks.checkMin(min), this);
    }

    public final Pattern many1() {
        return this.atLeast(1);
    }

    @Deprecated
    public final Pattern some(int max) {
        return this.atMost(max);
    }

    public final Pattern atMost(int max) {
        return new UpperBoundedPattern(Checks.checkMax(max), this);
    }

    @Deprecated
    public final Pattern some(int min, int max) {
        return this.times(min, max);
    }

    public final Pattern times(int min, int max) {
        return Pattern.times(this, min, max);
    }

    public final Pattern not() {
        return new NotPattern(this);
    }

    public final Pattern peek() {
        return new PeekPattern(this);
    }

    public final Pattern ifelse(Pattern consequence, Pattern alternative) {
        return Pattern.ifElse(this, consequence, alternative);
    }

    @Deprecated
    public final Pattern repeat(int n) {
        return this.times(n);
    }

    public final Pattern times(int n) {
        return new RepeatPattern(Checks.checkNonNegative(n, "n < 0"), this);
    }

    public final Pattern or(Pattern p2) {
        return new OrPattern(this, p2);
    }

    public final Parser<Void> toScanner(String name) {
        return Scanners.pattern(this, name);
    }

    private static Pattern ifElse(final Pattern cond, final Pattern consequence, final Pattern alternative) {
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int conditionResult = cond.match(src, begin, end);
                if (conditionResult == -1) {
                    return alternative.match(src, begin, end);
                }
                int consequenceResult = consequence.match(src, begin + conditionResult, end);
                if (consequenceResult == -1) {
                    return -1;
                }
                return conditionResult + consequenceResult;
            }
        };
    }

    private static Pattern times(final Pattern pp, final int min, final int max) {
        Checks.checkMinMax(min, max);
        return new Pattern(){

            @Override
            public int match(CharSequence src, int begin, int end) {
                int minLen = RepeatPattern.matchRepeat(min, pp, src, end, begin, 0);
                if (-1 == minLen) {
                    return -1;
                }
                return UpperBoundedPattern.matchSome(max - min, pp, src, end, begin + minLen, minLen);
            }
        };
    }
}

