let
  fromEnv = var: def:
    let val = builtins.getEnv var; in
    if val != "" then val else def;
in rec {
  shell = "/usr/local/bin/bash";
  coreutils = "/bin:/usr/bin";
  bzip2 = "/usr/local/bin/bzip2";
  gzip = "/usr/bin/gzip";
  xz = "/usr/local/bin/xz";
  tar = "/bin/tar";
  tarFlags = "";
  tr = "/usr/bin/tr";
  nixBinDir = fromEnv "NIX_BIN_DIR" "/usr/local/bin";
  nixPrefix = "/usr/local";
  nixLibexecDir = fromEnv "NIX_LIBEXEC_DIR" "/usr/local/libexec";
  nixLocalstateDir = "/var";
  nixSysconfDir = "/etc";
  nixStoreDir = fromEnv "NIX_STORE_DIR" "/nix/store";

  # If Nix is installed in the Nix store, then automatically add it as
  # a dependency to the core packages. This ensures that they work
  # properly in a chroot.
  chrootDeps =
    if dirOf nixPrefix == builtins.storeDir then
      [ (builtins.storePath nixPrefix) ]
    else
      [ ];
}
