"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.resetAllMocks = exports.ApmConfigurationMock = exports.applyConfigOverridesMock = exports.getConfigFromFilesMock = exports.getConfigurationFilePathsMock = void 0;
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
exports.getConfigurationFilePathsMock = jest.fn();
jest.doMock('./utils/get_config_file_paths', () => ({
    getConfigurationFilePaths: exports.getConfigurationFilePathsMock,
}));
exports.getConfigFromFilesMock = jest.fn();
jest.doMock('./utils/read_config', () => ({
    getConfigFromFiles: exports.getConfigFromFilesMock,
}));
exports.applyConfigOverridesMock = jest.fn();
jest.doMock('./utils/apply_config_overrides', () => ({
    applyConfigOverrides: exports.applyConfigOverridesMock,
}));
exports.ApmConfigurationMock = jest.fn();
jest.doMock('./config', () => ({
    ApmConfiguration: exports.ApmConfigurationMock,
}));
exports.resetAllMocks = () => {
    exports.getConfigurationFilePathsMock.mockReset();
    exports.getConfigFromFilesMock.mockReset();
    exports.applyConfigOverridesMock.mockReset();
    exports.ApmConfigurationMock.mockReset();
};
