"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _constants = require("../utils/constants");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class FindingsService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "getFindings", async (context, request, response) => {
      try {
        const {
          detectorType,
          detectorId,
          sortOrder,
          size
        } = request.query;
        const defaultParams = {
          sortOrder,
          size
        };
        let params;

        if (detectorId) {
          params = { ...defaultParams,
            detectorId
          };
        } else if (detectorType) {
          params = { ...defaultParams,
            detectorType
          };
        } else {
          throw Error(`Invalid request params: detectorId or detectorType must be specified`);
        }

        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const getFindingsResponse = await callWithRequest(_constants.CLIENT_DETECTOR_METHODS.GET_FINDINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFindingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FindingsService - getFindings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });

    this.osDriver = osDriver;
  }
  /**
   * Calls backend GET Findings API.
   */


}

exports.default = FindingsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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