"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPplRoute = registerPplRoute;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerPplRoute({
  router,
  facet
}) {
  router.post({
    path: `${_shared.PPL_BASE}${_shared.PPL_SEARCH}`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        format: _configSchema.schema.string()
      })
    }
  }, async (context, req, res) => {
    const queryRes = await facet.describeQuery(req);

    if (queryRes['success']) {
      const result = {
        body: { ...queryRes['data']
        }
      };
      return res.ok(result);
    }

    return res.custom({
      statusCode: queryRes.data.statusCode || queryRes.data.status || 500,
      body: queryRes.data.body || queryRes.data.message || ''
    });
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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