"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Subject = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
class Subject {
  constructor(value) {
    _defineProperty(this, "callbacks", new Set());

    _defineProperty(this, "value", void 0);

    this.value = value;
  }

  subscribe(fn) {
    this.callbacks.add(fn);
    /**
     * We immediately call the function inside the subscribe so the consumer
     * receives the value immediately, withouth the need to wait for a change.
     */

    fn(this.value);

    const unsubscribe = () => this.callbacks.delete(fn);

    return {
      unsubscribe
    };
  }

  next(value) {
    if (value !== this.value) {
      this.value = value;
      this.callbacks.forEach(fn => fn(value));
    }
  }

}

exports.Subject = Subject;