/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import java.math.BigDecimal;
import javax.swing.table.AbstractTableModel;

public class FreqValueCountTableModel
extends AbstractTableModel {
    private ColumnProfileResult profile;
    private static final String COUNT = "COUNT";
    private static final String VALUE = "VALUE";
    private static final String PERCENT = "PERCENT";

    public FreqValueCountTableModel(ColumnProfileResult profile) {
        this.profile = profile;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return COUNT;
        }
        if (column == 1) {
            return PERCENT;
        }
        if (column == 2) {
            return VALUE;
        }
        throw new IllegalStateException("Unknown Column Index:" + column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        if (column == 0) {
            return Integer.class;
        }
        if (column == 1) {
            return BigDecimal.class;
        }
        if (column == 2) {
            for (ColumnValueCount cvc : this.profile.getValueCount()) {
                if (cvc.getValue() == null) continue;
                return cvc.getValue().getClass();
            }
            return Object.class;
        }
        throw new IllegalStateException("Unknown Column Index:" + column);
    }

    @Override
    public int getRowCount() {
        return this.profile == null ? 0 : this.profile.getValueCount().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.profile == null) {
            return null;
        }
        if (columnIndex == 0) {
            return this.profile.getValueCount().get(rowIndex).getCount();
        }
        if (columnIndex == 1) {
            return this.profile.getValueCount().get(rowIndex).getPercent();
        }
        if (columnIndex == 2) {
            return this.profile.getValueCount().get(rowIndex).getValue();
        }
        throw new IllegalStateException("Unknown Column Index:" + columnIndex);
    }
}

