/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.JobEntryLoader;
import org.pentaho.di.trans.StepLoader;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.SlaveServerConfig;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebServer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Carte {
    private WebServer webServer;
    private SlaveServerConfig config;

    public Carte(SlaveServerConfig config) throws Exception {
        this.config = config;
        boolean allOK = true;
        TransformationMap transformationMap = new TransformationMap();
        JobMap jobMap = new JobMap();
        ArrayList<SlaveServerDetection> detections = new ArrayList<SlaveServerDetection>();
        SocketRepository socketRepository = new SocketRepository();
        Trans trans = Carte.generateTestTransformation();
        transformationMap.addTransformation(trans.getName(), trans, new TransConfiguration(trans.getTransMeta(), new TransExecutionConfiguration()));
        SlaveServer slaveServer = config.getSlaveServer();
        String hostname = slaveServer.getHostname();
        int port = 80;
        if (!Const.isEmpty((String)slaveServer.getPort())) {
            try {
                port = Integer.parseInt(slaveServer.getPort());
            }
            catch (Exception e) {
                LogWriter.getInstance().logError("Carte", Messages.getString("Carte.Error.CanNotPartPort", slaveServer.getHostname(), "" + port), (Throwable)e);
                allOK = false;
            }
        }
        if (config.isReportingToMasters()) {
            SlaveServer client = new SlaveServer("Dynamic slave [" + hostname + ":" + port + "]", hostname, "" + port, slaveServer.getUsername(), slaveServer.getPassword());
            for (SlaveServer master : config.getMasters()) {
                try {
                    SlaveServerDetection slaveServerDetection = new SlaveServerDetection(client);
                    master.sendXML(slaveServerDetection.getXML(), "/kettle/registerSlave/");
                    LogWriter.getInstance().logBasic("Carte", "Registered this slave server to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]", new Object[0]);
                }
                catch (Exception e) {
                    LogWriter.getInstance().logError("Carte", "Unable to register to master slave server [" + master.toString() + "] on address [" + master.getServerAndPort() + "]", new Object[0]);
                    allOK = false;
                }
            }
        }
        if (allOK) {
            this.webServer = new WebServer(transformationMap, jobMap, socketRepository, detections, hostname, port, config.isJoining());
        }
    }

    public static void main(String[] args) throws Exception {
        SlaveServerConfig config = null;
        if (args.length == 1 && !Const.isEmpty((String)args[0])) {
            FileObject file = KettleVFS.getFileObject((String)args[0]);
            Document document = XMLHandler.loadXMLFile((FileObject)file);
            Node configNode = XMLHandler.getSubNode((Node)document, (String)"slave_config");
            config = new SlaveServerConfig(configNode);
        }
        if (args.length == 2 && !Const.isEmpty((String)args[0]) && !Const.isEmpty((String)args[1])) {
            String hostname = args[0];
            String port = args[1];
            SlaveServer slaveServer = new SlaveServer(hostname + ":" + port, hostname, port, null, null);
            config = new SlaveServerConfig();
            config.setSlaveServer(slaveServer);
        }
        if (config == null) {
            System.err.println(Messages.getString("Carte.Usage.Text"));
            System.err.println();
            System.err.println(Messages.getString("Carte.Usage.Example") + ": Carte 127.0.0.1 8080");
            System.err.println(Messages.getString("Carte.Usage.Example") + ": Carte 192.168.1.221 8081");
            System.err.println();
            System.err.println(Messages.getString("Carte.Usage.Example") + ": Carte /foo/bar/carte-config.xml");
            System.err.println(Messages.getString("Carte.Usage.Example") + ": Carte http://www.example.com/carte-config.xml");
            System.exit(1);
        }
        Carte.runCarte(config);
    }

    public static void runCarte(SlaveServerConfig config) throws Exception {
        Carte.init();
        config.setJoining(true);
        new Carte(config);
    }

    private static void init() throws Exception {
        EnvUtil.environmentInit();
        JndiUtil.initJNDI();
        LogWriter.getInstance((int)3);
        try {
            StepLoader.init();
        }
        catch (KettleException e) {
            throw new Exception(Messages.getString("Carte.Error.UnableLoadSteps"), e);
        }
        try {
            JobEntryLoader.init();
        }
        catch (KettleException e) {
            throw new Exception(Messages.getString("Carte.Error.UnableLoadJobEntries"), e);
        }
    }

    public static Trans generateTestTransformation() {
        RowGeneratorMeta A = new RowGeneratorMeta();
        A.allocate(3);
        A.setRowLimit("100000000");
        A.getFieldName()[0] = "ID";
        A.getFieldType()[0] = ValueMeta.getTypeDesc((int)5);
        A.getFieldLength()[0] = 7;
        A.getValue()[0] = "1234";
        A.getFieldName()[1] = "Name";
        A.getFieldType()[1] = ValueMeta.getTypeDesc((int)2);
        A.getFieldLength()[1] = 35;
        A.getValue()[1] = "Some name";
        A.getFieldName()[2] = "Last updated";
        A.getFieldType()[2] = ValueMeta.getTypeDesc((int)3);
        A.getFieldFormat()[2] = "yyyy/MM/dd";
        A.getValue()[2] = "2006/11/13";
        TransMeta transMeta = TransPreviewFactory.generatePreviewTransformation(null, A, "A");
        transMeta.setName("Row generator test");
        transMeta.setSizeRowset(2500);
        transMeta.setFeedbackSize(50000);
        transMeta.setUsingThreadPriorityManagment(false);
        return new Trans(transMeta);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    public SlaveServerConfig getConfig() {
        return this.config;
    }

    public void setConfig(SlaveServerConfig config) {
        this.config = config;
    }
}

