/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NewCookie;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.RuntimeDelegateDecorator;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.AcceptableLanguageTag;
import org.glassfish.jersey.message.internal.AcceptableMediaType;
import org.glassfish.jersey.message.internal.CommittingOutputStream;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.HttpHeaderReader;
import org.glassfish.jersey.message.internal.LanguageTag;
import org.glassfish.jersey.message.internal.LinkProvider;
import org.glassfish.jersey.message.internal.MediaTypes;

public class OutboundMessageContext {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final List<MediaType> WILDCARD_ACCEPTABLE_TYPE_SINGLETON_LIST = Collections.singletonList(MediaTypes.WILDCARD_ACCEPTABLE_TYPE);
    private final MultivaluedMap<String, Object> headers;
    private final CommittingOutputStream committingOutputStream;
    private Configuration configuration;
    private Object entity;
    private GenericType<?> entityType;
    private Annotation[] entityAnnotations = EMPTY_ANNOTATIONS;
    private OutputStream entityStream;

    public OutboundMessageContext(Configuration configuration) {
        this.configuration = configuration;
        this.headers = HeaderUtils.createOutbound();
        this.committingOutputStream = new CommittingOutputStream();
        this.entityStream = this.committingOutputStream;
    }

    public OutboundMessageContext(OutboundMessageContext original) {
        this.headers = HeaderUtils.createOutbound();
        this.headers.putAll(original.headers);
        this.committingOutputStream = new CommittingOutputStream();
        this.entityStream = this.committingOutputStream;
        this.entity = original.entity;
        this.entityType = original.entityType;
        this.entityAnnotations = original.entityAnnotations;
        this.configuration = original.configuration;
    }

    @Deprecated
    public OutboundMessageContext() {
        this((Configuration)null);
    }

    public void replaceHeaders(MultivaluedMap<String, Object> headers) {
        this.getHeaders().clear();
        if (headers != null) {
            this.getHeaders().putAll(headers);
        }
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return HeaderUtils.asStringHeaders(this.headers, this.configuration);
    }

    public String getHeaderString(String name) {
        return HeaderUtils.asHeaderString((List)this.headers.get(name), RuntimeDelegateDecorator.configured(this.configuration));
    }

    private <T> T singleHeader(String name, Class<T> valueType, Function<String, T> converter, boolean convertNull) {
        List values2 = (List)this.headers.get(name);
        if (values2 == null || values2.isEmpty()) {
            return convertNull ? (T)converter.apply(null) : null;
        }
        if (values2.size() > 1) {
            throw new HeaderValueException(LocalizationMessages.TOO_MANY_HEADER_VALUES(name, values2.toString()), HeaderValueException.Context.OUTBOUND);
        }
        Object value2 = values2.get(0);
        if (value2 == null) {
            return convertNull ? (T)converter.apply(null) : null;
        }
        if (valueType.isInstance(value2)) {
            return valueType.cast(value2);
        }
        try {
            return converter.apply(HeaderUtils.asString(value2, null));
        }
        catch (ProcessingException ex) {
            throw OutboundMessageContext.exception(name, value2, ex);
        }
    }

    private static HeaderValueException exception(String headerName, Object headerValue, Exception e) {
        return new HeaderValueException(LocalizationMessages.UNABLE_TO_PARSE_HEADER_VALUE(headerName, headerValue), e, HeaderValueException.Context.OUTBOUND);
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    public Date getDate() {
        return this.singleHeader("Date", Date.class, input -> {
            try {
                return HttpHeaderReader.readDate(input);
            }
            catch (ParseException e) {
                throw new ProcessingException(e);
            }
        }, false);
    }

    public Locale getLanguage() {
        return this.singleHeader("Content-Language", Locale.class, input -> {
            try {
                return new LanguageTag((String)input).getAsLocale();
            }
            catch (ParseException e) {
                throw new ProcessingException(e);
            }
        }, false);
    }

    public MediaType getMediaType() {
        return this.singleHeader("Content-Type", MediaType.class, RuntimeDelegateDecorator.configured(this.configuration).createHeaderDelegate(MediaType.class)::fromString, false);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        List values2 = (List)this.headers.get("Accept");
        if (values2 == null || values2.isEmpty()) {
            return WILDCARD_ACCEPTABLE_TYPE_SINGLETON_LIST;
        }
        ArrayList<AcceptableMediaType> result2 = new ArrayList<AcceptableMediaType>(values2.size());
        boolean conversionApplied = false;
        for (Object value2 : values2) {
            try {
                if (value2 instanceof MediaType) {
                    AcceptableMediaType _value = AcceptableMediaType.valueOf((MediaType)value2);
                    conversionApplied = _value != value2;
                    result2.add(_value);
                    continue;
                }
                conversionApplied = true;
                result2.addAll(HttpHeaderReader.readAcceptMediaType(HeaderUtils.asString(value2, this.configuration)));
            }
            catch (ParseException e) {
                throw OutboundMessageContext.exception("Accept", value2, e);
            }
        }
        if (conversionApplied) {
            this.headers.put("Accept", result2.stream().map(mediaType -> mediaType).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(result2);
    }

    public List<Locale> getAcceptableLanguages() {
        List values2 = (List)this.headers.get("Accept-Language");
        if (values2 == null || values2.isEmpty()) {
            return Collections.singletonList(new AcceptableLanguageTag("*", null).getAsLocale());
        }
        ArrayList<Locale> result2 = new ArrayList<Locale>(values2.size());
        boolean conversionApplied = false;
        for (Object value2 : values2) {
            if (value2 instanceof Locale) {
                result2.add((Locale)value2);
                continue;
            }
            conversionApplied = true;
            try {
                result2.addAll(HttpHeaderReader.readAcceptLanguage(HeaderUtils.asString(value2, this.configuration)).stream().map(LanguageTag::getAsLocale).collect(Collectors.toList()));
            }
            catch (ParseException e) {
                throw OutboundMessageContext.exception("Accept-Language", value2, e);
            }
        }
        if (conversionApplied) {
            this.headers.put("Accept-Language", result2.stream().map(locale -> locale).collect(Collectors.toList()));
        }
        return Collections.unmodifiableList(result2);
    }

    public Map<String, Cookie> getRequestCookies() {
        List cookies = (List)this.headers.get("Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Cookie> result2 = new HashMap<String, Cookie>();
        for (String cookie : HeaderUtils.asStringList((List<Object>)cookies, this.configuration)) {
            if (cookie == null) continue;
            result2.putAll(HttpHeaderReader.readCookies(cookie));
        }
        return result2;
    }

    public Set<String> getAllowedMethods() {
        String allowed = this.getHeaderString("Allow");
        if (allowed == null || allowed.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            return new HashSet<String>(HttpHeaderReader.readStringList(allowed));
        }
        catch (ParseException e) {
            throw OutboundMessageContext.exception("Allow", allowed, e);
        }
    }

    public int getLength() {
        return this.singleHeader("Content-Length", Integer.class, input -> {
            try {
                int i;
                if (input != null && !input.isEmpty() && (i = Integer.parseInt(input)) >= 0) {
                    return i;
                }
                return -1;
            }
            catch (NumberFormatException ex) {
                throw new ProcessingException(ex);
            }
        }, true);
    }

    public long getLengthLong() {
        return this.singleHeader("Content-Length", Long.class, input -> {
            try {
                long l;
                if (input != null && !input.isEmpty() && (l = Long.parseLong(input)) >= 0L) {
                    return l;
                }
                return -1L;
            }
            catch (NumberFormatException ex) {
                throw new ProcessingException(ex);
            }
        }, true);
    }

    public Map<String, NewCookie> getResponseCookies() {
        List cookies = (List)this.headers.get("Set-Cookie");
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, NewCookie> result2 = new HashMap<String, NewCookie>();
        for (String cookie : HeaderUtils.asStringList((List<Object>)cookies, this.configuration)) {
            if (cookie == null) continue;
            NewCookie newCookie = HttpHeaderReader.readNewCookie(cookie);
            String cookieName = newCookie.getName();
            if (result2.containsKey(cookieName)) {
                result2.put(cookieName, HeaderUtils.getPreferredCookie((NewCookie)result2.get(cookieName), newCookie));
                continue;
            }
            result2.put(cookieName, newCookie);
        }
        return result2;
    }

    public EntityTag getEntityTag() {
        return this.singleHeader("ETag", EntityTag.class, new Function<String, EntityTag>(){

            @Override
            public EntityTag apply(String value2) {
                try {
                    return value2 == null ? null : EntityTag.valueOf(value2);
                }
                catch (IllegalArgumentException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }, false);
    }

    public Date getLastModified() {
        return this.singleHeader("Last-Modified", Date.class, new Function<String, Date>(){

            @Override
            public Date apply(String input) {
                try {
                    return HttpHeaderReader.readDate(input);
                }
                catch (ParseException e) {
                    throw new ProcessingException(e);
                }
            }
        }, false);
    }

    public URI getLocation() {
        return this.singleHeader("Location", URI.class, new Function<String, URI>(){

            @Override
            public URI apply(String value2) {
                try {
                    return value2 == null ? null : URI.create(value2);
                }
                catch (IllegalArgumentException ex) {
                    throw new ProcessingException(ex);
                }
            }
        }, false);
    }

    public Set<Link> getLinks() {
        List values2 = (List)this.headers.get("Link");
        if (values2 == null || values2.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Link> result2 = new HashSet<Link>(values2.size());
        boolean conversionApplied = false;
        for (Object value2 : values2) {
            if (value2 instanceof Link) {
                result2.add((Link)value2);
                continue;
            }
            conversionApplied = true;
            try {
                result2.add(Link.valueOf(HeaderUtils.asString(value2, this.configuration)));
            }
            catch (IllegalArgumentException e) {
                throw OutboundMessageContext.exception("Link", value2, e);
            }
        }
        if (conversionApplied) {
            this.headers.put("Link", result2.stream().map(link -> link).collect(Collectors.toList()));
        }
        return Collections.unmodifiableSet(result2);
    }

    public boolean hasLink(String relation) {
        for (Link link : this.getLinks()) {
            List<String> relations = LinkProvider.getLinkRelations(link.getRel());
            if (relations == null || !relations.contains(relation)) continue;
            return true;
        }
        return false;
    }

    public Link getLink(String relation) {
        for (Link link : this.getLinks()) {
            List<String> relations = LinkProvider.getLinkRelations(link.getRel());
            if (relations == null || !relations.contains(relation)) continue;
            return link;
        }
        return null;
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLink(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink(link);
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.setEntity(entity, ReflectionHelper.genericTypeFor(entity));
    }

    public void setEntity(Object entity, Annotation[] annotations2) {
        this.setEntity(entity, ReflectionHelper.genericTypeFor(entity));
        this.setEntityAnnotations(annotations2);
    }

    private void setEntity(Object entity, GenericType<?> type2) {
        this.entity = entity instanceof GenericEntity ? ((GenericEntity)entity).getEntity() : entity;
        this.entityType = type2;
    }

    public void setEntity(Object entity, Type type2, Annotation[] annotations2) {
        this.setEntity(entity, new GenericType(type2));
        this.setEntityAnnotations(annotations2);
    }

    public void setEntity(Object entity, Annotation[] annotations2, MediaType mediaType) {
        this.setEntity(entity, annotations2);
        this.setMediaType(mediaType);
    }

    public void setMediaType(MediaType mediaType) {
        this.headers.putSingle("Content-Type", mediaType);
    }

    public Class<?> getEntityClass() {
        return this.entityType == null ? null : this.entityType.getRawType();
    }

    public Type getEntityType() {
        return this.entityType == null ? null : this.entityType.getType();
    }

    public void setEntityType(Type type2) {
        this.entityType = new GenericType(type2);
    }

    public Annotation[] getEntityAnnotations() {
        return (Annotation[])this.entityAnnotations.clone();
    }

    public void setEntityAnnotations(Annotation[] annotations2) {
        this.entityAnnotations = annotations2 == null ? EMPTY_ANNOTATIONS : annotations2;
    }

    public OutputStream getEntityStream() {
        return this.entityStream;
    }

    public void setEntityStream(OutputStream outputStream) {
        this.entityStream = outputStream;
    }

    public void enableBuffering(Configuration configuration) {
        Integer bufferSize = CommonProperties.getValue(configuration.getProperties(), configuration.getRuntimeType(), "jersey.config.contentLength.buffer", Integer.class);
        if (bufferSize != null) {
            this.committingOutputStream.enableBuffering(bufferSize);
        } else {
            this.committingOutputStream.enableBuffering();
        }
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.committingOutputStream.setStreamProvider(streamProvider);
    }

    public void commitStream() throws IOException {
        if (!this.committingOutputStream.isCommitted()) {
            this.entityStream.flush();
            if (!this.committingOutputStream.isCommitted()) {
                this.committingOutputStream.commit();
                this.committingOutputStream.flush();
            }
        }
    }

    public boolean isCommitted() {
        return this.committingOutputStream.isCommitted();
    }

    public void close() {
        if (this.hasEntity()) {
            try {
                OutputStream es = this.getEntityStream();
                es.flush();
                es.close();
            }
            catch (IOException e) {
                Logger.getLogger(OutboundMessageContext.class.getName()).log(Level.FINE, e.getMessage(), e);
            }
            finally {
                if (!this.committingOutputStream.isClosed()) {
                    try {
                        this.committingOutputStream.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(OutboundMessageContext.class.getName()).log(Level.FINE, e.getMessage(), e);
                    }
                }
            }
        }
    }

    void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public static interface StreamProvider {
        public OutputStream getOutputStream(int var1) throws IOException;
    }
}

