/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization;

import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.cache.authorization.CachedStoreFactoryProvider;
import org.keycloak.models.cache.authorization.CachedStoreProviderFactory;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheManager;
import org.keycloak.models.cache.infinispan.authorization.StoreFactoryCacheSession;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

public class InfinispanCacheStoreFactoryProviderFactory
implements CachedStoreProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanCacheStoreFactoryProviderFactory.class);
    public static final String AUTHORIZATION_CLEAR_CACHE_EVENTS = "AUTHORIZATION_CLEAR_CACHE_EVENTS";
    public static final String AUTHORIZATION_INVALIDATION_EVENTS = "AUTHORIZATION_INVALIDATION_EVENTS";
    protected volatile StoreFactoryCacheManager storeCache;
    public static final RealmModel NULL_REALM = null;

    public CachedStoreFactoryProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new StoreFactoryCacheSession(this.storeCache, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.storeCache == null) {
            InfinispanCacheStoreFactoryProviderFactory infinispanCacheStoreFactoryProviderFactory = this;
            synchronized (infinispanCacheStoreFactoryProviderFactory) {
                if (this.storeCache == null) {
                    Cache cache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("authorization");
                    Cache revisions = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("authorizationRevisions");
                    this.storeCache = new StoreFactoryCacheManager(cache, revisions);
                    ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
                    cluster.registerListener(AUTHORIZATION_INVALIDATION_EVENTS, event -> {
                        InvalidationEvent invalidationEvent = (InvalidationEvent)event;
                        this.storeCache.invalidationEventReceived(invalidationEvent);
                    });
                    cluster.registerListener(AUTHORIZATION_CLEAR_CACHE_EVENTS, event -> this.storeCache.clear());
                    cluster.registerListener("REALM_CLEAR_CACHE_EVENTS", event -> this.storeCache.clear());
                    log.debug((Object)"Registered cluster listeners");
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }
}

