/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractMulti;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.mutiny.subscription.SwitchableSubscriptionSubscriber;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class MultiConcatOp<T>
extends AbstractMulti<T> {
    private final Flow.Publisher<? extends T>[] publishers;
    private final boolean postponeFailurePropagation;

    @SafeVarargs
    public MultiConcatOp(boolean postponeFailurePropagation, Flow.Publisher<? extends T> ... publishers) {
        this.publishers = ParameterValidation.doesNotContainNull(publishers, "publishers");
        this.postponeFailurePropagation = postponeFailurePropagation;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> actual) {
        if (actual == null) {
            throw new NullPointerException("The subscriber must not be `null`");
        }
        if (this.publishers.length == 0) {
            Subscriptions.complete(actual);
            return;
        }
        if (this.publishers.length == 1) {
            this.publishers[0].subscribe(Infrastructure.onMultiSubscription(this.publishers[0], actual));
            return;
        }
        if (this.postponeFailurePropagation) {
            ConcatArrayAndPostponeFailureSubscriber<T> parent = new ConcatArrayAndPostponeFailureSubscriber<T>(actual, this.publishers);
            actual.onSubscribe(parent);
            if (!parent.isCancelled()) {
                parent.onCompletion();
            }
        } else {
            ConcatArraySubscriber<T> parent = new ConcatArraySubscriber<T>(actual, this.publishers);
            actual.onSubscribe(parent);
            if (!parent.isCancelled()) {
                parent.onCompletion();
            }
        }
    }

    static final class ConcatArrayAndPostponeFailureSubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        final Flow.Publisher<? extends T>[] upstreams;
        int index;
        long produced;
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicReference<Throwable> failure = new AtomicReference();

        ConcatArrayAndPostponeFailureSubscriber(MultiSubscriber<? super T> actual, Flow.Publisher<? extends T>[] upstreams) {
            super(actual);
            this.upstreams = upstreams;
        }

        @Override
        public void onItem(T t) {
            ++this.produced;
            this.downstream.onItem(t);
        }

        @Override
        public void onFailure(Throwable t) {
            if (Subscriptions.addFailure(this.failure, t)) {
                this.onCompletion();
            }
        }

        @Override
        public void onCompletion() {
            if (this.wip.getAndIncrement() == 0) {
                Flow.Publisher<? extends T>[] a = this.upstreams;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.index;
                    if (i == a.length) {
                        Throwable last = Subscriptions.markFailureAsTerminated(this.failure);
                        if (last != null) {
                            this.downstream.onFailure(last);
                        } else {
                            this.downstream.onCompletion();
                        }
                        return;
                    }
                    Flow.Publisher<? extends T> p = a[i];
                    if (p == null) {
                        this.downstream.onFailure(new NullPointerException("Source Publisher at currentIndex " + i + " is null"));
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.emitted(c);
                    }
                    p.subscribe(Infrastructure.onMultiSubscription(p, this));
                    if (this.isCancelled()) {
                        return;
                    }
                    this.index = ++i;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }

    static final class ConcatArraySubscriber<T>
    extends SwitchableSubscriptionSubscriber<T> {
        private final Flow.Publisher<? extends T>[] upstreams;
        private int currentIndex;
        private long emitted;
        private final AtomicInteger wip = new AtomicInteger();

        ConcatArraySubscriber(MultiSubscriber<? super T> actual, Flow.Publisher<? extends T>[] upstreams) {
            super(actual);
            this.upstreams = upstreams;
        }

        @Override
        public void onItem(T t) {
            ++this.emitted;
            this.downstream.onItem(t);
        }

        @Override
        public void onCompletion() {
            if (this.wip.getAndIncrement() == 0) {
                Flow.Publisher<? extends T>[] a = this.upstreams;
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    int i = this.currentIndex;
                    if (i == a.length) {
                        this.downstream.onCompletion();
                        return;
                    }
                    Flow.Publisher<? extends T> p = a[i];
                    long c = this.emitted;
                    if (c != 0L) {
                        this.emitted = 0L;
                        this.emitted(c);
                    }
                    p.subscribe(Infrastructure.onMultiSubscription(p, this));
                    if (this.isCancelled()) {
                        return;
                    }
                    this.currentIndex = ++i;
                } while (this.wip.decrementAndGet() != 0);
            }
        }
    }
}

