/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.operations;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.keycloak.client.admin.cli.util.HttpUtil;
import org.keycloak.representations.idm.RoleRepresentation;

public class RoleOperations {
    public static String getIdFromRoleName(String adminRoot, String realm, String auth, String rname) {
        return HttpUtil.getIdForType(adminRoot, realm, auth, "roles", "search", rname, "name");
    }

    public static void addRealmRoles(String rootUrl, String realm, String auth, String roleid, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "roles-by-id/" + roleid + "/composites");
        HttpUtil.doPostJSON(resourceUrl, auth, roles);
    }

    public static void addClientRoles(String rootUrl, String realm, String auth, String roleid, List<?> roles) {
        RoleOperations.addRealmRoles(rootUrl, realm, auth, roleid, roles);
    }

    public static void removeRealmRoles(String rootUrl, String realm, String auth, String roleid, List<?> roles) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "roles-by-id/" + roleid + "/composites");
        HttpUtil.doDeleteJSON(resourceUrl, auth, roles);
    }

    public static void removeClientRoles(String rootUrl, String realm, String auth, String roleid, List<?> roles) {
        RoleOperations.removeRealmRoles(rootUrl, realm, auth, roleid, roles);
    }

    public static String getRoleNameFromId(String adminRoot, String realm, String auth, String rid) {
        return HttpUtil.getAttrForType(adminRoot, realm, auth, "roles", "id", rid, "id", "name");
    }

    public static String getClientRoleNameFromId(String adminRoot, String realm, String auth, String cid, String rid) {
        return HttpUtil.getAttrForType(adminRoot, realm, auth, "clients/" + cid + "/roles", "id", rid, "id", "name");
    }

    public static List<RoleRepresentation> getRealmRoles(String rootUrl, String realm, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "roles");
        return HttpUtil.doGetJSON(LIST_OF_ROLES.class, resourceUrl, auth);
    }

    public static ObjectNode getRealmRole(String rootUrl, String realm, String rolename, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "roles/" + rolename);
        return HttpUtil.doGetJSON(ObjectNode.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getClientRoles(String rootUrl, String realm, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "clients/" + idOfClient + "/roles");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static ObjectNode getClientRole(String rootUrl, String realm, String idOfClient, String rolename, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "clients/" + idOfClient + "/roles/" + rolename);
        return HttpUtil.doGetJSON(ObjectNode.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getRealmRolesAsNodes(String rootUrl, String realm, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "roles");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getRealmRolesForUserAsNodes(String rootUrl, String realm, String userid, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/realm");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getCompositeRealmRolesForUserAsNodes(String rootUrl, String realm, String userid, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/realm/composite");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getAvailableRealmRolesForUserAsNodes(String rootUrl, String realm, String userid, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/realm/available");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getClientRolesForUserAsNodes(String rootUrl, String realm, String userid, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/clients/" + idOfClient);
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getCompositeClientRolesForUserAsNodes(String rootUrl, String realm, String userid, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/clients/" + idOfClient + "/composite");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getAvailableClientRolesForUserAsNodes(String rootUrl, String realm, String userid, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "users/" + userid + "/role-mappings/clients/" + idOfClient + "/available");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getRealmRolesForGroupAsNodes(String rootUrl, String realm, String groupid, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/realm");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getCompositeRealmRolesForGroupAsNodes(String rootUrl, String realm, String groupid, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/realm/composite");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getAvailableRealmRolesForGroupAsNodes(String rootUrl, String realm, String groupid, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/realm/available");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getClientRolesForGroupAsNodes(String rootUrl, String realm, String groupid, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/clients/" + idOfClient);
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getCompositeClientRolesForGroupAsNodes(String rootUrl, String realm, String groupid, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/clients/" + idOfClient + "/composite");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static List<ObjectNode> getAvailableClientRolesForGroupAsNodes(String rootUrl, String realm, String groupid, String idOfClient, String auth) {
        String resourceUrl = HttpUtil.composeResourceUrl(rootUrl, realm, "groups/" + groupid + "/role-mappings/clients/" + idOfClient + "/available");
        return HttpUtil.doGetJSON(LIST_OF_NODES.class, resourceUrl, auth);
    }

    public static class LIST_OF_ROLES
    extends ArrayList<RoleRepresentation> {
    }

    public static class LIST_OF_NODES
    extends ArrayList<ObjectNode> {
    }
}

