/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.GroupsResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmsAdminResource;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.AdminPermissionManagement;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.utils.GroupUtils;

@Extension(name="x-smallrye-profile-admin", value="")
public class GroupResource {
    private final RealmModel realm;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;
    private final GroupModel group;

    public GroupResource(RealmModel realm, GroupModel group, KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent.resource(ResourceType.GROUP);
        this.group = group;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Groups")
    @Operation
    public GroupRepresentation getGroup() {
        this.auth.groups().requireView(this.group);
        GroupRepresentation rep = GroupUtils.toRepresentation(this.auth.groups(), this.group, true);
        rep.setAccess(this.auth.groups().getAccess(this.group));
        return GroupUtils.populateSubGroupCount(this.group, rep);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="Update group, ignores subgroups.")
    public Response updateGroup(GroupRepresentation rep) {
        boolean exists;
        this.auth.groups().requireManage(this.group);
        String groupName = rep.getName();
        if (ObjectUtil.isBlank((CharSequence)groupName)) {
            throw ErrorResponse.error("Group name is missing", Response.Status.BAD_REQUEST);
        }
        if (!Objects.equals(groupName, this.group.getName()) && (exists = this.siblings().filter(s -> !Objects.equals(s.getId(), this.group.getId())).anyMatch(s -> Objects.equals(s.getName(), groupName)))) {
            throw ErrorResponse.exists("Sibling group named '" + groupName + "' already exists.");
        }
        GroupResource.updateGroup(rep, this.group, this.realm, this.session);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
        return Response.noContent().build();
    }

    private Stream<GroupModel> siblings() {
        if (this.group.getParentId() == null) {
            return this.session.groups().getTopLevelGroupsStream(this.realm);
        }
        return this.group.getParent().getSubGroupsStream();
    }

    @DELETE
    @Tag(name="Groups")
    @Operation
    public void deleteGroup() {
        this.auth.groups().requireManage(this.group);
        this.realm.removeGroup(this.group);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    @GET
    @Path(value="children")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="Return a paginated list of subgroups that have a parent group corresponding to the group on the URL")
    public Stream<GroupRepresentation> getSubGroups(@QueryParam(value="first") @DefaultValue(value="0") Integer first, @QueryParam(value="max") @DefaultValue(value="10") Integer max, @QueryParam(value="briefRepresentation") @DefaultValue(value="false") Boolean full) {
        this.auth.groups().requireView(this.group);
        boolean canViewGlobal = this.auth.groups().canView();
        return this.group.getSubGroupsStream(first, max).filter(g -> canViewGlobal || this.auth.groups().canView((GroupModel)g)).map(g -> GroupUtils.populateSubGroupCount(g, GroupUtils.toRepresentation(this.auth.groups(), g, full)));
    }

    @POST
    @Path(value="children")
    @NoCache
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="Set or create child.", description="This will just set the parent if it exists. Create it and set the parent if the group doesn\u2019t exist.")
    public Response addChild(GroupRepresentation rep) {
        this.auth.groups().requireManage(this.group);
        String groupName = rep.getName();
        if (ObjectUtil.isBlank((CharSequence)groupName)) {
            throw ErrorResponse.error("Group name is missing", Response.Status.BAD_REQUEST);
        }
        try {
            Response.ResponseBuilder builder = Response.status((int)204);
            GroupModel child = null;
            if (rep.getId() != null) {
                child = this.realm.getGroupById(rep.getId());
                if (child == null) {
                    throw new NotFoundException("Could not find child by id");
                }
                if (!Objects.equals(child.getParentId(), this.group.getId())) {
                    this.realm.moveGroup(child, this.group);
                }
                this.adminEvent.operation(OperationType.UPDATE);
            } else {
                child = this.realm.createGroup(groupName, this.group);
                GroupResource.updateGroup(rep, child, this.realm, this.session);
                URI uri = this.session.getContext().getUri().getBaseUriBuilder().path(AdminRoot.class).path(AdminRoot.class, "getRealmsAdmin").path(RealmsAdminResource.class, "getRealmAdmin").path(RealmAdminResource.class, "getGroups").path(GroupsResource.class, "getGroupById").build(new Object[]{this.realm.getName(), child.getId()});
                builder.status(201).location(uri);
                rep.setId(child.getId());
                this.adminEvent.operation(OperationType.CREATE);
            }
            this.adminEvent.resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
            GroupRepresentation childRep = GroupUtils.toRepresentation(this.auth.groups(), child, true);
            return builder.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)childRep).build();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Sibling group named '" + groupName + "' already exists.");
        }
    }

    public static void updateGroup(GroupRepresentation rep, GroupModel model, final RealmModel realm, final KeycloakSession session) {
        String existingName;
        String newName = rep.getName();
        if (newName != null && !newName.equals(existingName = model.getName())) {
            final String previousPath = KeycloakModelUtils.buildGroupPath((GroupModel)model);
            model.setName(newName);
            final String string = KeycloakModelUtils.buildGroupPath((GroupModel)model);
            GroupModel.GroupPathChangeEvent event = new GroupModel.GroupPathChangeEvent(){

                public RealmModel getRealm() {
                    return realm;
                }

                public String getNewPath() {
                    return string;
                }

                public String getPreviousPath() {
                    return previousPath;
                }

                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            };
            session.getKeycloakSessionFactory().publish((ProviderEvent)event);
        }
        if (rep.getAttributes() != null) {
            HashSet attrsToRemove = new HashSet(model.getAttributes().keySet());
            attrsToRemove.removeAll(rep.getAttributes().keySet());
            for (Map.Entry entry : rep.getAttributes().entrySet()) {
                model.setAttribute((String)entry.getKey(), (List)entry.getValue());
            }
            for (String string : attrsToRemove) {
                model.removeAttribute(string);
            }
        }
    }

    @Path(value="role-mappings")
    public RoleMapperResource getRoleMappings() {
        AdminPermissionEvaluator.RequirePermissionCheck manageCheck = () -> this.auth.groups().requireManage(this.group);
        AdminPermissionEvaluator.RequirePermissionCheck viewCheck = () -> this.auth.groups().requireView(this.group);
        return new RoleMapperResource(this.session, this.auth, (RoleMapperModel)this.group, this.adminEvent, manageCheck, viewCheck);
    }

    @GET
    @NoCache
    @Path(value="members")
    @Produces(value={"application/json"})
    @Tag(name="Groups")
    @Operation(summary="Get users Returns a stream of users, filtered according to query parameters")
    public Stream<UserRepresentation> getMembers(@Parameter(description="Pagination offset") @QueryParam(value="first") Integer firstResult, @Parameter(description="Maximum results size (defaults to 100)") @QueryParam(value="max") Integer maxResults, @Parameter(description="Only return basic information (only guaranteed to return id, username, created, first and last name, email, enabled state, email verification state, federation link, and access. Note that it means that namely user attributes, required actions, and not before are not returned.)") @QueryParam(value="briefRepresentation") Boolean briefRepresentation) {
        this.auth.groups().requireViewMembers(this.group);
        firstResult = firstResult != null ? firstResult : 0;
        maxResults = maxResults != null ? maxResults : 100;
        boolean briefRepresentationB = briefRepresentation != null && briefRepresentation != false;
        return this.session.users().getGroupMembersStream(this.realm, this.group, firstResult, maxResults).map(user -> briefRepresentationB ? ModelToRepresentation.toBriefRepresentation((UserModel)user) : ModelToRepresentation.toRepresentation((KeycloakSession)this.session, (RealmModel)this.realm, (UserModel)user));
    }

    @Path(value="management/permissions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Groups")
    @Operation(summary="Return object stating whether client Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference getManagementPermissions() {
        this.auth.groups().requireView(this.group);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        if (!permissions.groups().isPermissionsEnabled(this.group)) {
            return new ManagementPermissionReference();
        }
        return GroupResource.toMgmtRef(this.group, permissions);
    }

    public static ManagementPermissionReference toMgmtRef(GroupModel group, AdminPermissionManagement permissions) {
        ManagementPermissionReference ref = new ManagementPermissionReference();
        ref.setEnabled(true);
        ref.setResource(permissions.groups().resource(group).getId());
        ref.setScopePermissions(permissions.groups().getPermissions(group));
        return ref;
    }

    @Path(value="management/permissions")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @NoCache
    @Tag(name="Groups")
    @Operation(summary="Return object stating whether client Authorization permissions have been initialized or not and a reference")
    public ManagementPermissionReference setManagementPermissionsEnabled(ManagementPermissionReference ref) {
        this.auth.groups().requireManage(this.group);
        AdminPermissionManagement permissions = AdminPermissions.management(this.session, this.realm);
        permissions.groups().setPermissionsEnabled(this.group, ref.isEnabled());
        if (ref.isEnabled()) {
            return GroupResource.toMgmtRef(this.group, permissions);
        }
        return new ManagementPermissionReference();
    }
}

