
#ifndef KLEO_EXPORT_H
#define KLEO_EXPORT_H

#ifdef KLEO_STATIC_DEFINE
#  define KLEO_EXPORT
#  define KLEO_NO_EXPORT
#else
#  ifndef KLEO_EXPORT
#    ifdef KPim5Libkleo_EXPORTS
        /* We are building this library */
#      define KLEO_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KLEO_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KLEO_NO_EXPORT
#    define KLEO_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KLEO_DECL_DEPRECATED
#  define KLEO_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KLEO_DECL_DEPRECATED_EXPORT
#  define KLEO_DECL_DEPRECATED_EXPORT KLEO_EXPORT KLEO_DECL_DEPRECATED
#endif

#ifndef KLEO_DECL_DEPRECATED_NO_EXPORT
#  define KLEO_DECL_DEPRECATED_NO_EXPORT KLEO_NO_EXPORT KLEO_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KLEO_NO_DEPRECATED
#    define KLEO_NO_DEPRECATED
#  endif
#endif

#define KLEO_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

#if defined(KLEO_NO_DEPRECATED)
#  undef KLEO_DEPRECATED
#  define KLEO_DEPRECATED_EXPORT KLEO_EXPORT
#  define KLEO_DEPRECATED_NO_EXPORT KLEO_NO_EXPORT
#elif defined(KLEO_NO_DEPRECATED_WARNINGS)
#  define KLEO_DEPRECATED
#  define KLEO_DEPRECATED_EXPORT KLEO_EXPORT
#  define KLEO_DEPRECATED_NO_EXPORT KLEO_NO_EXPORT
#else
#  define KLEO_DEPRECATED KLEO_DECL_DEPRECATED
#  define KLEO_DEPRECATED_EXPORT KLEO_DECL_DEPRECATED_EXPORT
#  define KLEO_DEPRECATED_NO_EXPORT KLEO_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KLEO_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KLEO_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KLEO_NO_DEPRECATED
#  define KLEO_DISABLE_DEPRECATED_BEFORE_AND_AT 0x51804
#endif
#ifdef KLEO_NO_DEPRECATED_WARNINGS
#  define KLEO_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KLEO_DEPRECATED_WARNINGS_SINCE
#  ifdef KLEO_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KLEO_DEPRECATED_WARNINGS_SINCE KLEO_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KLEO_DEPRECATED_WARNINGS_SINCE 0x51804
#  endif
#endif

#ifndef KLEO_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KLEO_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KLEO_DEPRECATED
#  define KLEO_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KLEO_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KLEO_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KLEO_DEPRECATED_WARNINGS_SINCE >= 0x51700
#  define KLEO_DEPRECATED_VERSION_5_23(text) KLEO_DECL_DEPRECATED_TEXT(text)
#else
#  define KLEO_DEPRECATED_VERSION_5_23(text)
#endif
#define KLEO_DEPRECATED_VERSION_5(minor, text)      KLEO_DEPRECATED_VERSION_5_##minor(text)
#define KLEO_DEPRECATED_VERSION(major, minor, text) KLEO_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KLEO_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KLEO_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KLEO_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KLEO_DEPRECATED_VERSION(major, minor, text)
#  define KLEO_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KLEO_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KLEO_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KLEO_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KLEO_EXPORT_H */
