/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.PSKKeyExchangeModesExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.extension.ExtensionPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.extension.ExtensionSerializer;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSKKeyExchangeModesExtensionPreparator
extends ExtensionPreparator<PSKKeyExchangeModesExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PSKKeyExchangeModesExtensionMessage msg;

    public PSKKeyExchangeModesExtensionPreparator(Chooser chooser, PSKKeyExchangeModesExtensionMessage message, ExtensionSerializer<PSKKeyExchangeModesExtensionMessage> serializer) {
        super(chooser, message, serializer);
        this.msg = message;
    }

    @Override
    public void prepareExtensionContent() {
        LOGGER.debug("Preparing PSKKeyExchangeModesExtensionMessage");
        this.prepareListBytes();
        this.prepareListLength();
    }

    private void prepareListBytes() {
        if (this.msg.getKeyExchangeModesConfig() == null) {
            LOGGER.warn("No PSKKeyExchangeModes configured. Using empty byte[]");
            this.msg.setKeyExchangeModesListBytes(new byte[0]);
        } else {
            this.msg.setKeyExchangeModesListBytes(this.msg.getKeyExchangeModesConfig());
        }
    }

    private void prepareListLength() {
        this.msg.setKeyExchangeModesListLength(((byte[])this.msg.getKeyExchangeModesListBytes().getValue()).length);
    }
}

