/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Attribute;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class ComputedAttributesHandler
extends BaseDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputedAttributesHandler.class);
    private final CacheManager cacheManager;
    private final JexlEngine engine;
    private final JexlFeatures features;
    private final boolean includeDeviceAttributes;
    private final boolean includeLastAttributes;

    @Inject
    public ComputedAttributesHandler(Config config, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        JexlSandbox sandbox = new JexlSandbox(false);
        sandbox.allow("com.safe.Functions");
        sandbox.allow(Math.class.getName());
        List.of(Double.class, Float.class, Integer.class, Long.class, Short.class, Character.class, Boolean.class, String.class, Byte.class).forEach(type -> sandbox.allow(type.getName()));
        this.features = new JexlFeatures().localVar(config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_LOCAL_VARIABLES)).loops(config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_LOOPS)).newInstance(config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_NEW_INSTANCE_CREATION)).structuredLiteral(true);
        this.engine = new JexlBuilder().strict(true).namespaces(Collections.singletonMap("math", Math.class)).sandbox(sandbox).create();
        this.includeDeviceAttributes = config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_DEVICE_ATTRIBUTES);
        this.includeLastAttributes = config.getBoolean(Keys.PROCESSING_COMPUTED_ATTRIBUTES_LAST_ATTRIBUTES);
    }

    private MapContext prepareContext(Position position) {
        Device device;
        MapContext result = new MapContext();
        if (this.includeDeviceAttributes && (device = this.cacheManager.getObject(Device.class, position.getDeviceId())) != null) {
            for (String key : device.getAttributes().keySet()) {
                result.set(key, device.getAttributes().get(key));
            }
        }
        Position last = null;
        if (this.includeLastAttributes) {
            last = this.cacheManager.getPosition(position.getDeviceId());
        }
        HashSet<Method> methods = new HashSet<Method>(Arrays.asList(position.getClass().getMethods()));
        Arrays.asList(Object.class.getMethods()).forEach(methods::remove);
        for (Method method : methods) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0) continue;
            String name = Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
            try {
                if (!method.getReturnType().equals(Map.class)) {
                    result.set(name, method.invoke((Object)position, new Object[0]));
                    if (last == null) continue;
                    result.set(this.prefixAttribute("last", name), method.invoke((Object)last, new Object[0]));
                    continue;
                }
                for (Map.Entry entry : ((Map)method.invoke((Object)position, new Object[0])).entrySet()) {
                    result.set((String)entry.getKey(), entry.getValue());
                }
                if (last == null) continue;
                for (Map.Entry entry : ((Map)method.invoke((Object)last, new Object[0])).entrySet()) {
                    result.set(this.prefixAttribute("last", (String)entry.getKey()), entry.getValue());
                }
            }
            catch (IllegalAccessException | InvocationTargetException error) {
                LOGGER.warn("Attribute reflection error", (Throwable)error);
            }
        }
        return result;
    }

    private String prefixAttribute(String prefix, String key) {
        return prefix + Character.toUpperCase(key.charAt(0)) + key.substring(1);
    }

    @Deprecated
    public Object computeAttribute(Attribute attribute, Position position) throws JexlException {
        return this.engine.createScript(this.features, this.engine.createInfo(), attribute.getExpression(), new String[0]).execute((JexlContext)this.prepareContext(position));
    }

    @Override
    protected Position handlePosition(Position position) {
        Set<Attribute> attributes = this.cacheManager.getDeviceObjects(position.getDeviceId(), Attribute.class);
        for (Attribute attribute : attributes) {
            if (attribute.getAttribute() == null) continue;
            Object result = null;
            try {
                result = this.computeAttribute(attribute, position);
            }
            catch (JexlException error) {
                LOGGER.warn("Attribute computation error", (Throwable)error);
            }
            if (result == null) continue;
            try {
                block12 : switch (attribute.getAttribute()) {
                    case "valid": {
                        position.setValid((Boolean)result);
                        break;
                    }
                    case "latitude": {
                        position.setLatitude(((Number)result).doubleValue());
                        break;
                    }
                    case "longitude": {
                        position.setLongitude(((Number)result).doubleValue());
                        break;
                    }
                    case "altitude": {
                        position.setAltitude(((Number)result).doubleValue());
                        break;
                    }
                    case "speed": {
                        position.setSpeed(((Number)result).doubleValue());
                        break;
                    }
                    case "course": {
                        position.setCourse(((Number)result).doubleValue());
                        break;
                    }
                    case "address": {
                        position.setAddress((String)result);
                        break;
                    }
                    case "accuracy": {
                        position.setAccuracy(((Number)result).doubleValue());
                        break;
                    }
                    default: {
                        switch (attribute.getType()) {
                            case "number": {
                                Number numberValue = (Number)result;
                                position.getAttributes().put(attribute.getAttribute(), numberValue);
                                break block12;
                            }
                            case "boolean": {
                                Boolean booleanValue = (Boolean)result;
                                position.getAttributes().put(attribute.getAttribute(), booleanValue);
                                break block12;
                            }
                        }
                        position.getAttributes().put(attribute.getAttribute(), result.toString());
                        break;
                    }
                }
            }
            catch (ClassCastException error) {
                LOGGER.warn("Attribute cast error", (Throwable)error);
            }
        }
        return position;
    }
}

