/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;
import org.traccar.session.DeviceSession;

public class Gt06ProtocolDecoder
extends BaseProtocolDecoder {
    private final Map<Integer, ByteBuf> photos = new HashMap<Integer, ByteBuf>();
    public static final int MSG_LOGIN = 1;
    public static final int MSG_GPS = 16;
    public static final int MSG_GPS_LBS_6 = 17;
    public static final int MSG_GPS_LBS_1 = 18;
    public static final int MSG_GPS_LBS_2 = 34;
    public static final int MSG_GPS_LBS_3 = 55;
    public static final int MSG_GPS_LBS_4 = 45;
    public static final int MSG_STATUS = 19;
    public static final int MSG_SATELLITE = 20;
    public static final int MSG_STRING = 21;
    public static final int MSG_GPS_LBS_STATUS_1 = 22;
    public static final int MSG_WIFI = 23;
    public static final int MSG_GPS_LBS_STATUS_2 = 38;
    public static final int MSG_GPS_LBS_STATUS_3 = 39;
    public static final int MSG_LBS_MULTIPLE_1 = 40;
    public static final int MSG_LBS_MULTIPLE_2 = 46;
    public static final int MSG_LBS_MULTIPLE_3 = 36;
    public static final int MSG_LBS_WIFI = 44;
    public static final int MSG_LBS_EXTEND = 24;
    public static final int MSG_LBS_STATUS = 25;
    public static final int MSG_GPS_PHONE = 26;
    public static final int MSG_GPS_LBS_EXTEND = 30;
    public static final int MSG_HEARTBEAT = 35;
    public static final int MSG_ADDRESS_REQUEST = 42;
    public static final int MSG_ADDRESS_RESPONSE = 151;
    public static final int MSG_GPS_LBS_5 = 49;
    public static final int MSG_GPS_LBS_STATUS_4 = 50;
    public static final int MSG_WIFI_5 = 51;
    public static final int MSG_LBS_3 = 52;
    public static final int MSG_AZ735_GPS = 50;
    public static final int MSG_AZ735_ALARM = 51;
    public static final int MSG_X1_GPS = 52;
    public static final int MSG_X1_PHOTO_INFO = 53;
    public static final int MSG_X1_PHOTO_DATA = 54;
    public static final int MSG_WIFI_2 = 105;
    public static final int MSG_GPS_MODULAR = 112;
    public static final int MSG_WIFI_4 = 243;
    public static final int MSG_COMMAND_0 = 128;
    public static final int MSG_COMMAND_1 = 129;
    public static final int MSG_COMMAND_2 = 130;
    public static final int MSG_TIME_REQUEST = 138;
    public static final int MSG_INFO = 148;
    public static final int MSG_SERIAL = 155;
    public static final int MSG_STRING_INFO = 33;
    public static final int MSG_GPS_LBS_7 = 160;
    public static final int MSG_LBS_2 = 161;
    public static final int MSG_WIFI_3 = 162;
    public static final int MSG_FENCE_SINGLE = 163;
    public static final int MSG_FENCE_MULTI = 164;
    public static final int MSG_LBS_ALARM = 165;
    public static final int MSG_LBS_ADDRESS = 167;
    public static final int MSG_OBD = 140;
    public static final int MSG_DTC = 101;
    public static final int MSG_PID = 102;
    public static final int MSG_BMS = 64;
    public static final int MSG_MULTIMEDIA = 65;
    public static final int MSG_ALARM = 149;
    private Variant variant;
    private static final Pattern PATTERN_FUEL = new PatternBuilder().text("!AIOIL,").number("d+,").number("d+.d+,").number("(d+.d+),").expression("[^,]+,").number("dd").number("d").number("d,").number("(d+.d+),").expression("[01],").number("d+,").number("xx").compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().text("Current position!").number("Lat:([NS])(d+.d+),").number("Lon:([EW])(d+.d+),").text("Course:").number("(d+.d+),").text("Speed:").number("(d+.d+),").text("DateTime:").number("(dddd)-(dd)-(dd) +").number("(dd):(dd):(dd)").compile();

    public Gt06ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static boolean isSupported(int type) {
        return Gt06ProtocolDecoder.hasGps(type) || Gt06ProtocolDecoder.hasLbs(type) || Gt06ProtocolDecoder.hasStatus(type);
    }

    private static boolean hasGps(int type) {
        switch (type) {
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 26: 
            case 30: 
            case 34: 
            case 38: 
            case 39: 
            case 45: 
            case 49: 
            case 50: 
            case 55: 
            case 160: 
            case 163: 
            case 164: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasLbs(int type) {
        switch (type) {
            case 17: 
            case 18: 
            case 22: 
            case 25: 
            case 34: 
            case 38: 
            case 39: 
            case 45: 
            case 49: 
            case 50: 
            case 55: 
            case 160: 
            case 163: 
            case 164: 
            case 165: 
            case 167: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasStatus(int type) {
        switch (type) {
            case 19: 
            case 22: 
            case 25: 
            case 38: 
            case 39: 
            case 50: 
            case 164: 
            case 165: {
                return true;
            }
        }
        return false;
    }

    private static boolean hasLanguage(int type) {
        switch (type) {
            case 26: 
            case 35: 
            case 39: 
            case 40: 
            case 46: 
            case 161: 
            case 164: {
                return true;
            }
        }
        return false;
    }

    private void sendResponse(Channel channel, boolean extended, int type, int index, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            int length = 5 + (content != null ? content.readableBytes() : 0);
            if (extended) {
                response.writeShort(31097);
                response.writeShort(length);
            } else {
                response.writeShort(30840);
                response.writeByte(length);
            }
            response.writeByte(type);
            if (content != null) {
                response.writeBytes(content);
                content.release();
            }
            response.writeShort(index);
            response.writeShort(Checksum.crc16(Checksum.CRC16_X25, response.nioBuffer(2, response.writerIndex() - 2)));
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    private void sendPhotoRequest(Channel channel, int pictureId) {
        ByteBuf photo = this.photos.get(pictureId);
        ByteBuf content = Unpooled.buffer();
        content.writeInt(pictureId);
        content.writeInt(photo.writerIndex());
        content.writeShort(Math.min(photo.writableBytes(), 1024));
        this.sendResponse(channel, false, 54, 0, content);
    }

    public static boolean decodeGps(Position position, ByteBuf buf, boolean hasLength, TimeZone timezone) {
        return Gt06ProtocolDecoder.decodeGps(position, buf, hasLength, true, true, false, timezone);
    }

    public static boolean decodeGps(Position position, ByteBuf buf, boolean hasLength, boolean hasSatellites, boolean hasSpeed, boolean longSpeed, TimeZone timezone) {
        DateBuilder dateBuilder = new DateBuilder(timezone).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
        position.setTime(dateBuilder.getDate());
        if (hasLength && buf.readUnsignedByte() == 0) {
            return false;
        }
        if (hasSatellites) {
            position.set("sat", BitUtil.to(buf.readUnsignedByte(), 4));
        }
        double latitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
        double longitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
        if (hasSpeed) {
            position.setSpeed(UnitsConverter.knotsFromKph(longSpeed ? (double)buf.readUnsignedShort() : (double)buf.readUnsignedByte()));
        }
        int flags = buf.readUnsignedShort();
        position.setCourse(BitUtil.to(flags, 10));
        position.setValid(BitUtil.check(flags, 12));
        if (!BitUtil.check(flags, 10)) {
            latitude = -latitude;
        }
        if (BitUtil.check(flags, 11)) {
            longitude = -longitude;
        }
        position.setLatitude(latitude);
        position.setLongitude(longitude);
        if (BitUtil.check(flags, 14)) {
            position.set("ignition", BitUtil.check(flags, 15));
        }
        return true;
    }

    private boolean decodeLbs(Position position, ByteBuf buf, int type, boolean hasLength) {
        short length = 0;
        if (hasLength && (length = buf.readUnsignedByte()) == 0) {
            boolean zeroedData = true;
            for (int i = buf.readerIndex() + 9; i < buf.readerIndex() + 45 && i < buf.writerIndex(); ++i) {
                if (buf.getByte(i) == 0) continue;
                zeroedData = false;
                break;
            }
            if (zeroedData) {
                buf.skipBytes(Math.min(buf.readableBytes(), 45));
            }
            return false;
        }
        int mcc = buf.readUnsignedShort();
        int mnc = BitUtil.check(mcc, 15) || type == 17 ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
        int lac = type == 165 || type == 160 ? buf.readInt() : buf.readUnsignedShort();
        long cid = type == 165 || type == 160 ? buf.readLong() : (type == 17 || this.variant == Variant.SEEWORLD ? buf.readUnsignedInt() : (long)buf.readUnsignedMedium());
        position.setNetwork(new Network(CellTower.from(BitUtil.to(mcc, 15), mnc, lac, cid)));
        if (length > 9) {
            buf.skipBytes(length - 9);
        }
        return true;
    }

    private void decodeStatus(Position position, ByteBuf buf) {
        short status = buf.readUnsignedByte();
        position.set("status", Integer.valueOf(status));
        position.set("ignition", BitUtil.check(status, 1));
        position.set("charge", BitUtil.check(status, 2));
        position.set("blocked", BitUtil.check(status, 7));
        switch (BitUtil.between(status, 3, 6)) {
            case 1: {
                position.set("alarm", "vibration");
                break;
            }
            case 2: {
                position.set("alarm", "powerCut");
                break;
            }
            case 3: {
                position.set("alarm", "lowBattery");
                break;
            }
            case 4: {
                position.set("alarm", "sos");
                break;
            }
            case 6: {
                position.set("alarm", "geofence");
                break;
            }
            case 7: {
                if (this.variant == Variant.VXT01) {
                    position.set("alarm", "overspeed");
                    break;
                }
                position.set("alarm", "removing");
                break;
            }
        }
    }

    private String decodeAlarm(short value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 2: {
                return "powerCut";
            }
            case 3: 
            case 9: {
                return "vibration";
            }
            case 4: {
                return "geofenceEnter";
            }
            case 5: {
                return "geofenceExit";
            }
            case 6: {
                return "overspeed";
            }
            case 14: 
            case 15: 
            case 25: {
                return "lowBattery";
            }
            case 17: {
                return "powerOff";
            }
            case 12: 
            case 19: 
            case 37: {
                return "tampering";
            }
            case 20: {
                return "door";
            }
            case 24: {
                return "removing";
            }
            case 35: {
                return "fallDown";
            }
            case 41: {
                return "hardAcceleration";
            }
            case 48: {
                return "hardBraking";
            }
            case 42: 
            case 43: {
                return "hardCornering";
            }
            case 44: {
                return "accident";
            }
        }
        return null;
    }

    private Object decodeBasic(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        short length = buf.readUnsignedByte();
        int dataLength = length - 5;
        short type = buf.readUnsignedByte();
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = null;
        if (type != 1) {
            deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            if (!deviceSession.contains("timezone")) {
                deviceSession.set("timezone", this.getTimeZone(deviceSession.getDeviceId()));
            }
        }
        if (type == 1) {
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
            buf.readUnsignedShort();
            deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession != null) {
                TimeZone timeZone = this.getTimeZone(deviceSession.getDeviceId(), null);
                if (timeZone == null && dataLength > 10) {
                    int extensionBits = buf.readUnsignedShort();
                    int hours = (extensionBits >> 4) / 100;
                    int minutes = (extensionBits >> 4) % 100;
                    int offset = (hours * 60 + minutes) * 60;
                    if ((extensionBits & 8) != 0) {
                        offset = -offset;
                    }
                    timeZone = TimeZone.getTimeZone("UTC");
                    timeZone.setRawOffset(offset * 1000);
                }
                deviceSession.set("timezone", timeZone);
                this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
            }
            return null;
        }
        if (type == 35) {
            this.getLastLocation(position, null);
            short status = buf.readUnsignedByte();
            position.set("armed", BitUtil.check(status, 0));
            position.set("ignition", BitUtil.check(status, 1));
            position.set("charge", BitUtil.check(status, 2));
            if (buf.readableBytes() >= 8) {
                position.set("battery", (double)buf.readUnsignedShort() * 0.01);
            }
            if (buf.readableBytes() >= 7) {
                position.set("rssi", buf.readUnsignedByte());
            }
            this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
            return position;
        }
        if (type == 42) {
            String response = "NA&&NA&&0##";
            ByteBuf content = Unpooled.buffer();
            content.writeByte(response.length());
            content.writeInt(0);
            content.writeBytes(response.getBytes(StandardCharsets.US_ASCII));
            this.sendResponse(channel, true, 151, 0, content);
            return null;
        }
        if (type == 138) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            ByteBuf content = Unpooled.buffer();
            content.writeByte(calendar.get(1) - 2000);
            content.writeByte(calendar.get(2) + 1);
            content.writeByte(calendar.get(5));
            content.writeByte(calendar.get(11));
            content.writeByte(calendar.get(12));
            content.writeByte(calendar.get(13));
            this.sendResponse(channel, false, 138, 0, content);
            return null;
        }
        if (type == 52 && this.variant != Variant.SL4X) {
            buf.readUnsignedInt();
            Gt06ProtocolDecoder.decodeGps(position, buf, false, (TimeZone)deviceSession.get("timezone"));
            buf.readUnsignedShort();
            position.set("odometer", buf.readUnsignedInt());
            position.setNetwork(new Network(CellTower.from(buf.readUnsignedShort(), buf.readUnsignedByte(), buf.readUnsignedShort(), buf.readUnsignedInt())));
            long driverId = buf.readUnsignedInt();
            if (driverId > 0L) {
                position.set("driverUniqueId", String.valueOf(driverId));
            }
            position.set("battery", (double)buf.readUnsignedShort() * 0.01);
            position.set("power", (double)buf.readUnsignedShort() * 0.01);
            long portInfo = buf.readUnsignedInt();
            position.set("input", buf.readUnsignedByte());
            position.set("output", buf.readUnsignedByte());
            int i = 1;
            while ((long)i <= BitUtil.between(portInfo, 20, 24)) {
                position.set("adc" + i, (double)buf.readUnsignedShort() * 0.01);
                ++i;
            }
            return position;
        }
        if (type == 53) {
            buf.skipBytes(6);
            buf.readUnsignedByte();
            buf.readUnsignedInt();
            buf.readUnsignedInt();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            ByteBuf photo = Unpooled.buffer((int)buf.readInt());
            int pictureId = buf.readInt();
            this.photos.put(pictureId, photo);
            this.sendPhotoRequest(channel, pictureId);
            return null;
        }
        if (type == 23 || type == 105 || type == 243) {
            ByteBuf time = buf.readSlice(6);
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(time, 2)).setMonth(BcdUtil.readInteger(time, 2)).setDay(BcdUtil.readInteger(time, 2)).setHour(BcdUtil.readInteger(time, 2)).setMinute(BcdUtil.readInteger(time, 2)).setSecond(BcdUtil.readInteger(time, 2));
            this.getLastLocation(position, dateBuilder.getDate());
            Network network = new Network();
            int wifiCount = type == 243 ? buf.readUnsignedByte() : buf.getUnsignedByte(2);
            for (int i = 0; i < wifiCount; ++i) {
                if (type == 243) {
                    buf.skipBytes(2);
                }
                WifiAccessPoint wifiAccessPoint = new WifiAccessPoint();
                wifiAccessPoint.setMacAddress(String.format("%02x:%02x:%02x:%02x:%02x:%02x", buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()));
                if (type != 243) {
                    wifiAccessPoint.setSignalStrength(Integer.valueOf(buf.readUnsignedByte()));
                }
                network.addWifiAccessPoint(wifiAccessPoint);
            }
            if (type != 243) {
                int cellCount = buf.readUnsignedByte();
                int mcc = buf.readUnsignedShort();
                short mnc = buf.readUnsignedByte();
                for (int i = 0; i < cellCount; ++i) {
                    network.addCellTower(CellTower.from(mcc, mnc, buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedByte()));
                }
                if (channel != null) {
                    ByteBuf response = Unpooled.buffer();
                    response.writeShort(30840);
                    response.writeByte(0);
                    response.writeByte((int)type);
                    response.writeBytes(time.resetReaderIndex());
                    response.writeByte(13);
                    response.writeByte(10);
                    channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
                }
            }
            position.setNetwork(network);
            return position;
        }
        if (type == 148) {
            this.getLastLocation(position, null);
            position.set("power", (double)buf.readShort() * 0.01);
            return position;
        }
        if (type == 36 && this.variant == Variant.SR411_MINI) {
            Gt06ProtocolDecoder.decodeGps(position, buf, false, (TimeZone)deviceSession.get("timezone"));
            this.decodeLbs(position, buf, type, false);
            position.set("ignition", buf.readUnsignedByte() > 0);
            position.set("power", (double)buf.readUnsignedShort() * 0.01);
            position.set("battery", (double)buf.readUnsignedShort() * 0.01);
            return position;
        }
        if (type == 40 || type == 46 || type == 36 || type == 24 || type == 44 || type == 161 || type == 52 || type == 162 || type == 51) {
            int mcc;
            DateBuilder dateBuilder = new DateBuilder((TimeZone)deviceSession.get("timezone")).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            this.getLastLocation(position, dateBuilder.getDate());
            if (this.variant == Variant.WANWAY_S20 || this.variant == Variant.SL4X) {
                buf.readUnsignedByte();
            }
            int mnc = BitUtil.check(mcc = buf.readUnsignedShort(), 15) || this.variant == Variant.SL4X ? buf.readUnsignedShort() : (int)buf.readUnsignedByte();
            Network network = new Network();
            int cellCount = this.variant == Variant.WANWAY_S20 ? buf.readUnsignedByte() : (type == 51 ? 6 : 7);
            for (int i = 0; i < cellCount; ++i) {
                int cid;
                int lac;
                if (type == 161 || type == 162) {
                    lac = buf.readInt();
                    cid = (int)buf.readLong();
                } else if (type == 51 || type == 52) {
                    lac = buf.readUnsignedShort();
                    cid = (int)buf.readUnsignedInt();
                } else {
                    lac = buf.readUnsignedShort();
                    cid = buf.readUnsignedMedium();
                }
                short rssi = -buf.readUnsignedByte();
                if (lac <= 0) continue;
                network.addCellTower(CellTower.from(BitUtil.to(mcc, 15), mnc, lac, cid, rssi));
            }
            if (this.variant != Variant.WANWAY_S20 && this.variant != Variant.SL4X) {
                buf.readUnsignedByte();
            }
            if (type != 40 && type != 46 && type != 36 && type != 161 && type != 52) {
                int wifiCount = buf.readUnsignedByte();
                for (int i = 0; i < wifiCount; ++i) {
                    String mac = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)).replaceAll("(..)", "$1:");
                    network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), buf.readUnsignedByte()));
                }
            }
            position.setNetwork(network);
        } else if (type == 21) {
            this.getLastLocation(position, null);
            short commandLength = buf.readUnsignedByte();
            if (commandLength > 0) {
                buf.readUnsignedInt();
                String data = buf.readSlice(commandLength - 4).toString(StandardCharsets.US_ASCII);
                if (data.startsWith("<ICCID:")) {
                    position.set("iccid", data.substring(7, 27));
                } else {
                    position.set("result", data);
                }
            }
        } else {
            if (type == 64) {
                buf.skipBytes(8);
                this.getLastLocation(position, new Date(buf.readUnsignedInt() * 1000L));
                position.set("relativeCapacity", buf.readUnsignedByte());
                position.set("remainingCapacity", buf.readUnsignedShort());
                position.set("absoluteCapacity", buf.readUnsignedByte());
                position.set("fullCapacity", buf.readUnsignedShort());
                position.set("batteryHealth", buf.readUnsignedByte());
                position.set("batteryTemp", (double)buf.readUnsignedShort() * 0.1 - 273.1);
                position.set("current", buf.readUnsignedShort());
                position.set("battery", (double)buf.readUnsignedShort() * 0.001);
                position.set("cycleIndex", buf.readUnsignedShort());
                for (int i = 1; i <= 14; ++i) {
                    position.set("batteryCell" + i, (double)buf.readUnsignedShort() * 0.001);
                }
                position.set("currentChargeInterval", buf.readUnsignedShort());
                position.set("maxChargeInterval", buf.readUnsignedShort());
                position.set("barcode", buf.readCharSequence(16, StandardCharsets.US_ASCII).toString().trim());
                position.set("batteryVersion", buf.readUnsignedShort());
                position.set("manufacturer", buf.readCharSequence(16, StandardCharsets.US_ASCII).toString().trim());
                position.set("batteryStatus", buf.readUnsignedInt());
                position.set("controllerStatus", buf.readUnsignedInt());
                position.set("controllerFault", buf.readUnsignedInt());
                this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
                return position;
            }
            if (type == 19 && buf.readableBytes() == 22) {
                this.getLastLocation(position, null);
                buf.readUnsignedByte();
                buf.readUnsignedShort();
                buf.readUnsignedByte();
                buf.readUnsignedByte();
                position.set("batteryLevel", buf.readUnsignedByte());
                buf.readUnsignedByte();
                buf.readUnsignedShort();
                buf.readUnsignedByte();
                buf.readUnsignedShort();
                buf.readUnsignedShort();
                int value = buf.readUnsignedShort();
                double temperature = (double)BitUtil.to(value, 15) * 0.1;
                position.set("temp1", BitUtil.check(value, 15) ? temperature : -temperature);
            } else if (Gt06ProtocolDecoder.isSupported(type)) {
                if (type == 25 && this.variant == Variant.SPACE10X) {
                    return null;
                }
                if (Gt06ProtocolDecoder.hasGps(type)) {
                    Gt06ProtocolDecoder.decodeGps(position, buf, false, (TimeZone)deviceSession.get("timezone"));
                } else {
                    this.getLastLocation(position, null);
                }
                if (Gt06ProtocolDecoder.hasLbs(type) && buf.readableBytes() > 6) {
                    boolean hasLength = Gt06ProtocolDecoder.hasStatus(type) && type != 25 && type != 165 && (type != 22 || this.variant != Variant.VXT01);
                    this.decodeLbs(position, buf, type, hasLength);
                }
                if (Gt06ProtocolDecoder.hasStatus(type)) {
                    this.decodeStatus(position, buf);
                    if (this.variant == Variant.OBD6) {
                        int signal = buf.readUnsignedShort();
                        int satellites = BitUtil.between(signal, 10, 15) + BitUtil.between(signal, 5, 10);
                        position.set("sat", satellites);
                        position.set("rssi", BitUtil.to(signal, 5));
                        position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
                        buf.readUnsignedByte();
                        position.set("batteryLevel", buf.readUnsignedByte());
                        buf.readUnsignedByte();
                        position.set("power", (double)buf.readUnsignedShort() / 100.0);
                    } else {
                        int battery = buf.readUnsignedByte();
                        position.set("batteryLevel", battery <= 6 ? battery * 100 / 6 : battery);
                        position.set("rssi", buf.readUnsignedByte());
                        short alarmExtension = buf.readUnsignedByte();
                        if (this.variant != Variant.VXT01) {
                            position.set("alarm", this.decodeAlarm(alarmExtension));
                        }
                    }
                }
                if (type == 18) {
                    if (this.variant == Variant.GT06E_CARD) {
                        position.set("odometer", buf.readUnsignedInt());
                        String data = buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString();
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        position.set("card", data.trim());
                    } else if (this.variant == Variant.BENWAY) {
                        int value;
                        int mask = buf.readUnsignedShort();
                        position.set("ignition", BitUtil.check(mask, 15));
                        position.set("in2", BitUtil.check(mask, 14));
                        if (BitUtil.check(mask, 12)) {
                            value = BitUtil.to(mask, 9);
                            if (BitUtil.check(mask, 9)) {
                                value = -value;
                            }
                            position.set("temp1", value);
                        } else {
                            value = BitUtil.to(mask, 10);
                            if (BitUtil.check(mask, 13)) {
                                position.set("adc1", value);
                            } else {
                                position.set("adc1", (double)value * 0.1);
                            }
                        }
                    } else if (this.variant == Variant.VXT01) {
                        this.decodeStatus(position, buf);
                        position.set("power", (double)buf.readUnsignedShort() * 0.01);
                        position.set("rssi", buf.readUnsignedByte());
                        buf.readUnsignedByte();
                    } else if (this.variant == Variant.S5) {
                        this.decodeStatus(position, buf);
                        position.set("power", (double)buf.readUnsignedShort() * 0.01);
                        position.set("rssi", buf.readUnsignedByte());
                        position.set("alarm", this.decodeAlarm(buf.readUnsignedByte()));
                        position.set("oil", buf.readUnsignedShort());
                        int temperature = buf.readUnsignedByte();
                        if (BitUtil.check(temperature, 7)) {
                            temperature = -BitUtil.to(temperature, 7);
                        }
                        position.set("temp1", temperature);
                        position.set("odometer", buf.readUnsignedInt() * 10L);
                    } else if (this.variant == Variant.WETRUST) {
                        position.set("odometer", buf.readUnsignedInt());
                        position.set("card", buf.readCharSequence((int)buf.readUnsignedByte(), StandardCharsets.US_ASCII).toString());
                        position.set("alarm", buf.readUnsignedByte() > 0 ? "general" : null);
                        position.set("cardStatus", buf.readUnsignedByte());
                        position.set("drivingTime", buf.readUnsignedShort());
                    }
                }
                if (type == 34 && this.variant == Variant.SEEWORLD) {
                    position.set("ignition", buf.readUnsignedByte() > 0);
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    position.set("odometer", buf.readUnsignedInt());
                    buf.readUnsignedInt();
                    int temperature = buf.readUnsignedShort();
                    if (BitUtil.check(temperature, 15)) {
                        temperature = -BitUtil.to(temperature, 15);
                    }
                    position.set("temp1", (double)temperature * 0.01);
                    position.set("humidity", (double)buf.readUnsignedShort() * 0.01);
                }
                if ((type == 34 || type == 55 || type == 45) && buf.readableBytes() >= 9) {
                    position.set("ignition", buf.readUnsignedByte() > 0);
                    position.set("event", buf.readUnsignedByte());
                    position.set("archive", buf.readUnsignedByte() > 0);
                }
                if (type == 55) {
                    int module = buf.readUnsignedShort();
                    short subLength = buf.readUnsignedByte();
                    switch (module) {
                        case 39: {
                            position.set("power", (double)buf.readUnsignedShort() * 0.01);
                            break;
                        }
                        case 46: {
                            position.set("odometer", buf.readUnsignedInt());
                            break;
                        }
                        case 59: {
                            position.setAccuracy((double)buf.readUnsignedShort() * 0.01);
                            break;
                        }
                        default: {
                            buf.skipBytes((int)subLength);
                        }
                    }
                }
                if (buf.readableBytes() == 9 || buf.readableBytes() == 13) {
                    position.set("ignition", buf.readUnsignedByte() > 0);
                    buf.readUnsignedByte();
                    position.set("archive", buf.readUnsignedByte() > 0 ? Boolean.valueOf(true) : null);
                }
                if (buf.readableBytes() == 10) {
                    position.set("odometer", buf.readUnsignedInt());
                }
            } else if (type == 149) {
                boolean extendedAlarm;
                boolean bl = extendedAlarm = dataLength > 7;
                if (extendedAlarm) {
                    if (this.variant == Variant.JC400) {
                        buf.readUnsignedShort();
                        buf.readUnsignedByte();
                    }
                    Gt06ProtocolDecoder.decodeGps(position, buf, false, this.variant == Variant.JC400, this.variant == Variant.JC400, this.variant == Variant.JC400, (TimeZone)deviceSession.get("timezone"));
                } else {
                    DateBuilder dateBuilder = new DateBuilder((TimeZone)deviceSession.get("timezone")).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                    this.getLastLocation(position, dateBuilder.getDate());
                }
                if (this.variant == Variant.JC400) {
                    position.set("power", (double)buf.readUnsignedShort() * 0.1);
                }
                short event = buf.readUnsignedByte();
                position.set("event", event);
                switch (event) {
                    case 1: {
                        position.set("alarm", extendedAlarm ? "sos" : "general");
                        break;
                    }
                    case 14: {
                        position.set("alarm", "lowPower");
                        break;
                    }
                    case 118: {
                        position.set("alarm", "temperature");
                        break;
                    }
                    case 128: {
                        position.set("alarm", "vibration");
                        break;
                    }
                    case 135: {
                        position.set("alarm", "overspeed");
                        break;
                    }
                    case 136: {
                        position.set("alarm", "powerCut");
                        break;
                    }
                    case 144: {
                        position.set("alarm", "hardAcceleration");
                        break;
                    }
                    case 145: {
                        position.set("alarm", "hardBraking");
                        break;
                    }
                    case 146: {
                        position.set("alarm", "hardCornering");
                        break;
                    }
                    case 147: {
                        position.set("alarm", "accident");
                        break;
                    }
                }
            } else {
                if (dataLength > 0) {
                    buf.skipBytes(dataLength);
                }
                if (type != 128 && type != 129 && type != 130) {
                    this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
                }
                return null;
            }
        }
        if (Gt06ProtocolDecoder.hasLanguage(type)) {
            buf.readUnsignedShort();
        }
        if (type == 39 || type == 164) {
            position.set("geofence", buf.readUnsignedByte());
        }
        this.sendResponse(channel, false, type, buf.getShort(buf.writerIndex() - 6), null);
        return position;
    }

    private Object decodeExtended(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession == null) {
            return null;
        }
        if (!deviceSession.contains("timezone")) {
            deviceSession.set("timezone", this.getTimeZone(deviceSession.getDeviceId()));
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedShort();
        short type = buf.readUnsignedByte();
        if (type == 33) {
            buf.readUnsignedInt();
            String data = buf.readUnsignedByte() == 1 ? buf.readSlice(buf.readableBytes() - 6).toString(StandardCharsets.US_ASCII) : buf.readSlice(buf.readableBytes() - 6).toString(StandardCharsets.UTF_16BE);
            Parser parser = new Parser(PATTERN_LOCATION, data);
            if (parser.matches()) {
                position.setValid(true);
                position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
                position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.HEM_DEG));
                position.setCourse(parser.nextDouble());
                position.setSpeed(parser.nextDouble());
                position.setTime(parser.nextDateTime(Parser.DateTimeFormat.YMD_HMS));
            } else {
                this.getLastLocation(position, null);
                position.set("result", data);
            }
            return position;
        }
        if (type == 148) {
            short subType = buf.readUnsignedByte();
            this.getLastLocation(position, null);
            if (subType == 0) {
                position.set("adc1", (double)buf.readUnsignedShort() * 0.01);
                return position;
            }
            if (subType == 4) {
                String[] values;
                CharSequence content = buf.readCharSequence(buf.readableBytes() - 4 - 2, StandardCharsets.US_ASCII);
                block49: for (String value : values = content.toString().split(";")) {
                    String[] pair = value.split("=");
                    switch (pair[0]) {
                        case "ALM1": 
                        case "ALM2": 
                        case "ALM3": {
                            position.set("alarm" + pair[0].charAt(3) + "Status", Integer.parseInt(pair[1], 16));
                        }
                        case "STA1": {
                            position.set("otherStatus", Integer.parseInt(pair[1], 16));
                            continue block49;
                        }
                        case "DYD": {
                            position.set("engineStatus", Integer.parseInt(pair[1], 16));
                            continue block49;
                        }
                    }
                }
                return position;
            }
            if (subType == 5) {
                if (buf.readableBytes() >= 13) {
                    DateBuilder dateBuilder = new DateBuilder((TimeZone)deviceSession.get("timezone")).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                    position.setDeviceTime(dateBuilder.getDate());
                }
                short flags = buf.readUnsignedByte();
                position.set("door", BitUtil.check(flags, 0));
                position.set("io1", BitUtil.check(flags, 2));
                return position;
            }
            if (subType == 10) {
                buf.skipBytes(8);
                buf.skipBytes(8);
                position.set("iccid", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(10)).replaceAll("f", ""));
                return position;
            }
            if (subType == 13) {
                Parser parser;
                if (buf.getByte(buf.readerIndex()) != 33) {
                    buf.skipBytes(6);
                }
                if (!(parser = new Parser(PATTERN_FUEL, buf.toString(buf.readerIndex(), buf.readableBytes() - 4 - 2, StandardCharsets.US_ASCII))).matches()) {
                    return null;
                }
                position.set("temp1", parser.nextDouble(0.0));
                position.set("fuel", parser.nextDouble(0.0));
                return position;
            }
            if (subType == 27) {
                if (Character.isLetter(buf.getUnsignedByte(buf.readerIndex()))) {
                    String data = buf.readCharSequence(buf.readableBytes() - 6, StandardCharsets.US_ASCII).toString();
                    position.set("serial", data.trim());
                } else {
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    position.set("driverUniqueId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(4)));
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                }
                return position;
            }
        } else if (type == 54) {
            int pictureId = buf.readInt();
            ByteBuf photo = this.photos.get(pictureId);
            buf.readUnsignedInt();
            buf.readBytes(photo, buf.readUnsignedShort());
            if (photo.writableBytes() > 0) {
                this.sendPhotoRequest(channel, pictureId);
            } else {
                position.set("image", this.writeMediaFile(deviceSession.getUniqueId(), photo, "jpg"));
                this.photos.remove(pictureId).release();
            }
        } else {
            if (type == 50 || type == 51) {
                if (!Gt06ProtocolDecoder.decodeGps(position, buf, true, (TimeZone)deviceSession.get("timezone"))) {
                    this.getLastLocation(position, position.getDeviceTime());
                }
                if (this.decodeLbs(position, buf, type, true)) {
                    position.set("rssi", buf.readUnsignedByte());
                }
                buf.skipBytes((int)buf.readUnsignedByte());
                buf.skipBytes((int)buf.readUnsignedByte());
                short status = buf.readUnsignedByte();
                position.set("status", Integer.valueOf(status));
                if (type == 51) {
                    switch (status) {
                        case 160: {
                            position.set("armed", true);
                            break;
                        }
                        case 161: {
                            position.set("armed", false);
                            break;
                        }
                        case 162: 
                        case 163: {
                            position.set("alarm", "lowBattery");
                            break;
                        }
                        case 164: {
                            position.set("alarm", "general");
                            break;
                        }
                        case 165: {
                            position.set("alarm", "door");
                            break;
                        }
                    }
                }
                buf.skipBytes((int)buf.readUnsignedByte());
                this.sendResponse(channel, true, type, buf.getShort(buf.writerIndex() - 6), null);
                return position;
            }
            if (type == 140) {
                DateBuilder dateBuilder = new DateBuilder((TimeZone)deviceSession.get("timezone")).setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                this.getLastLocation(position, dateBuilder.getDate());
                position.set("ignition", buf.readUnsignedByte() > 0);
                String data = buf.readCharSequence(buf.readableBytes() - 18, StandardCharsets.US_ASCII).toString();
                block50: for (String pair : data.split(",")) {
                    String[] values = pair.split("=");
                    if (values.length < 2) continue;
                    switch (Integer.parseInt(values[0].substring(0, 2), 16)) {
                        case 40: {
                            position.set("odometer", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 43: {
                            position.set("fuel", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 45: {
                            position.set("coolantTemp", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 53: {
                            position.set("obdSpeed", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 54: {
                            position.set("rpm", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 71: {
                            position.set("fuelUsed", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 73: {
                            position.set("hours", (double)Integer.parseInt(values[1], 16) * 0.01);
                            continue block50;
                        }
                        case 74: {
                            position.set("vin", values[1]);
                            continue block50;
                        }
                    }
                }
                return position;
            }
            if (type == 112) {
                block51: while (buf.readableBytes() > 6) {
                    int moduleType = buf.readUnsignedShort();
                    int moduleLength = buf.readUnsignedShort();
                    switch (moduleType) {
                        case 3: {
                            position.set("iccid", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(10)));
                            continue block51;
                        }
                        case 9: {
                            position.set("sat", buf.readUnsignedByte());
                            continue block51;
                        }
                        case 10: {
                            position.set("satVisible", buf.readUnsignedByte());
                            continue block51;
                        }
                        case 17: {
                            CellTower cellTower = CellTower.from(buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedShort(), buf.readUnsignedMedium(), buf.readUnsignedByte());
                            if (cellTower.getCellId() <= 0L) continue block51;
                            position.setNetwork(new Network(cellTower));
                            continue block51;
                        }
                        case 24: {
                            position.set("battery", (double)buf.readUnsignedShort() * 0.01);
                            continue block51;
                        }
                        case 40: {
                            position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
                            continue block51;
                        }
                        case 41: {
                            position.set("index", buf.readUnsignedInt());
                            continue block51;
                        }
                        case 42: {
                            short input = buf.readUnsignedByte();
                            position.set("door", BitUtil.to(input, 4) > 0);
                            position.set("tamper", BitUtil.from(input, 4) > 0);
                            continue block51;
                        }
                        case 43: {
                            short event = buf.readUnsignedByte();
                            switch (event) {
                                case 17: {
                                    position.set("alarm", "lowBattery");
                                    break;
                                }
                                case 18: {
                                    position.set("alarm", "lowPower");
                                    break;
                                }
                                case 19: {
                                    position.set("alarm", "powerCut");
                                    break;
                                }
                                case 20: {
                                    position.set("alarm", "removing");
                                    break;
                                }
                            }
                            position.set("event", Integer.valueOf(event));
                            continue block51;
                        }
                        case 46: {
                            position.set("odometer", buf.readUnsignedIntLE());
                            continue block51;
                        }
                        case 51: {
                            position.setTime(new Date(buf.readUnsignedInt() * 1000L));
                            position.set("sat", buf.readUnsignedByte());
                            position.setAltitude(buf.readShort());
                            double latitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
                            double longitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
                            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                            int flags = buf.readUnsignedShort();
                            position.setCourse(BitUtil.to(flags, 10));
                            position.setValid(BitUtil.check(flags, 12));
                            if (!BitUtil.check(flags, 10)) {
                                latitude = -latitude;
                            }
                            if (BitUtil.check(flags, 11)) {
                                longitude = -longitude;
                            }
                            position.setLatitude(latitude);
                            position.setLongitude(longitude);
                            continue block51;
                        }
                        case 52: {
                            position.set("event", buf.readUnsignedByte());
                            buf.readUnsignedIntLE();
                            buf.skipBytes((int)buf.readUnsignedByte());
                            continue block51;
                        }
                    }
                    buf.skipBytes(moduleLength);
                }
                if (position.getFixTime() == null) {
                    this.getLastLocation(position, null);
                }
                this.sendResponse(channel, false, 112, buf.readUnsignedShort(), null);
                return position;
            }
            if (type == 65) {
                buf.skipBytes(8);
                long timestamp = buf.readUnsignedInt() * 1000L;
                buf.skipBytes(14);
                buf.skipBytes(8);
                int mediaId = buf.readInt();
                int mediaLength = buf.readInt();
                short mediaType = buf.readUnsignedByte();
                short mediaFormat = buf.readUnsignedByte();
                if (mediaType == 0 && mediaFormat == 0) {
                    ByteBuf photo;
                    buf.readUnsignedByte();
                    if (buf.readUnsignedShort() == 0) {
                        photo = Unpooled.buffer((int)mediaLength);
                        if (this.photos.containsKey(mediaId)) {
                            this.photos.remove(mediaId).release();
                        }
                        this.photos.put(mediaId, photo);
                    } else {
                        photo = this.photos.get(mediaId);
                    }
                    if (photo != null) {
                        buf.readBytes(photo, buf.readableBytes() - 6);
                        if (!photo.isWritable()) {
                            position = new Position(this.getProtocolName());
                            position.setDeviceId(deviceSession.getDeviceId());
                            this.getLastLocation(position, new Date(timestamp));
                            position.set("image", this.writeMediaFile(deviceSession.getUniqueId(), photo, "jpg"));
                            this.photos.remove(mediaId).release();
                        }
                    }
                }
                this.sendResponse(channel, true, type, buf.getShort(buf.writerIndex() - 6), null);
                return position;
            }
            if (type == 155) {
                position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, null);
                buf.readUnsignedByte();
                ByteBuf data = buf.readSlice(buf.readableBytes() - 6);
                if (BufferUtil.isPrintable(data, data.readableBytes())) {
                    String value = data.readCharSequence(data.readableBytes(), StandardCharsets.US_ASCII).toString();
                    position.set("result", value.trim());
                } else {
                    position.set("result", ByteBufUtil.hexDump((ByteBuf)data));
                }
                return position;
            }
        }
        return null;
    }

    private void decodeVariant(ByteBuf buf) {
        short type;
        int length;
        int header = buf.getUnsignedShort(buf.readerIndex());
        if (header == 30840) {
            length = buf.getUnsignedByte(buf.readerIndex() + 2);
            type = buf.getUnsignedByte(buf.readerIndex() + 2 + 1);
        } else {
            length = buf.getUnsignedShort(buf.readerIndex() + 2);
            type = buf.getUnsignedByte(buf.readerIndex() + 2 + 2);
        }
        this.variant = header == 30840 && type == 18 && length == 36 ? Variant.VXT01 : (header == 30840 && type == 22 && length == 36 ? Variant.VXT01 : (header == 30840 && type == 36 && length == 49 ? Variant.WANWAY_S20 : (header == 30840 && type == 36 && length == 46 ? Variant.SR411_MINI : (header == 30840 && type == 18 && length >= 113 ? Variant.GT06E_CARD : (header == 30840 && type == 18 && length == 33 ? Variant.BENWAY : (header == 30840 && type == 18 && length == 43 ? Variant.S5 : (header == 30840 && type == 25 && length >= 23 ? Variant.SPACE10X : (header == 30840 && type == 19 && length == 19 ? Variant.OBD6 : (header == 30840 && type == 18 && length == 41 ? Variant.WETRUST : (header == 30840 && type == 149 && buf.getUnsignedShort(buf.readerIndex() + 4) == 65535 ? Variant.JC400 : (header == 30840 && type == 52 && length == 55 ? Variant.SL4X : (header == 30840 && type == 34 && length == 47 ? Variant.SEEWORLD : (header == 30840 && type == 22 && length == 38 ? Variant.SEEWORLD : Variant.STANDARD)))))))))))));
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        this.decodeVariant(buf);
        short header = buf.readShort();
        if (header == 30840) {
            return this.decodeBasic(channel, remoteAddress, buf);
        }
        return this.decodeExtended(channel, remoteAddress, buf);
    }

    private static enum Variant {
        VXT01,
        WANWAY_S20,
        SR411_MINI,
        GT06E_CARD,
        BENWAY,
        S5,
        SPACE10X,
        STANDARD,
        OBD6,
        WETRUST,
        JC400,
        SL4X,
        SEEWORLD;

    }
}

