/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.SPDataSource;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import org.apache.log4j.Logger;

public class Olap4jDataSource
extends SPDataSource {
    private static final Logger logger = Logger.getLogger(Olap4jDataSource.class);
    public static final String XMLA_DRIVER_CLASS_NAME = "org.olap4j.driver.xmla.XmlaOlap4jDriver";
    public static final String IN_PROCESS_DRIVER_CLASS_NAME = "mondrian.olap4j.MondrianOlap4jDriver";
    private static final String JDBC_DATA_SOURCE_NAME = "jdbcDataSourceName";
    public static final String MONDRIAN_SCHEMA = "mondrianSchema";
    private static final String XMLA_SERVER = "xmlaServer";
    private static final String TYPE = "type";

    public Olap4jDataSource(DataSourceCollection<SPDataSource> dsCollection) {
        super(dsCollection);
    }

    public Olap4jDataSource(DataSourceCollection<SPDataSource> dsCollection, JDBCDataSource dataSource, URI mondrianSchema) {
        super(dsCollection);
        this.setDataSource(dataSource);
        this.setMondrianSchema(mondrianSchema);
        this.setType(Type.IN_PROCESS);
    }

    public Olap4jDataSource(DataSourceCollection<SPDataSource> dsCollection, URI xmlaServer) {
        super(dsCollection);
        try {
            this.setXmlaServer(xmlaServer.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("This exception should never happen because we convert from a URI to a URL.", e);
        }
        this.setType(Type.XMLA);
    }

    public JDBCDataSource getDataSource() {
        String jdbcName = this.get(JDBC_DATA_SOURCE_NAME);
        if (jdbcName == null) {
            return null;
        }
        return this.getParentCollection().getDataSource(jdbcName, JDBCDataSource.class);
    }

    public void setDataSource(JDBCDataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        this.put(JDBC_DATA_SOURCE_NAME, dataSource.getName());
    }

    public URI getMondrianSchema() {
        String uriPath = this.get(MONDRIAN_SCHEMA);
        if (uriPath != null && uriPath.startsWith("server:")) {
            URI serverBaseURI = this.getParentCollection().getMondrianServerBaseURI();
            if (serverBaseURI == null) {
                throw new IllegalArgumentException("The mondrian schema at " + uriPath + " can't" + " be located because no server base URI was specified");
            }
            String newUriPath = uriPath.substring("server:".length());
            logger.debug((Object)("Looking for file " + newUriPath + " at server location " + serverBaseURI));
            try {
                URL location = new URL(URLDecoder.decode(serverBaseURI.toString(), "UTF-8"));
                location = new URL(location, newUriPath);
                URI uri = new URI(location.toString());
                return uri;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (uriPath == null || uriPath.trim().length() == 0) {
            return null;
        }
        try {
            return new URI(uriPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("This should not happen as it should be the same URI path passed in earlier.", e);
        }
    }

    public void setMondrianSchema(URI mondrianSchema) {
        this.put(MONDRIAN_SCHEMA, mondrianSchema.toString());
    }

    public URI getXmlaServer() {
        String uriPath = this.get(XMLA_SERVER);
        if (uriPath == null || uriPath.trim().length() == 0) {
            return null;
        }
        try {
            return new URI(uriPath);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("This should not happen as it should be the same URI path passed in earlier.", e);
        }
    }

    public void setXmlaServer(String URL2) {
        this.put(XMLA_SERVER, URL2);
    }

    public Type getType() {
        String typeName = this.get(TYPE);
        if (typeName == null) {
            return null;
        }
        return Type.valueOf(typeName);
    }

    public void setType(Type type) {
        this.put(TYPE, type.name());
    }

    public String toString() {
        return this.getName();
    }

    public static enum Type {
        IN_PROCESS,
        XMLA;

    }
}

