'\"
'\" Copyright (c) 1997 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) labeledframe.n 1.21 97/1/30 16:04:44
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" @(#) man.macros 1.1 94/08/09 13:07:19
.\"
'\"	# Heading for Tcl/Tk man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tk    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'iwid'      .TH "\\$1" 1 "\\*(^3"  Tk    "[incr Widgets]"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.TH iwidgets::labeledframe iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::labeledframe \- Create and manipulate a labeled frame widget
.SH SYNOPSIS
\fBiwidgets::labeledframe\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Archetype <- iwidgets::Labeledframe
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBborderwidth\fR	\fBcursor\fR
\fBforeground\fR	\fBrelief\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBiPadX\fR
Class:	\fBIPad\fR
Command-Line Switch:	\fB-ipadx\fR
.fi
.IP
Specifies horizontal padding space between the border and the childsite.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 0.
.LP
.nf
Name:	\fBiPadY\fR
Class:	\fBIPad\fR
Command-Line Switch:	\fB-ipady\fR
.fi
.IP
Specifies vertical padding space between the border and the childsite.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
The default is 0.
.LP
.nf
Name:	\fBlabelBitmap\fR
Class:	\fBBitmap\fR
Command-Line Switch:	\fB-labelbitmap\fR
.fi
.IP
Specifies a bitmap to display in the label, in any of the forms 
acceptable to \fBTk_GetBitmap\fR.  This option overrides the \fIlabeltext\fR
option.
.LP
.nf
Name:	\fBlabelImage\fR
Class:	\fBImage\fR
Command-Line Switch:	\fB-labelimage\fR
.fi
.IP
Specifies a image to be used as the label. The image may be any of the
values created by the \fBimage create\fR command.  This option overrides
both the \fIlabelbitmap\fR and \fIlabeletext\fR options.
.LP
.nf
Name:	\fBlabelMargin\fR
Class:	\fBMargin\fR
Command-Line Switch:	\fB-labelmargin\fR
.fi
.IP
Specifies the distance between the inner ede of the hull frames relief,
and the label in any of the forms acceptable to \fBTk_GetPixels\fR. 
The default is 10 pixels.
.LP
.nf
Name:	\fBlabelText\fR
Class:	\fBText\fR
Command-Line Switch:	\fB-labeltext\fR
.fi
.IP
Specifies the text of the label around the childsite.
.LP
.nf
Name:	\fBlabelVariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB-labelvariable\fR
.fi
.IP
Specifies the text variable of the label around the childsite.
.LP
.nf
Name:	\fBlabelFont\fR
Class:	\fBFont\fR
Command-Line Switch:	\fB-labelfont\fR
.fi
.IP
Specifies the font of the label around the childsite.
.LP
.nf
Name:	\fBlabelPos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-labelpos\fR
.fi
.IP
Specifies the position of the label within the grooved relief of the hull widget.
\fB ne, n, nw, se, s, sw, en, e, es, wn, w, ws\fR  Default is \fBn\fR.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::labeledframe\fR command creates a hull frame with a
grooved relief, a label positioned within the grooved relief of
the hull frame, and a frame childsite.  The frame childsite can filled with any
widget via a derived class or though the use of the childsite method.
This class was designed to be a general purpose base class for supporting the 
combination of labeled frame and a childsite.  The options include the
ability to position the label at configurable locations within the
grooved relief of the hull frame, and control the display of the label.
.SH "METHODS"
.PP
The \fBiwidgets::labeledframe\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for labeledframe widgets:
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBchildsite\fR
Return the path name of the child site.
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::labeledframe\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::labeledframe\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBlabel\fR
.fi
.IP
The label component provides the label for the labeled widget.  See the 
"label" widget manual entry for details on the label component item.
.fi
.LP

.SH EXAMPLE
.IP
The labeledframe was primarily meant to be a base class.  The
Radiobox is a good example of a derived classe of the labeledframe class.
In order to provide equal support for composite classes, the 'childsite' methods
also exists.  The following is an example of 'childsite' method usage.
.LP
.DS
 package require Iwidgets 4.0
 iwidgets::labeledframe .lw -labeltext "Entry Frame" -labelpos n
 pack .lw -fill both -expand yes -padx 10 -pady 10
 set cs [.lw childsite]

 pack [iwidgets::entryfield $cs.entry1 -labeltext "Name:"] -side top -fill x
 pack [iwidgets::spinint $cs.entry2 -labeltext "Number:"] -side top -fill x
 pack [iwidgets::pushbutton $cs.entry3 -text "Details:"] -side top -fill x

.DE
.SH AUTHOR
John A. Tucker
.SH KEYWORDS
labeledframe, widget
