/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.charset.Charset;
import oracle.net.ns.NIOHeader;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;
import oracle.net.ns.ZLIBCodec;

final class NIOAcceptPacket
extends NIOPacket {
    protected int version;
    protected int options;
    protected int sduSize;
    protected int tduSize;
    protected int myHWByteOrder;
    protected int flag0;
    protected int flag1;
    String connectData;
    boolean isOOBCheckEnabled;

    NIOAcceptPacket(NIOHeader header, SessionAtts session) throws IOException {
        super(header, session);
    }

    @Override
    void readPayloadBuffer() throws IOException, NetException {
        short reconnectAddressLength = 0;
        short reconnectAddressOffset = 0;
        this.version = this.session.payloadBufferForRead.getShort();
        this.options = this.session.payloadBufferForRead.getShort();
        this.sduSize = this.session.payloadBufferForRead.getShort() & 0xFFFF;
        this.tduSize = this.session.payloadBufferForRead.getShort() & 0xFFFF;
        this.myHWByteOrder = this.session.payloadBufferForRead.getShort();
        short connectDataLen = this.session.payloadBufferForRead.getShort();
        short offsetToConnectData = this.session.payloadBufferForRead.getShort();
        this.flag0 = this.session.payloadBufferForRead.get();
        this.flag1 = this.session.payloadBufferForRead.get();
        this.session.timeout = this.session.payloadBufferForRead.getShort();
        this.session.tick = this.session.payloadBufferForRead.getShort();
        reconnectAddressLength = this.session.payloadBufferForRead.getShort();
        reconnectAddressOffset = this.session.payloadBufferForRead.getShort();
        boolean bl = this.session.noAnoServices = (this.flag1 & 8) == 8;
        if (!this.session.noAnoServices) {
            this.session.noAnoServices = (this.flag0 & 4) == 4;
        }
        this.session.timeout -= this.session.tick;
        this.session.timeout *= 10;
        if (reconnectAddressLength > 0) {
            this.session.reconnectAddress = new byte[reconnectAddressLength];
            this.session.payloadBufferForRead.position(reconnectAddressOffset - 8);
            this.session.payloadBufferForRead.get(this.session.reconnectAddress, 0, reconnectAddressLength);
        }
        if (this.version >= 315) {
            this.sduSize = this.session.payloadBufferForRead.getInt(24);
            this.tduSize = this.session.payloadBufferForRead.getInt(28);
            this.session.isLargeSDU = true;
            this.session.dataChannel.setLargeSDU(true);
            this.session.markerPacket.setLargeSDU(true);
            byte compressionFlag = this.session.payloadBufferForRead.get(32);
            boolean isCompressionCompatible = true;
            if (!this.session.cOption.protocol.equalsIgnoreCase("tcp") && (compressionFlag & 2) == 0) {
                isCompressionCompatible = false;
            }
            if (isCompressionCompatible && (compressionFlag & 0x80) != 0) {
                this.session.negotiatedNetworkCompression = (compressionFlag & 0x40) != 0 ? "auto" : "on";
                this.session.negotiatedNetworkCompressionScheme = (compressionFlag & 0x3C) >> 2;
                this.session.networkCompressionEnabled = true;
                if (this.session.negotiatedNetworkCompressionScheme == 1) {
                    throw new IOException("Unsupported Compression Scheme");
                }
                if (this.session.negotiatedNetworkCompressionScheme == 2) {
                    this.session.compressionCodec = new ZLIBCodec();
                }
            } else {
                this.session.negotiatedNetworkCompression = "off";
                this.session.networkCompressionEnabled = false;
            }
            if (this.version >= 318) {
                int flag2 = this.session.payloadBufferForRead.getInt(33);
                this.isOOBCheckEnabled = (flag2 & 1) > 0;
                this.session.isPollAndCheckEnabled = (flag2 & 0x1000000) != 0;
            }
            if (this.version >= 319) {
                byte[] _buf = new byte[16];
                this.session.payloadBufferForRead.position(37);
                this.session.payloadBufferForRead.get(_buf);
                this.session.setDatabaseUUID(_buf);
            }
        }
        if (this.session.timeout > 0) {
            int bufferOffset = connectDataLen + offsetToConnectData - 8;
            this.session.poolEnabled = true;
            this.session.sessionId = new byte[16];
            this.session.payloadBufferForRead.position(bufferOffset);
            this.session.payloadBufferForRead.get(this.session.sessionId, 0, 16);
            this.session.dataChannel.setPoolEnabled(true);
            this.session.timestampLastIO = System.currentTimeMillis();
        }
        if (connectDataLen > 0) {
            byte[] data = null;
            if (this.session.payloadBufferForRead.hasRemaining() && this.session.payloadBufferForRead.position(offsetToConnectData - 8).remaining() > 0) {
                data = new byte[connectDataLen];
                this.session.payloadBufferForRead.get(data);
            } else {
                data = this.session.dataChannel.readPayloadDataFromSocketChannel(connectDataLen);
            }
            this.connectData = new String(data, Charset.forName("US-ASCII"));
        } else {
            this.connectData = "";
        }
        this.session.setNegotiatedSDUAndTDU(this.sduSize, this.tduSize);
        this.session.setNegotiatedOptions(this.options);
        if (this.session.networkCompressionEnabled) {
            this.session.dataChannel.initializeNetworkCompressionBuffers();
        }
    }
}

