/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.autovalue.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontSmooth;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.layouter.context.FontSpecification;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;
import org.jfree.layouting.output.OutputProcessorFeature;

public class FontSmoothResolveHandler
implements ResolveHandler {
    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE};
    }

    @Override
    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        FontSpecification fontSpecification = layoutContext.getFontSpecification();
        double d = layoutProcess.getOutputMetaData().getNumericFeatureValue(OutputProcessorFeature.FONT_SMOOTH_THRESHOLD);
        if (fontSpecification.getFontSize() < d) {
            layoutContext.setValue(FontStyleKeys.X_FONT_SMOOTH_FLAG, FontSmooth.NEVER);
        } else {
            layoutContext.setValue(FontStyleKeys.X_FONT_SMOOTH_FLAG, FontSmooth.ALWAYS);
        }
    }
}

