"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _sample_savedObjects = require("../../common/helpers/events_explorer/sample_savedObjects");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

// eslint-disable-next-line import/no-default-export
class SavedObjectFacet {
  constructor(client) {
    this.client = client;

    _defineProperty(this, "fetch", async (request, params, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics fetch error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "create", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          body: {
            [objectType]: { ...request.body.object
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "createTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          body: {
            objectId: request.body.index,
            timestamp: { ...request.body
            }
          }
        };
        const savedRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedRes;
      } catch (err) {
        console.error('Event analytics create timestamp error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "updateTimestamp", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          objectId: request.body.objectId,
          body: { ...request.body
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }

      return res;
    });

    _defineProperty(this, "update", async (request, format, objectType) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          objectId: request.body.object_id,
          body: {
            [objectType]: { ...request.body.object
            }
          }
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics update error: ', err);
        res.data = err.message;
      }

      return res;
    });

    _defineProperty(this, "delete", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const params = {
          objectIdList: request.params.objectIdList
        };
        const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
        res.success = true;
        res.data = savedQueryRes;
      } catch (err) {
        console.error('Event analytics delete error: ', err);
        res.data = err.message;
      }

      return res;
    });

    _defineProperty(this, "createSamples", async (request, format) => {
      const res = {
        success: false,
        data: {}
      };

      try {
        const savedVizIds = [];
        const savedQueryIds = [];

        if (['panels', 'event_analytics'].includes(request.params.sampleRequestor)) {
          for (let i = 0; i < _sample_savedObjects.sampleVisualizations.length; i++) {
            const params = {
              body: {
                savedVisualization: { ..._sample_savedObjects.sampleVisualizations[i]
                }
              }
            };
            const savedVizRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedVizIds.push(savedVizRes.objectId);
          }

          for (let i = 0; i < _sample_savedObjects.sampleQueries.length; i++) {
            const params = {
              body: {
                savedQuery: { ..._sample_savedObjects.sampleQueries[i]
                }
              }
            };
            const savedQueryRes = await this.client.asScoped(request).callAsCurrentUser(format, params);
            savedQueryIds.push(savedQueryRes.objectId);
          }
        }

        res.success = true;
        res.data = {
          savedVizIds,
          savedQueryIds
        };
      } catch (err) {
        console.error('Event analytics create error: ', err);
        res.data = err;
      }

      return res;
    });

    _defineProperty(this, "getSavedObject", async request => {
      const params = {};

      for (const [param, value] of request.url.searchParams.entries()) {
        params[param] = value;
      }

      return this.fetch(request, { ...params
      }, 'observability.getObject');
    });

    _defineProperty(this, "createSavedQuery", async request => {
      return this.create(request, 'observability.createObject', 'savedQuery');
    });

    _defineProperty(this, "createSavedVisualization", request => {
      return this.create(request, 'observability.createObject', 'savedVisualization');
    });

    _defineProperty(this, "createSavedTimestamp", request => {
      return this.createTimestamp(request, 'observability.createObject');
    });

    _defineProperty(this, "updateSavedTimestamp", request => {
      return this.updateTimestamp(request, 'observability.updateObjectById');
    });

    _defineProperty(this, "updateSavedQuery", request => {
      return this.update(request, 'observability.updateObjectById', 'savedQuery');
    });

    _defineProperty(this, "updateSavedVisualization", request => {
      return this.update(request, 'observability.updateObjectById', 'savedVisualization');
    });

    _defineProperty(this, "deleteSavedObject", async request => {
      return this.delete(request, 'observability.deleteObjectByIdList');
    });

    _defineProperty(this, "createSampleSavedObjects", async request => {
      return this.createSamples(request, 'observability.createObject');
    });

    this.client = client;
  }

}

exports.default = SavedObjectFacet;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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