/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.stream.Stream;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.util.test.FreeColTestCase;
import net.sf.freecol.util.test.FreeColTestUtils;

public class TileTest
extends FreeColTestCase {
    private static final BuildingType townHallType = TileTest.spec().getBuildingType("model.building.townHall");
    private static final GoodsType cotton = TileTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType fish = TileTest.spec().getGoodsType("model.goods.fish");
    private static final GoodsType food = TileTest.spec().getPrimaryFoodType();
    private static final GoodsType furs = TileTest.spec().getGoodsType("model.goods.furs");
    private static final GoodsType grain = TileTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType lumber = TileTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType ore = TileTest.spec().getGoodsType("model.goods.ore");
    private static final GoodsType silver = TileTest.spec().getGoodsType("model.goods.silver");
    private static final GoodsType sugar = TileTest.spec().getGoodsType("model.goods.sugar");
    private static final GoodsType tobacco = TileTest.spec().getGoodsType("model.goods.tobacco");
    private static final ResourceType grainResource = TileTest.spec().getResourceType("model.resource.grain");
    private static final ResourceType lumberResource = TileTest.spec().getResourceType("model.resource.lumber");
    private static final ResourceType mineralsResource = TileTest.spec().getResourceType("model.resource.minerals");
    private static final ResourceType silverResource = TileTest.spec().getResourceType("model.resource.silver");
    private static final ResourceType sugarResource = TileTest.spec().getResourceType("model.resource.sugar");
    private static final TileImprovementType clearForest = TileTest.spec().getTileImprovementType("model.improvement.clearForest");
    private static final TileImprovementType fishBonusLand = TileTest.spec().getTileImprovementType("model.improvement.fishBonusLand");
    private static final TileImprovementType fishBonusRiver = TileTest.spec().getTileImprovementType("model.improvement.fishBonusRiver");
    private static final TileImprovementType plow = TileTest.spec().getTileImprovementType("model.improvement.plow");
    private static final TileImprovementType river = TileTest.spec().getTileImprovementType("model.improvement.river");
    private static final TileImprovementType road = TileTest.spec().getTileImprovementType("model.improvement.road");
    private static final TileType arctic = TileTest.spec().getTileType("model.tile.arctic");
    private static final TileType coniferForest = TileTest.spec().getTileType("model.tile.coniferForest");
    private static final TileType desert = TileTest.spec().getTileType("model.tile.desert");
    private static final TileType desertForest = TileTest.spec().getTileType("model.tile.scrubForest");
    private static final TileType grassland = TileTest.spec().getTileType("model.tile.grassland");
    private static final TileType highSeas = TileTest.spec().getTileType("model.tile.highSeas");
    private static final TileType hills = TileTest.spec().getTileType("model.tile.hills");
    private static final TileType marsh = TileTest.spec().getTileType("model.tile.marsh");
    private static final TileType marshForest = TileTest.spec().getTileType("model.tile.wetlandForest");
    private static final TileType mountains = TileTest.spec().getTileType("model.tile.mountains");
    private static final TileType ocean = TileTest.spec().getTileType("model.tile.ocean");
    private static final TileType plains = TileTest.spec().getTileType("model.tile.plains");
    private static final TileType plainsForest = TileTest.spec().getTileType("model.tile.mixedForest");
    private static final TileType prairie = TileTest.spec().getTileType("model.tile.prairie");
    private static final TileType prairieForest = TileTest.spec().getTileType("model.tile.broadleafForest");
    private static final TileType savannah = TileTest.spec().getTileType("model.tile.savannah");
    private static final TileType savannahForest = TileTest.spec().getTileType("model.tile.tropicalForest");
    private static final TileType swamp = TileTest.spec().getTileType("model.tile.swamp");
    private static final TileType swampForest = TileTest.spec().getTileType("model.tile.rainForest");
    private static final TileType tundra = TileTest.spec().getTileType("model.tile.tundra");
    private static final TileType tundraForest = TileTest.spec().getTileType("model.tile.borealForest");
    private static final UnitType colonistType = TileTest.spec().getUnitType("model.unit.freeColonist");
    private static final UnitType expertFarmerType = TileTest.spec().getUnitType("model.unit.expertFarmer");
    private static final UnitType expertLumberJack = TileTest.spec().getUnitType("model.unit.expertLumberJack");

    public void testGetWorkAmount() {
        Tile tile;
        Work[] cost;
        Game game = TileTest.getStandardGame();
        TileTest.assertNotNull((Object)plains);
        TileTest.assertNotNull((Object)desert);
        TileTest.assertNotNull((Object)grassland);
        TileTest.assertNotNull((Object)prairie);
        TileTest.assertNotNull((Object)tundra);
        TileTest.assertNotNull((Object)savannah);
        TileTest.assertNotNull((Object)marsh);
        TileTest.assertNotNull((Object)swamp);
        TileTest.assertNotNull((Object)arctic);
        TileTest.assertNotNull((Object)plainsForest);
        TileTest.assertNotNull((Object)desertForest);
        TileTest.assertNotNull((Object)coniferForest);
        TileTest.assertNotNull((Object)prairieForest);
        TileTest.assertNotNull((Object)tundraForest);
        TileTest.assertNotNull((Object)savannahForest);
        TileTest.assertNotNull((Object)marshForest);
        TileTest.assertNotNull((Object)swampForest);
        TileTest.assertEquals((int)2, (int)plow.getAddWorkTurns());
        TileTest.assertEquals((int)0, (int)road.getAddWorkTurns());
        TileTest.assertEquals((int)2, (int)clearForest.getAddWorkTurns());
        TileTest.assertNotNull((Object)plow);
        TileTest.assertNotNull((Object)road);
        TileTest.assertNotNull((Object)clearForest);
        for (Work entry : cost = new Work[]{new Work(plains, 5, 3), new Work(desert, 5, 3), new Work(grassland, 5, 3), new Work(prairie, 5, 3), new Work(tundra, 6, 4), new Work(savannah, 5, 3), new Work(marsh, 7, 5), new Work(swamp, 9, 7)}) {
            tile = new Tile(game, entry.type, 0, 0);
            TileTest.assertTrue((String)tile.getType().toString(), (boolean)tile.isImprovementTypeAllowed(plow));
            TileTest.assertTrue((String)tile.getType().toString(), (boolean)tile.isImprovementTypeAllowed(road));
            TileTest.assertFalse((String)tile.getType().toString(), (boolean)tile.isImprovementTypeAllowed(clearForest));
            TileTest.assertEquals((String)tile.getType().toString(), (int)entry.plow, (int)tile.getWorkAmount(plow));
            TileTest.assertEquals((String)tile.getType().toString(), (int)entry.road, (int)tile.getWorkAmount(road));
        }
        for (Work entry : cost = new Work[]{new Work(tundraForest, 6, 4), new Work(coniferForest, 6, 4), new Work(desertForest, 6, 4), new Work(prairieForest, 6, 4), new Work(savannahForest, 8, 6), new Work(marshForest, 8, 6), new Work(swampForest, 9, 7), new Work(plainsForest, 6, 4)}) {
            tile = new Tile(game, entry.type, 0, 0);
            TileTest.assertFalse((String)tile.getType().toString(), (boolean)tile.isImprovementTypeAllowed(plow));
            TileTest.assertTrue((String)tile.getType().toString(), (boolean)tile.isImprovementTypeAllowed(road));
            TileTest.assertTrue((String)tile.getType().toString(), (boolean)tile.isImprovementTypeAllowed(clearForest));
            TileTest.assertEquals((String)tile.getType().toString(), (int)entry.plow, (int)tile.getWorkAmount(clearForest));
            TileTest.assertEquals((String)tile.getType().toString(), (int)entry.road, (int)tile.getWorkAmount(road));
        }
    }

    public void testTileTypeChangeProduction() {
        for (TileType tileType : TileTest.spec().getTileTypeList()) {
            if (!tileType.isForested()) continue;
            AbstractGoods production = clearForest.getProduction(tileType);
            TileTest.assertNotNull((String)tileType.getId(), (Object)production);
            int amount = desertForest == tileType ? 10 : 20;
            TileTest.assertEquals((String)tileType.getId(), (int)amount, (int)production.getAmount());
        }
    }

    public void testPrimarySecondaryGoods() {
        Game game = TileTest.getStandardGame();
        game.changeMap(TileTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        Tile tile = colony.getTile();
        ColonyTile center = colony.getColonyTile(tile);
        List<AbstractGoods> production = center.getProduction();
        TileTest.assertEquals((int)2, (int)production.size());
        AbstractGoods primaryProduction = production.get(0);
        AbstractGoods secondaryProduction = production.get(1);
        TileTest.assertEquals((Object)grain, (Object)primaryProduction.getType());
        TileTest.assertEquals((int)3, (int)primaryProduction.getAmount());
        TileTest.assertEquals((Object)cotton, (Object)secondaryProduction.getType());
        TileTest.assertEquals((int)2, (int)secondaryProduction.getAmount());
        TileImprovement ti = new TileImprovement(game, tile, plow, null);
        ti.setTurnsToComplete(0);
        tile.add(ti);
        colony.invalidateCache();
        production = center.getProduction();
        TileTest.assertEquals((int)2, (int)production.size());
        primaryProduction = production.get(0);
        secondaryProduction = production.get(1);
        TileTest.assertEquals((Object)grain, (Object)primaryProduction.getType());
        TileTest.assertEquals((int)4, (int)primaryProduction.getAmount());
        TileTest.assertEquals((Object)cotton, (Object)secondaryProduction.getType());
        TileTest.assertEquals((int)2, (int)secondaryProduction.getAmount());
        tile.changeType(plainsForest);
        colony.invalidateCache();
        production = center.getProduction();
        TileTest.assertEquals((int)2, (int)production.size());
        primaryProduction = production.get(0);
        secondaryProduction = production.get(1);
        TileTest.assertEquals((Object)grain, (Object)primaryProduction.getType());
        TileTest.assertEquals((int)2, (int)primaryProduction.getAmount());
        TileTest.assertEquals((Object)furs, (Object)secondaryProduction.getType());
        TileTest.assertEquals((int)3, (int)secondaryProduction.getAmount());
    }

    public void testPotential() {
        Game game = TileTest.getStandardGame();
        Tile tile = new Tile(game, mountains, 0, 0);
        TileTest.assertEquals((int)0, (int)mountains.getPotentialProduction(silver, null));
        TileTest.assertEquals((int)0, (int)tile.getPotentialProduction(food, null));
        TileTest.assertEquals((int)1, (int)mountains.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)1, (int)tile.getPotentialProduction(silver, colonistType));
        tile.addResource(new Resource(game, tile, silverResource));
        TileTest.assertEquals((int)0, (int)tile.getPotentialProduction(food, colonistType));
        TileTest.assertEquals((int)3, (int)tile.getPotentialProduction(silver, colonistType));
    }

    public void testMaximumPotential() {
        Game game = TileTest.getStandardGame();
        Tile tile1 = new Tile(game, mountains, 0, 0);
        TileTest.assertEquals((String)"Mountain/food", (int)0, (int)tile1.getPotentialProduction(food, colonistType));
        TileTest.assertEquals((String)"Mountain/food max", (int)0, (int)tile1.getMaximumPotential(food, colonistType));
        TileTest.assertEquals((String)"Mountain/silver", (int)1, (int)tile1.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((String)"Mountain/silver max", (int)2, (int)tile1.getMaximumPotential(silver, colonistType));
        tile1.addResource(new Resource(game, tile1, silverResource));
        TileTest.assertEquals((String)"Mountain+Resource/food", (int)0, (int)tile1.getPotentialProduction(food, colonistType));
        TileTest.assertEquals((String)"Mountain+Resource/silver", (int)3, (int)tile1.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((String)"Mountain+Resource/silver max", (int)4, (int)tile1.getMaximumPotential(silver, colonistType));
        Tile tile2 = new Tile(game, plains, 0, 1);
        TileTest.assertEquals((String)"Plains/grain", (int)3, (int)tile2.getPotentialProduction(grain, null));
        TileTest.assertEquals((String)"Plains/grain max", (int)4, (int)tile2.getMaximumPotential(grain, null));
        TileTest.assertEquals((String)"Plains/grain/colonist", (int)5, (int)tile2.getPotentialProduction(grain, colonistType));
        TileTest.assertEquals((String)"Plains/grain/colonist max", (int)6, (int)tile2.getMaximumPotential(grain, colonistType));
        TileTest.assertEquals((String)"Plains/grain/expertFarmer", (int)7, (int)tile2.getPotentialProduction(grain, expertFarmerType));
        tile2.addResource(new Resource(game, tile2, grainResource));
        TileTest.assertEquals((String)"Plains+Resource/grain", (int)5, (int)tile2.getPotentialProduction(grain, null));
        TileTest.assertEquals((String)"Plains+Resource/grain max", (int)6, (int)tile2.getMaximumPotential(grain, null));
        TileTest.assertEquals((String)"Plains+Resource/grain/colonist", (int)7, (int)tile2.getPotentialProduction(grain, colonistType));
        TileTest.assertEquals((String)"Plains+Resource/grain/colonist max", (int)8, (int)tile2.getMaximumPotential(grain, colonistType));
        TileTest.assertEquals((String)"Plains+Resource/grain/expertFarmer", (int)11, (int)tile2.getPotentialProduction(grain, expertFarmerType));
        TileTest.assertEquals((String)"Plains+Resource/grain/expertFarmer max", (int)12, (int)tile2.getMaximumPotential(grain, expertFarmerType));
        Tile tile3 = new Tile(game, plainsForest, 1, 1);
        TileTest.assertEquals((String)"Forest/grain", (int)2, (int)tile3.getPotentialProduction(grain, null));
        TileTest.assertEquals((String)"Forest/grain max", (int)4, (int)tile3.getMaximumPotential(grain, null));
        TileTest.assertEquals((String)"Forest/lumber/colonist", (int)6, (int)tile3.getPotentialProduction(lumber, colonistType));
        TileTest.assertEquals((String)"Forest/lumber/colonist max", (int)8, (int)tile3.getMaximumPotential(lumber, colonistType));
        TileTest.assertEquals((String)"Forest/lumber/expertLumberJack", (int)12, (int)tile3.getPotentialProduction(lumber, expertLumberJack));
        TileTest.assertEquals((String)"Forest/lumber/expertLumberJack max", (int)14, (int)tile3.getMaximumPotential(lumber, expertLumberJack));
    }

    public void testIsTileTypeAllowed() {
        for (TileType tileType : TileTest.spec().getTileTypeList()) {
            if (tileType.isWater()) {
                if (highSeas.equals(tileType)) {
                    TileTest.assertFalse((boolean)fishBonusLand.isTileTypeAllowed(tileType));
                    TileTest.assertFalse((boolean)fishBonusRiver.isTileTypeAllowed(tileType));
                } else {
                    TileTest.assertTrue((boolean)fishBonusLand.isTileTypeAllowed(tileType));
                    TileTest.assertTrue((boolean)fishBonusRiver.isTileTypeAllowed(tileType));
                }
                TileTest.assertFalse((boolean)river.isTileTypeAllowed(tileType));
                TileTest.assertFalse((boolean)road.isTileTypeAllowed(tileType));
                TileTest.assertFalse((boolean)plow.isTileTypeAllowed(tileType));
                TileTest.assertFalse((boolean)clearForest.isTileTypeAllowed(tileType));
                continue;
            }
            if (tileType.isForested()) {
                TileTest.assertTrue((boolean)clearForest.isTileTypeAllowed(tileType));
            } else {
                TileTest.assertFalse((boolean)clearForest.isTileTypeAllowed(tileType));
            }
            if (arctic.equals(tileType) || hills.equals(tileType) || mountains.equals(tileType)) {
                TileTest.assertFalse((boolean)river.isTileTypeAllowed(tileType));
                TileTest.assertFalse((boolean)plow.isTileTypeAllowed(tileType));
            } else {
                TileTest.assertTrue((boolean)river.isTileTypeAllowed(tileType));
                if (tileType.isForested()) {
                    TileTest.assertFalse((boolean)plow.isTileTypeAllowed(tileType));
                } else {
                    TileTest.assertTrue((boolean)plow.isTileTypeAllowed(tileType));
                }
            }
            TileTest.assertTrue((boolean)road.isTileTypeAllowed(tileType));
        }
    }

    public void testImprovements() throws Exception {
        Game game = TileTest.getStandardGame();
        Map map = TileTest.getTestMap(plains);
        game.changeMap(map);
        Tile tile1 = map.getTile(5, 8);
        Tile tile2 = map.getTile(4, 8);
        TileImprovement road1 = tile1.addRoad();
        TileTest.assertFalse((boolean)road1.isComplete());
        road1.setTurnsToComplete(0);
        TileTest.assertTrue((boolean)road1.isComplete());
        TileTest.assertTrue((boolean)tile1.hasRoad());
        TileImprovement river1 = tile1.addRiver(1, "0101");
        TileTest.assertTrue((boolean)river1.isComplete());
        TileTest.assertTrue((boolean)tile1.hasRiver());
        TileImprovement road2 = tile2.addRoad();
        road2.setTurnsToComplete(0);
        TileTest.assertTrue((boolean)road2.isComplete());
        TileImprovement river2 = tile2.addRiver(1, "0101");
        TileTest.assertTrue((boolean)tile2.hasRoad());
        TileTest.assertTrue((boolean)tile2.hasRiver());
        tile1.changeType(savannah);
        TileTest.assertTrue((boolean)tile1.hasRoad());
        TileTest.assertTrue((boolean)tile1.hasRiver());
        tile2.changeType(hills);
        TileTest.assertTrue((boolean)tile2.hasRoad());
        TileTest.assertFalse((boolean)tile2.hasRiver());
    }

    public void testProductionModifiers() throws Exception {
        Game game = TileTest.getGame();
        game.changeMap(TileTest.getTestMap(true));
        Colony colony = this.getStandardColony();
        List<ColonyTile> colonyTiles = colony.getColonyTiles();
        ColonyTile colonyTile1 = null;
        ColonyTile colonyTile2 = null;
        for (ColonyTile ct : colonyTiles) {
            if (ct.getWorkTile().hasRoad()) continue;
            if (colonyTile1 == null) {
                colonyTile1 = ct;
                continue;
            }
            if (colonyTile2 != null) continue;
            colonyTile2 = ct;
            break;
        }
        Tile tile1 = colonyTile1.getWorkTile();
        Tile tile2 = colonyTile2.getWorkTile();
        TileTest.assertFalse((boolean)tile1.hasRoad());
        TileTest.assertFalse((boolean)tile2.hasRoad());
        TileImprovement road1 = tile1.addRoad();
        road1.setTurnsToComplete(0);
        TileTest.assertTrue((boolean)road1.isComplete());
        TileImprovement river1 = tile1.addRiver(1, "0101");
        TileTest.assertTrue((boolean)tile1.hasRoad());
        TileTest.assertTrue((boolean)tile1.hasRiver());
        TileImprovement road2 = tile2.addRoad();
        road2.setTurnsToComplete(0);
        TileTest.assertTrue((boolean)road2.isComplete());
        TileImprovement river2 = tile2.addRiver(1, "0101");
        TileTest.assertTrue((boolean)tile2.hasRoad());
        TileTest.assertTrue((boolean)tile2.hasRiver());
        tile1.changeType(savannah);
        TileTest.assertTrue((boolean)tile1.hasRoad());
        TileTest.assertTrue((boolean)tile1.hasRiver());
        tile2.changeType(hills);
        TileTest.assertTrue((boolean)tile2.hasRoad());
        TileTest.assertFalse((boolean)tile2.hasRiver());
        TileTest.assertTrue((boolean)tile1.canProduce(sugar, null));
        TileTest.assertTrue((boolean)this.hasBonusFrom(tile1.getProductionModifiers(sugar, null), river1.getType()));
        TileTest.assertFalse((boolean)tile1.canProduce(lumber, null));
        TileTest.assertFalse((boolean)this.hasBonusFrom(tile1.getProductionModifiers(lumber, null), river1.getType()));
        TileTest.assertFalse((boolean)tile2.canProduce(sugar, null));
        TileTest.assertFalse((boolean)this.hasBonusFrom(tile2.getProductionModifiers(sugar, null), road2.getType()));
        TileTest.assertTrue((boolean)tile2.canProduce(ore, null));
        TileTest.assertFalse((boolean)this.hasBonusFrom(tile2.getProductionModifiers(ore, null), road2.getType()));
        TileTest.assertTrue((boolean)this.hasBonusFrom(tile2.getProductionModifiers(ore, colonistType), road2.getType()));
        Turn turn = TileTest.getGame().getTurn();
        TileTest.assertTrue((boolean)tile1.canProduce(sugar, null));
        int oldBase = tile1.getBaseProduction(null, sugar, null);
        Resource addedSugar = new Resource(game, tile1, sugarResource);
        tile1.addResource(addedSugar);
        int newBase = tile1.getBaseProduction(null, sugar, null);
        TileTest.assertEquals((int)oldBase, (int)newBase);
        TileTest.assertEquals((int)((int)FeatureContainer.applyModifiers((float)newBase, turn, tile1.getProductionModifiers(sugar, null))), (int)((int)FeatureContainer.applyModifiers((float)oldBase, turn, addedSugar.getProductionModifiers(sugar, null)) + (int)FeatureContainer.applyModifiers(0.0f, turn, river1.getProductionModifiers(sugar, null))));
        TileTest.assertTrue((boolean)this.hasBonusFrom(tile1.getProductionModifiers(sugar, null), river1.getType()));
        TileTest.assertTrue((boolean)this.hasBonusFrom(tile1.getProductionModifiers(sugar, null), sugarResource));
        TileTest.assertFalse((boolean)tile2.canProduce(silver, null));
        oldBase = tile2.getBaseProduction(null, silver, null);
        Resource addedSilver = new Resource(game, tile2, mineralsResource);
        TileTest.assertTrue((boolean)addedSilver.canProduce(silver, null));
        TileTest.assertTrue((boolean)addedSilver.canProduce(silver, colonistType));
        tile2.addResource(addedSilver);
        newBase = tile2.getBaseProduction(null, silver, null);
        TileTest.assertTrue((boolean)tile2.canProduce(silver, null));
        TileTest.assertEquals((int)oldBase, (int)newBase);
        TileTest.assertEquals((int)((int)FeatureContainer.applyModifiers((float)newBase, turn, tile2.getProductionModifiers(silver, null))), (int)((int)FeatureContainer.applyModifiers((float)oldBase, turn, addedSilver.getProductionModifiers(silver, null)) + (int)FeatureContainer.applyModifiers(0.0f, turn, road2.getProductionModifiers(silver, null))));
        TileTest.assertTrue((boolean)tile2.canProduce(silver, null));
        TileTest.assertFalse((boolean)this.hasBonusFrom(tile2.getProductionModifiers(silver, null), road2.getType()));
        TileTest.assertTrue((boolean)this.hasBonusFrom(tile2.getProductionModifiers(silver, colonistType), road2.getType()));
        TileTest.assertTrue((boolean)this.hasBonusFrom(tile2.getProductionModifiers(silver, null), mineralsResource));
    }

    private boolean hasBonusFrom(Stream<Modifier> modifierSet, FreeColSpecObjectType source) {
        return CollectionUtils.any(modifierSet, CollectionUtils.matchKeyEquals(source, Feature::getSource));
    }

    public void testColonyImprovements() throws Exception {
        Game game = TileTest.getStandardGame();
        Map map = TileTest.getTestMap(plains);
        game.changeMap(map);
        Colony colony = FreeColTestUtils.getColonyBuilder().build();
        TileTest.assertTrue((boolean)colony.getTile().hasRoad());
        colony.exciseSettlement();
        TileTest.assertFalse((boolean)colony.getTile().hasRoad());
    }

    public void testConiferForest() {
        int result;
        ColonyTile ct;
        Map map = TileTest.getTestMap(coniferForest);
        Game game = TileTest.getGame();
        game.changeMap(map);
        Colony colony = this.getStandardColony(1);
        Tile tile = colony.getTile();
        tile.addRiver(1, "1111");
        Iterable<Tile> tiles = tile.getSurroundingTiles(1);
        Tile firstTile = null;
        int i = 0;
        for (Tile t : tiles) {
            if (firstTile == null) {
                firstTile = t;
            }
            if (i & true) {
                t.addRiver(1, "1111");
            }
            if ((i & 2) == 2) {
                TileImprovement road = t.addRoad();
                road.setTurnsToComplete(0);
            }
            if ((i & 4) == 4) {
                t.addResource(new Resource(game, t, lumberResource, 99));
            }
            ++i;
        }
        ColonyTile firstColonyTile = colony.getColonyTile(firstTile);
        Unit unit = colony.getUnitList().get(0);
        TileTest.assertEquals((Object)colonistType, (Object)unit.getType());
        unit.setLocation(firstColonyTile);
        unit.changeWorkType(lumber);
        TileTest.assertEquals((String)"Added unit producing lumber", (Object)lumber, (Object)unit.getWorkType());
        int base = 6;
        int riverBonus = 2;
        int roadBonus = 2;
        int resourceBonus = 4;
        int expertBonus = 2;
        TileTest.assertEquals((String)"Base lumber production", (int)6, (int)coniferForest.getBaseProduction(null, lumber, colonistType));
        i = 0;
        for (Tile t : tiles) {
            ct = colony.getColonyTile(t);
            unit.setLocation(ct);
            unit.changeWorkType(lumber);
            result = 6;
            if (t.hasRiver()) {
                result += 2;
            }
            if (t.hasRoad()) {
                result += 2;
            }
            if (t.hasResource()) {
                result += 4;
            }
            TileTest.assertEquals((String)("FreeColonist lumber production at tile " + i), (int)result, (int)ct.getTotalProductionOf(lumber));
            ++i;
        }
        TileTest.assertEquals((String)"Expert unit", (Object)expertLumberJack, (Object)firstColonyTile.getExpertUnitType());
        unit.setType(expertLumberJack);
        colony.invalidateCache();
        i = 0;
        for (Tile t : tiles) {
            ct = colony.getColonyTile(t);
            unit.setLocation(ct);
            unit.changeWorkType(lumber);
            result = 12;
            if (t.hasRiver()) {
                result += 4;
            }
            if (t.hasRoad()) {
                result += 4;
            }
            if (t.hasResource()) {
                result += 8;
            }
            TileTest.assertEquals((String)("Expert lumber production at tile " + i), (int)result, (int)ct.getTotalProductionOf(lumber));
            ++i;
        }
    }

    public void testMinerals() {
        Game game = TileTest.getGame();
        Map map = TileTest.getTestMap(tundra);
        game.changeMap(map);
        Colony colony = this.getStandardColony();
        Tile tile = colony.getTile().getNeighbourOrNull(Direction.N);
        ColonyTile colonyTile = colony.getColonyTile(tile);
        tile.addResource(new Resource(game, tile, mineralsResource));
        for (Unit u : colonyTile.getUnitList()) {
            u.setLocation(colony.getBuilding(townHallType));
        }
        TileTest.assertTrue((boolean)colonyTile.isEmpty());
        TileTest.assertEquals((Object)colonyTile.getWorkTile().getOwningSettlement(), (Object)colony);
        Unit unit = colony.getUnitList().get(0);
        TileTest.assertEquals((Object)colonistType, (Object)unit.getType());
        TileTest.assertTrue((boolean)silver.isFarmed());
        TileTest.assertEquals((int)0, (int)tundra.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)1, (int)tile.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)1, (int)CollectionUtils.count(tile.getProductionModifiers(silver, colonistType)));
        TileTest.assertEquals((int)1, (int)colonyTile.getPotentialProduction(silver, unit.getType()));
        TileTest.assertTrue((boolean)colonyTile.canBeWorked());
        TileTest.assertTrue((boolean)colonyTile.canAdd(unit));
        TileTest.assertEquals((Object)colonyTile, (Object)colony.getWorkLocationFor(unit, silver));
        Tile marshTile = colony.getTile().getNeighbourOrNull(Direction.S);
        marshTile.setType(marsh);
        ColonyTile marshColonyTile = colony.getColonyTile(marshTile);
        for (Unit u : marshColonyTile.getUnitList()) {
            u.setLocation(colony.getBuilding(townHallType));
        }
        TileTest.assertTrue((boolean)marshColonyTile.isEmpty());
        TileTest.assertEquals((Object)marshColonyTile.getWorkTile().getOwningSettlement(), (Object)colony);
        TileTest.assertEquals((int)0, (int)marsh.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)0, (int)marshTile.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)0, (int)CollectionUtils.count(marshTile.getProductionModifiers(silver, colonistType)));
        TileTest.assertEquals((int)0, (int)marshColonyTile.getPotentialProduction(silver, unit.getType()));
        TileImprovement road = marshTile.addRoad();
        road.setTurnsToComplete(0);
        TileTest.assertTrue((boolean)road.isComplete());
        TileTest.assertEquals((int)0, (int)marsh.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)0, (int)marshTile.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)0, (int)CollectionUtils.count(marshTile.getProductionModifiers(silver, colonistType)));
        TileTest.assertEquals((int)0, (int)marshColonyTile.getPotentialProduction(silver, unit.getType()));
        marshTile.addResource(new Resource(game, marshTile, mineralsResource));
        TileTest.assertEquals((int)0, (int)marsh.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)2, (int)marshTile.getPotentialProduction(silver, colonistType));
        TileTest.assertEquals((int)2, (int)CollectionUtils.count(marshTile.getProductionModifiers(silver, colonistType)));
        TileTest.assertEquals((int)2, (int)marshColonyTile.getPotentialProduction(silver, unit.getType()));
    }

    public void testDefenceModifiers() {
        for (TileType tileType : TileTest.spec().getTileTypeList()) {
            boolean present = tileType.isForested() || "model.tile.hills".equals(tileType.getId()) || "model.tile.marsh".equals(tileType.getId()) || "model.tile.mountains".equals(tileType.getId()) || "model.tile.swamp".equals(tileType.getId());
            TileTest.assertEquals((String)("Defence for " + tileType.getId()), (boolean)present, (CollectionUtils.count(tileType.getDefenceModifiers()) != 0 ? 1 : 0) != 0);
        }
    }

    public void testZIndex() {
        TileTest.assertTrue((boolean)true);
        TileTest.assertTrue((boolean)true);
        TileTest.assertTrue((boolean)true);
        TileTest.assertTrue((plow.getZIndex() < river.getZIndex() ? 1 : 0) != 0);
        TileTest.assertTrue((river.getZIndex() < road.getZIndex() ? 1 : 0) != 0);
        TileTest.assertTrue((200 < road.getZIndex() ? 1 : 0) != 0);
        TileTest.assertTrue((road.getZIndex() < 400 ? 1 : 0) != 0);
    }

    public void testCopy() {
        Game game = TileTest.getStandardGame();
        game.changeMap(TileTest.getTestMap(plains));
        Colony colony = this.getStandardColony();
        Tile tile = colony.getTile();
        Tile otherTile = (Tile)tile.copy(game);
        TileTest.assertNotNull((Object)otherTile);
        TileTest.assertFalse((otherTile == tile ? 1 : 0) != 0);
        TileTest.assertEquals((String)tile.getId(), (String)otherTile.getId());
        TileTest.assertEquals((Object)tile.getType(), (Object)otherTile.getType());
        Colony otherColony = otherTile.getColony();
        TileTest.assertEquals((Object)otherTile, (Object)otherColony.getTile());
        TileTest.assertEquals((Object)otherTile.getOwningSettlement(), (Object)otherColony);
        TileTest.assertFalse((colony == otherColony ? 1 : 0) != 0);
        TileTest.assertEquals((String)colony.getId(), (String)otherColony.getId());
    }

    public void testGetBestDisembarkTile() {
        Game game = TileTest.getStandardGame();
        Map map = TileTest.getCoastTestMap(plains, true);
        game.changeMap(map);
        Player dutch = game.getPlayerByNationId("model.nation.dutch");
        Tile settlementTile = map.getTile(9, 2);
        FreeColTestUtils.getColonyBuilder().player(dutch).colonyTile(settlementTile).build();
        Tile tileN = map.getTile(9, 1);
        TileTest.assertTrue((boolean)tileN.isLand());
        Tile tileS = map.getTile(9, 3);
        TileTest.assertTrue((boolean)tileS.isLand());
        Tile tileE = map.getTile(8, 2);
        TileTest.assertTrue((boolean)tileE.isLand());
        tileS.setType(tundraForest);
        tileE.setType(mountains);
        List<Tile> tiles = settlementTile.getSafestSurroundingLandTiles(dutch);
        TileTest.assertFalse((String)"Surrounding tiles should be found", (boolean)tiles.isEmpty());
        TileTest.assertEquals((String)"Best tile is mountainous", (Object)tileE, (Object)tiles.get(0));
        TileTest.assertEquals((String)"Best landing tile is forest", (Object)tileS, (Object)settlementTile.getBestDisembarkTile(dutch));
        tileN.setType(hills);
        TileTest.assertEquals((String)"Best landing tile is now hills", (Object)tileN, (Object)settlementTile.getBestDisembarkTile(dutch));
    }

    private class Work {
        public TileType type;
        public int plow;
        public int road;

        public Work(TileType type, int plow, int road) {
            this.type = type;
            this.plow = plow;
            this.road = road;
        }
    }
}

