/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JDialog;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.dialogs.AccessWarningPane;
import net.sourceforge.jnlp.security.dialogs.AppletWarningPane;
import net.sourceforge.jnlp.security.dialogs.CertWarningPane;
import net.sourceforge.jnlp.security.dialogs.CertsInfoPane;
import net.sourceforge.jnlp.security.dialogs.MissingALACAttributePanel;
import net.sourceforge.jnlp.security.dialogs.MissingPermissionsAttributePanel;
import net.sourceforge.jnlp.security.dialogs.MoreInfoPane;
import net.sourceforge.jnlp.security.dialogs.PasswordAuthenticationPane;
import net.sourceforge.jnlp.security.dialogs.SecurityDialogPanel;
import net.sourceforge.jnlp.security.dialogs.SingleCertInfoPane;
import net.sourceforge.jnlp.security.dialogs.apptrustwarningpanel.AppTrustWarningDialog;
import net.sourceforge.jnlp.util.ImageResources;
import net.sourceforge.jnlp.util.ScreenFinder;
import net.sourceforge.jnlp.util.logging.OutputController;

public class SecurityDialog
extends JDialog {
    private final SecurityDialogs.DialogType dialogType;
    private final SecurityDialogs.AccessType accessType;
    private SecurityDialogPanel panel;
    private final JNLPFile file;
    private final CertVerifier certVerifier;
    private final X509Certificate cert;
    private final Object[] extras;
    private boolean initialized = false;
    private Object value;
    private boolean requiresSignedJNLPWarning;
    private final List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file, CertVerifier JarCertVerifier2, X509Certificate cert, Object[] extras) {
        this.setIconImages(ImageResources.INSTANCE.getApplicationImages());
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = JarCertVerifier2;
        this.cert = cert;
        this.extras = extras;
        this.initialized = true;
        if (file != null) {
            this.requiresSignedJNLPWarning = file.requiresSignedJNLPWarning();
        }
        this.initDialog();
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file) {
        this(dialogType, accessType, file, null, null, null);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file, CertVerifier certVerifier) {
        this(dialogType, accessType, file, certVerifier, null, null);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, CertVerifier certVerifier) {
        this(dialogType, accessType, null, certVerifier, null, null);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, SecurityDialogs.AccessType accessType, JNLPFile file, Object[] extras) {
        this(dialogType, accessType, file, null, null, extras);
    }

    SecurityDialog(SecurityDialogs.DialogType dialogType, X509Certificate c) {
        this(dialogType, null, null, null, c, null);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static void showMoreInfoDialog(CertVerifier certVerifier, SecurityDialog parent) {
        JNLPFile file = parent.getFile();
        SecurityDialog dialog = new SecurityDialog(SecurityDialogs.DialogType.MORE_INFO, null, file, certVerifier);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showCertInfoDialog(CertVerifier certVerifier, SecurityDialog parent) {
        SecurityDialog dialog = new SecurityDialog(SecurityDialogs.DialogType.CERT_INFO, null, null, certVerifier);
        dialog.setLocationRelativeTo(parent);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showSingleCertInfoDialog(X509Certificate c, JDialog parent) {
        SecurityDialog dialog = new SecurityDialog(SecurityDialogs.DialogType.SINGLE_CERT_INFO, c);
        dialog.setLocationRelativeTo(parent);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.setVisible(true);
        dialog.dispose();
    }

    private void initDialog() {
        String dialogTitle = "";
        if (this.dialogType == SecurityDialogs.DialogType.CERT_WARNING) {
            dialogTitle = this.accessType == SecurityDialogs.AccessType.VERIFIED ? "Security Approval Required" : "Security Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.MORE_INFO) {
            dialogTitle = "More Information";
        } else if (this.dialogType == SecurityDialogs.DialogType.CERT_INFO) {
            dialogTitle = "Details - Certificate";
        } else if (this.dialogType == SecurityDialogs.DialogType.ACCESS_WARNING) {
            dialogTitle = "Security Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.APPLET_WARNING) {
            dialogTitle = "Applet Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.PARTIALLYSIGNED_WARNING) {
            dialogTitle = "Security Warning";
        } else if (this.dialogType == SecurityDialogs.DialogType.AUTHENTICATION) {
            dialogTitle = "Authentication Required";
        }
        this.setTitle(dialogTitle);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.setDefaultCloseOperation(2);
        this.installPanel();
        this.pack();
        SecurityDialog.centerDialog(this);
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    SecurityDialog.this.selectDefaultButton();
                    this.gotFocus = true;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (e.getSource() instanceof SecurityDialog) {
                    SecurityDialog dialog = (SecurityDialog)e.getSource();
                    dialog.setResizable(true);
                    dialog.setValue(null);
                }
            }
        };
        this.addWindowListener(adapter);
        this.addWindowFocusListener(adapter);
    }

    public SecurityDialogs.AccessType getAccessType() {
        return this.accessType;
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public CertVerifier getCertVerifier() {
        return this.certVerifier;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    private void installPanel() {
        if (this.dialogType == SecurityDialogs.DialogType.CERT_WARNING) {
            this.panel = new CertWarningPane(this, this.certVerifier, (JNLPClassLoader.SecurityDelegate)this.extras[0]);
        } else if (this.dialogType == SecurityDialogs.DialogType.MORE_INFO) {
            this.panel = new MoreInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.CERT_INFO) {
            this.panel = new CertsInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.SINGLE_CERT_INFO) {
            this.panel = new SingleCertInfoPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.ACCESS_WARNING) {
            this.panel = new AccessWarningPane(this, this.extras, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.APPLET_WARNING) {
            this.panel = new AppletWarningPane(this, this.certVerifier);
        } else if (this.dialogType == SecurityDialogs.DialogType.PARTIALLYSIGNED_WARNING) {
            this.panel = AppTrustWarningDialog.partiallySigned(this, this.file, (JNLPClassLoader.SecurityDelegate)this.extras[0]);
        } else if (this.dialogType == SecurityDialogs.DialogType.UNSIGNED_WARNING) {
            this.panel = AppTrustWarningDialog.unsigned(this, this.file);
        } else if (this.dialogType == SecurityDialogs.DialogType.AUTHENTICATION) {
            this.panel = new PasswordAuthenticationPane(this, this.extras);
        } else if (this.dialogType == SecurityDialogs.DialogType.UNSIGNED_EAS_NO_PERMISSIONS_WARNING) {
            this.panel = new MissingPermissionsAttributePanel(this, (String)this.extras[0], (String)this.extras[1]);
        } else if (this.dialogType == SecurityDialogs.DialogType.MISSING_ALACA) {
            this.panel = new MissingALACAttributePanel(this, (String)this.extras[0], (String)this.extras[1], (String)this.extras[2]);
        } else if (this.dialogType == SecurityDialogs.DialogType.MATCHING_ALACA) {
            this.panel = AppTrustWarningDialog.matchingAlaca(this, (JNLPFile)this.extras[0], (String)this.extras[1], (String)this.extras[2]);
        }
        this.add((Component)this.panel, "Center");
    }

    private static void centerDialog(JDialog dialog) {
        ScreenFinder.centerWindowsToCurrentScreen(dialog);
    }

    private void selectDefaultButton() {
        if (this.panel == null) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "initial value panel is null");
        }
        this.panel.requestFocusOnDefaultButton();
    }

    public void setValue(Object value) {
        OutputController.getLogger().log("Setting value:" + value);
        this.value = value;
    }

    public Object getValue() {
        OutputController.getLogger().log("Returning value:" + this.value);
        return this.value;
    }

    @Override
    public void dispose() {
        this.notifySelectionMade();
        super.dispose();
    }

    public void notifySelectionMade() {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(null);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public boolean requiresSignedJNLPWarning() {
        return this.requiresSignedJNLPWarning;
    }
}

