/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.stats;

import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.transform.node.incoming.BitrateCalculator;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.RateTracker;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/nlj/stats/PacketStreamStats;", "", "()V", "bitrate", "Lorg/jitsi/nlj/util/BitrateTracker;", "bytes", "Ljava/util/concurrent/atomic/AtomicLong;", "packetRate", "Lorg/jitsi/utils/stats/RateTracker;", "packets", "snapshot", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "update", "", "lengthInBytes", "", "Snapshot", "jitsi-media-transform"})
public final class PacketStreamStats {
    @NotNull
    private final BitrateTracker bitrate = BitrateCalculator.Companion.createBitrateTracker();
    @NotNull
    private final RateTracker packetRate = BitrateCalculator.Companion.createRateTracker();
    @NotNull
    private final AtomicLong bytes = new AtomicLong();
    @NotNull
    private final AtomicLong packets = new AtomicLong();

    public final void update(int lengthInBytes) {
        long now = System.currentTimeMillis();
        this.bitrate.update(DataSizeKt.getBytes(lengthInBytes), now);
        this.bytes.addAndGet(lengthInBytes);
        this.packetRate.update(1L, now);
        this.packets.incrementAndGet();
    }

    @NotNull
    public final Snapshot snapshot() {
        long now = System.currentTimeMillis();
        return new Snapshot(this.bitrate.getRate-WElJv5I(now), this.packetRate.getRate(now), this.bytes.get(), this.packets.get(), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "", "bitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "packetRate", "", "bytes", "packets", "(DJJJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getBitrate-rlWvAKk", "()D", "D", "getBytes", "()J", "getPacketRate", "getPackets", "getBitrateBps", "", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-media-transform"})
    public static final class Snapshot {
        private final double bitrate;
        private final long packetRate;
        private final long bytes;
        private final long packets;

        private Snapshot(double bitrate, long packetRate, long bytes, long packets2) {
            this.bitrate = bitrate;
            this.packetRate = packetRate;
            this.bytes = bytes;
            this.packets = packets2;
        }

        public final double getBitrate-rlWvAKk() {
            return this.bitrate;
        }

        public final long getPacketRate() {
            return this.packetRate;
        }

        public final long getBytes() {
            return this.bytes;
        }

        public final long getPackets() {
            return this.packets;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u2d0 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u2d0.put("bitrate_bps", (Object)this.bitrate);
            $this$toJson_u24lambda_u2d0.put("packetrate", (Object)this.packetRate);
            $this$toJson_u24lambda_u2d0.put("total_bytes", (Object)this.bytes);
            $this$toJson_u24lambda_u2d0.put("total_packets", (Object)this.packets);
            return orderedJsonObject;
        }

        public final double getBitrateBps() {
            return this.bitrate;
        }

        public /* synthetic */ Snapshot(double bitrate, long packetRate, long bytes, long packets2, DefaultConstructorMarker $constructor_marker) {
            this(bitrate, packetRate, bytes, packets2);
        }
    }
}

