/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0013H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/VideoMuteNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "()V", "forceMute", "", "getForceMute", "()Z", "setForceMute", "(Z)V", "numMutedPackets", "", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class VideoMuteNode
extends ObserverNode {
    private int numMutedPackets;
    private boolean forceMute;

    public VideoMuteNode() {
        super("Video mute node");
    }

    public final boolean getForceMute() {
        return this.forceMute;
    }

    public final void setForceMute(boolean bl) {
        this.forceMute = bl;
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (!(packetInfo.getPacket() instanceof VideoRtpPacket)) {
            return;
        }
        if (this.forceMute) {
            packetInfo.setShouldDiscard(true);
            int n = this.numMutedPackets;
            this.numMutedPackets = n + 1;
        }
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u2d0 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u2d0.addNumber("num_video_packets_discarded", this.numMutedPackets);
        $this$getNodeStats_u24lambda_u2d0.addBoolean("force_mute", this.forceMute);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        f.invoke();
    }
}

