/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor.conversion;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractCoordinateFormat
implements ICoordinateFormat {
    protected final String id;
    protected final String displayName;
    protected static final DecimalFormat cDdFormatter = AbstractCoordinateFormat.newUnlocalizedDecimalFormat("###0.0######");
    protected static final String SOUTH = I18n.trc("compass", "S");
    protected static final String NORTH = I18n.trc("compass", "N");
    protected static final String WEST = I18n.trc("compass", "W");
    protected static final String EAST = I18n.trc("compass", "E");

    protected AbstractCoordinateFormat(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public static DecimalFormat newUnlocalizedDecimalFormat(String pattern) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        format.applyPattern(pattern);
        return format;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

