/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.metrics.MetricsCapabilityBuildItem;
import io.quarkus.resteasy.reactive.server.deployment.ResteasyReactiveDeploymentBuildItem;
import io.quarkus.resteasy.reactive.server.runtime.observability.ObservabilityCustomizer;
import io.quarkus.resteasy.reactive.server.runtime.observability.ObservabilityIntegrationRecorder;
import io.quarkus.resteasy.reactive.server.spi.MethodScannerBuildItem;
import io.quarkus.vertx.http.deployment.FilterBuildItem;
import io.vertx.core.Handler;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.processor.scanning.MethodScanner;

public class ObservabilityProcessor {
    @BuildStep
    MethodScannerBuildItem methodScanner(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        boolean integrationNeeded = this.integrationNeeded(capabilities, metricsCapability);
        if (!integrationNeeded) {
            return null;
        }
        return new MethodScannerBuildItem(new MethodScanner(){

            public List<HandlerChainCustomizer> scan(MethodInfo method, ClassInfo actualEndpointClass, Map<String, Object> methodContext) {
                return Collections.singletonList(new ObservabilityCustomizer());
            }
        });
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    FilterBuildItem preAuthFailureFilter(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability, ObservabilityIntegrationRecorder recorder, ResteasyReactiveDeploymentBuildItem deployment) {
        boolean integrationNeeded = this.integrationNeeded(capabilities, metricsCapability);
        if (!integrationNeeded) {
            return null;
        }
        return FilterBuildItem.ofPreAuthenticationFailureHandler((Handler)recorder.preAuthFailureHandler(deployment.getDeployment()));
    }

    private boolean integrationNeeded(Capabilities capabilities, Optional<MetricsCapabilityBuildItem> metricsCapability) {
        return capabilities.isPresent("io.quarkus.opentelemetry.tracer") || metricsCapability.isPresent() && metricsCapability.get().metricsSupported("micrometer");
    }
}

