/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.storage.jpa.KeyUtils;

@NamedQueries(value={@NamedQuery(name="deleteUserSessionsByRealm", query="delete from PersistentUserSessionEntity sess where sess.realmId = :realmId"), @NamedQuery(name="deleteUserSessionsByUser", query="delete from PersistentUserSessionEntity sess where sess.userId = :userId"), @NamedQuery(name="deleteExpiredUserSessions", query="delete from PersistentUserSessionEntity sess where sess.realmId = :realmId AND sess.offline = :offline AND sess.lastSessionRefresh < :lastSessionRefresh"), @NamedQuery(name="updateUserSessionLastSessionRefresh", query="update PersistentUserSessionEntity sess set lastSessionRefresh = :lastSessionRefresh where sess.realmId = :realmId AND sess.offline = :offline AND sess.userSessionId IN (:userSessionIds)"), @NamedQuery(name="findUserSessionsCount", query="select count(sess) from PersistentUserSessionEntity sess where sess.offline = :offline"), @NamedQuery(name="findUserSessionsOrderedById", query="select sess from PersistentUserSessionEntity sess, RealmEntity realm where realm.id = sess.realmId AND sess.offline = :offline AND sess.userSessionId > :lastSessionId order by sess.userSessionId"), @NamedQuery(name="findUserSession", query="select sess from PersistentUserSessionEntity sess where sess.offline = :offline AND sess.userSessionId = :userSessionId AND sess.realmId = :realmId"), @NamedQuery(name="findUserSessionsByUserId", query="select sess from PersistentUserSessionEntity sess where sess.offline = :offline AND sess.realmId = :realmId AND sess.userId = :userId ORDER BY sess.userSessionId"), @NamedQuery(name="findUserSessionsByClientId", query="SELECT sess FROM PersistentUserSessionEntity sess INNER JOIN PersistentClientSessionEntity clientSess  ON sess.userSessionId = clientSess.userSessionId AND clientSess.clientId = :clientId WHERE sess.offline = :offline  AND sess.realmId = :realmId ORDER BY sess.userSessionId"), @NamedQuery(name="findUserSessionsByExternalClientId", query="SELECT sess FROM PersistentUserSessionEntity sess INNER JOIN PersistentClientSessionEntity clientSess  ON sess.userSessionId = clientSess.userSessionId AND clientSess.clientStorageProvider = :clientStorageProvider AND clientSess.externalClientId = :externalClientId WHERE sess.offline = :offline  AND sess.realmId = :realmId ORDER BY sess.userSessionId"), @NamedQuery(name="findClientSessionsClientIds", query="SELECT clientSess.clientId, clientSess.externalClientId, clientSess.clientStorageProvider, count(clientSess) FROM PersistentClientSessionEntity clientSess INNER JOIN PersistentUserSessionEntity sess ON clientSess.userSessionId = sess.userSessionId  WHERE sess.offline = :offline AND sess.realmId = :realmId  GROUP BY clientSess.clientId, clientSess.externalClientId, clientSess.clientStorageProvider")})
@Table(name="OFFLINE_USER_SESSION")
@Entity
@IdClass(value=Key.class)
@EnhancementInfo(version="6.2.13.Final")
public class PersistentUserSessionEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    @Id
    @Column(name="USER_SESSION_ID", length=36)
    protected String userSessionId;
    @Column(name="REALM_ID", length=36)
    protected String realmId;
    @Column(name="USER_ID", length=255)
    protected String userId;
    @Column(name="CREATED_ON")
    protected int createdOn;
    @Column(name="LAST_SESSION_REFRESH")
    protected int lastSessionRefresh;
    @Id
    @Column(name="OFFLINE_FLAG")
    protected String offline;
    @Column(name="DATA")
    protected String data;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public String getUserSessionId() {
        return this.$$_hibernate_read_userSessionId();
    }

    public void setUserSessionId(String userSessionId) {
        this.$$_hibernate_write_userSessionId(userSessionId);
    }

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
    }

    public String getUserId() {
        return this.$$_hibernate_read_userId();
    }

    public void setUserId(String userId) {
        KeyUtils.assertValidKey((String)userId);
        this.$$_hibernate_write_userId(userId);
    }

    public int getCreatedOn() {
        return this.$$_hibernate_read_createdOn();
    }

    public void setCreatedOn(int createdOn) {
        this.$$_hibernate_write_createdOn(createdOn);
    }

    public int getLastSessionRefresh() {
        return this.$$_hibernate_read_lastSessionRefresh();
    }

    public void setLastSessionRefresh(int lastSessionRefresh) {
        this.$$_hibernate_write_lastSessionRefresh(lastSessionRefresh);
    }

    public String getOffline() {
        return this.$$_hibernate_read_offline();
    }

    public void setOffline(String offline) {
        this.$$_hibernate_write_offline(offline);
    }

    public String getData() {
        return this.$$_hibernate_read_data();
    }

    public void setData(String data) {
        this.$$_hibernate_write_data(data);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        PersistentUserSessionEntity persistentUserSessionEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        PersistentUserSessionEntity persistentUserSessionEntity = this;
        persistentUserSessionEntity = null;
        persistentUserSessionEntity = NoopCollectionTracker.INSTANCE;
        return persistentUserSessionEntity;
    }

    public String $$_hibernate_read_userSessionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userSessionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "userSessionId", (Object)this.userSessionId);
        }
        return this.userSessionId;
    }

    public void $$_hibernate_write_userSessionId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userSessionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userSessionId", (Object)this.userSessionId, (Object)string);
            return;
        }
        this.userSessionId = string;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"realmId", (Object)string, (Object)this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_userId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "userId", (Object)this.userId);
        }
        return this.userId;
    }

    public void $$_hibernate_write_userId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"userId", (Object)string, (Object)this.userId)) {
            this.$$_hibernate_trackChange("userId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.userId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "userId", (Object)this.userId, (Object)string);
            return;
        }
        this.userId = string;
    }

    public int $$_hibernate_read_createdOn() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdOn = this.$$_hibernate_getInterceptor().readInt((Object)this, "createdOn", this.createdOn);
        }
        return this.createdOn;
    }

    public void $$_hibernate_write_createdOn(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"createdOn", (int)n, (int)this.createdOn)) {
            this.$$_hibernate_trackChange("createdOn");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.createdOn = this.$$_hibernate_getInterceptor().writeInt((Object)this, "createdOn", this.createdOn, n);
            return;
        }
        this.createdOn = n;
    }

    public int $$_hibernate_read_lastSessionRefresh() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastSessionRefresh = this.$$_hibernate_getInterceptor().readInt((Object)this, "lastSessionRefresh", this.lastSessionRefresh);
        }
        return this.lastSessionRefresh;
    }

    public void $$_hibernate_write_lastSessionRefresh(int n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"lastSessionRefresh", (int)n, (int)this.lastSessionRefresh)) {
            this.$$_hibernate_trackChange("lastSessionRefresh");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.lastSessionRefresh = this.$$_hibernate_getInterceptor().writeInt((Object)this, "lastSessionRefresh", this.lastSessionRefresh, n);
            return;
        }
        this.lastSessionRefresh = n;
    }

    public String $$_hibernate_read_offline() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offline = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "offline", (Object)this.offline);
        }
        return this.offline;
    }

    public void $$_hibernate_write_offline(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.offline = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "offline", (Object)this.offline, (Object)string);
            return;
        }
        this.offline = string;
    }

    public String $$_hibernate_read_data() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.data = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "data", (Object)this.data);
        }
        return this.data;
    }

    public void $$_hibernate_write_data(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"data", (Object)string, (Object)this.data)) {
            this.$$_hibernate_trackChange("data");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.data = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "data", (Object)this.data, (Object)string);
            return;
        }
        this.data = string;
    }

    public static class Key
    implements Serializable {
        protected String userSessionId;
        protected String offline;

        public Key() {
        }

        public Key(String userSessionId, String offline) {
            this.userSessionId = userSessionId;
            this.offline = offline;
        }

        public String getUserSessionId() {
            return this.userSessionId;
        }

        public String getOffline() {
            return this.offline;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userSessionId != null ? !this.userSessionId.equals(key.userSessionId) : key.userSessionId != null) {
                return false;
            }
            return !(this.offline != null ? !this.offline.equals(key.offline) : key.offline != null);
        }

        public int hashCode() {
            int result = this.userSessionId != null ? this.userSessionId.hashCode() : 0;
            result = 31 * result + (this.offline != null ? this.offline.hashCode() : 0);
            return result;
        }
    }
}

